/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultCopyHandler;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.SimanticsClipboardBuilder;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.diagram.profile.ProfileActivityBean;
import org.simantics.diagram.profile.ProfileActivityBeanRequest;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.datastructures.Arrays;
import org.simantics.utils.datastructures.hints.IHintContext;

public class Profiles {
    public static Resource createProfile(WriteGraph graph, String profileName, Resource ... entries) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ArrayList ee = new ArrayList();
        Arrays.addAll(ee, (Object[])entries);
        Resource list = ListUtils.create((WriteGraph)graph, (Resource)DIA.Profile, ee);
        Resource profile = ListUtils.create((WriteGraph)graph, (Resource)DIA.Profile, (Resource[])new Resource[0]);
        graph.claimLiteral(profile, L0.HasName, (Object)profileName);
        graph.claim(profile, DIA.HasEntries, null, list);
        return profile;
    }

    public static Resource createEntry(WriteGraph graph, String name, Resource style, Resource group) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource entry = graph.newResource();
        graph.claim(entry, L0.InstanceOf, null, DIA.GroupStyleProfileEntry);
        graph.claimLiteral(entry, L0.HasName, (Object)name);
        graph.claimLiteral(entry, L0.HasLabel, (Object)name);
        graph.claim(entry, DIA.ProfileEntry_HasStyle, style);
        graph.claim(entry, DIA.ProfileEntry_HasGroup, group);
        return entry;
    }

    public static Resource createContainerProfile(WriteGraph graph, String name, Resource ... children) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource profile = graph.newResource();
        graph.claim(profile, L0.InstanceOf, null, DIA.Profile);
        graph.claim(profile, L0.Abstract, profile);
        graph.claimLiteral(profile, L0.HasName, (Object)name);
        graph.claimLiteral(profile, L0.HasLabel, (Object)name);
        ArrayList cd = new ArrayList();
        Arrays.addAll(cd, (Object[])children);
        graph.claim(profile, DIA.HasEntries, null, ListUtils.create((WriteGraph)graph, (Resource)DIA.Profile, cd));
        return profile;
    }

    public static Variable getMappedVariable(ReadGraph graph, Resource runtimeDiagram, Resource element) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        String variableURI = (String)graph.getPossibleRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasVariable, (Binding)Bindings.STRING);
        Variable activeVariable = Variables.getVariable((ReadGraph)graph, (String)variableURI);
        Resource module = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (module == null) {
            return null;
        }
        return activeVariable.browse(graph, module);
    }

    public static Resource[] getProfileEntries(ReadGraph graph, Resource profile) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource list = graph.getSingleObject(profile, DIA.HasEntries);
        List entries = ListUtils.toList((ReadGraph)graph, (Resource)list);
        return entries.toArray(new Resource[entries.size()]);
    }

    public static void addProfiles(WriteGraph graph, Resource model, Resource sourceProfile) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource profile = null;
        profile = graph.isInstanceOf(sourceProfile, DIA.ConfigurableProfile) ? Profiles.copyProfiles(graph, model, sourceProfile) : Profiles.initProfiles(graph, model, sourceProfile);
        graph.claim(model, DIA.HasProfile, profile);
        graph.claim(model, L0.ConsistsOf, profile);
        graph.claim(model, DIA.HasActiveProfile, profile);
    }

    public static void addProfiles(WriteGraph graph, Resource model, String name, Resource ... profileEntries) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource profile = null;
        profile = Profiles.initProfiles(graph, model, name, profileEntries);
        graph.claim(model, DIA.HasProfile, profile);
        graph.claim(model, L0.ConsistsOf, profile);
        graph.claim(model, DIA.HasActiveProfile, profile);
    }

    private static Resource initProfiles(WriteGraph graph, Resource model, Resource profile) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource[] entries = Profiles.getProfileEntries((ReadGraph)graph, profile);
        String name = "Profile";
        String label = (String)graph.getPossibleRelatedValue(profile, L0.HasLabel, (Binding)Bindings.STRING);
        if (label != null && label.length() > 0) {
            name = label;
        }
        return Profiles.initProfiles(graph, model, name, entries);
    }

    private static Resource initProfiles(WriteGraph graph, Resource model, String name, Resource[] entries) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        int i = 0;
        while (i < entries.length) {
            Resource entry = entries[i];
            if (graph.isInstanceOf(entry, DIA.ConfigurableProfile)) {
                entries[i] = Profiles.copyProfiles(graph, model, entry);
            }
            ++i;
        }
        return Profiles.createProfile2(graph, name, entries);
    }

    private static Resource createProfile2(WriteGraph graph, String name, Resource[] entries) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource profile = Profiles.createProfile(graph, name, entries);
        final ArrayList<Resource> enabled = new ArrayList<Resource>();
        Resource[] resourceArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (graph.hasStatement(r, DIA.Profile_defaultEnabled)) {
                enabled.add(r);
            }
            ++n2;
        }
        if (enabled.size() > 0) {
            final Resource p = profile;
            VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
            graph.syncRequest((Write)new WriteRequest(support.getWorkspacePersistent("profiles")){

                public void perform(WriteGraph graph) throws DatabaseException {
                    SimulationResource SIM = SimulationResource.getInstance((ReadGraph)graph);
                    for (Resource r : enabled) {
                        graph.claim(p, SIM.IsActive, r);
                    }
                }
            });
        }
        return profile;
    }

    private static Resource copyProfiles(WriteGraph graph, Resource model, Resource profile) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource[] entries = Profiles.getProfileEntries((ReadGraph)graph, profile);
        HashMap<Resource, Resource> groupMap = new HashMap<Resource, Resource>();
        int i = 0;
        while (i < entries.length) {
            Resource entry = entries[i];
            if (graph.isInstanceOf(entry, DIA.Profile)) {
                entries[i] = Profiles.initProfiles(graph, model, entry);
            } else if (graph.isInstanceOf(entry, DIA.ConfigurableProfile)) {
                entries[i] = Profiles.copyProfiles(graph, model, entry);
            } else if (graph.isInstanceOf(entry, DIA.ProfileEntry)) {
                entries[i] = Profiles.copyProfileEntry(graph, entry, groupMap);
            }
            ++i;
        }
        String name = "Profile";
        String label = (String)graph.getPossibleRelatedValue(profile, L0.HasLabel, (Binding)Bindings.STRING);
        if (label != null && label.length() > 0) {
            name = label;
        }
        return Profiles.createProfile2(graph, name, entries);
    }

    private static Resource copyProfileEntry(WriteGraph graph, Resource entry, Map<Resource, Resource> groupMap) throws DatabaseException {
        Resource style;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(entry, L0.HasLabel, (Binding)Bindings.STRING);
        Resource group = graph.getSingleObject(entry, DIA.ProfileEntry_HasGroup);
        Resource copyGroup = groupMap.get(group);
        if (copyGroup == null) {
            copyGroup = Profiles.copyProfileGroup(graph, group);
            groupMap.put(group, copyGroup);
        }
        if (!graph.isInstanceOf(style = graph.getSingleObject(entry, DIA.ProfileEntry_HasStyle), DIA.Style)) {
            style = Profiles.createProfileStyle(graph, style);
        }
        Resource instance = Profiles.createEntry(graph, name, style, copyGroup);
        graph.claim(instance, L0.InstanceOf, entry);
        Double priority = (Double)graph.getPossibleRelatedValue(entry, DIA.ProfileEntry_HasPriority, (Binding)Bindings.DOUBLE);
        if (priority != null) {
            graph.claimLiteral(instance, DIA.ProfileEntry_HasPriority, (Object)priority, (Binding)Bindings.DOUBLE);
        }
        for (Resource template : graph.getObjects(entry, DIA.HasTemplate)) {
            SimanticsClipboardImpl builder = new SimanticsClipboardImpl();
            DefaultCopyHandler handler = new DefaultCopyHandler(template);
            DefaultPasteImportAdvisor advisor = new DefaultPasteImportAdvisor(instance){

                public Resource createRoot(WriteOnlyGraph graph, Root root, Resource resource) throws DatabaseException {
                    Layer0 l0 = (Layer0)graph.getService(Layer0.class);
                    DiagramResource DIA = (DiagramResource)graph.getService(DiagramResource.class);
                    if (resource == null) {
                        resource = graph.newResource();
                    }
                    graph.claim(this.library, DIA.HasTemplate, DIA.HasTemplate_Inverse, resource);
                    String newName = this.getName(root);
                    graph.addLiteral(resource, l0.HasName, l0.NameOf, l0.String, (Object)newName, (Binding)Bindings.STRING);
                    this.addRootInfo(root, newName, resource);
                    return resource;
                }
            };
            handler.copyToClipboard((ReadGraph)graph, (SimanticsClipboardBuilder)builder);
            for (Set object : builder.getContents()) {
                TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((ReadGraph)graph, (Set)object, (IHintContext.Key)SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
                TransferableGraphs.importGraph1((WriteGraph)graph, (TransferableGraph1)tg, (IImportAdvisor)advisor);
            }
        }
        return instance;
    }

    private static Resource copyProfileGroup(WriteGraph graph, Resource group) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource instance = graph.newResource();
        for (Resource type : graph.getObjects(group, L0.InstanceOf)) {
            graph.claim(instance, L0.InstanceOf, type);
        }
        Resource referredType = graph.getPossibleObject(group, DIA.TypeGroup_HasType);
        if (referredType != null) {
            graph.claim(instance, DIA.TypeGroup_HasType, referredType);
        }
        return instance;
    }

    private static Resource createProfileStyle(WriteGraph graph, Resource style) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource instance = graph.newResource();
        graph.claim(instance, L0.InstanceOf, style);
        return instance;
    }

    public static ProfileActivityBean readProfileActivity(RequestProcessor processor, Resource root) throws DatabaseException {
        return (ProfileActivityBean)processor.syncRequest((Read)new ProfileActivityBeanRequest(root));
    }

    public static ProfileActivityBean readProfileActivity(RequestProcessor processor, Resource root, Map<String, Variant> writeToMap) throws DatabaseException {
        ProfileActivityBean pab = Profiles.readProfileActivity(processor, root);
        if (pab != null && writeToMap != null) {
            writeToMap.put(ProfileActivityBean.EXTENSION_KEY, new Variant(ProfileActivityBean.BINDING, (Object)pab));
        }
        return pab;
    }

    public static void writeProfileActivity(RequestProcessor processor, final Resource root, final ProfileActivityBean bean) throws DatabaseException {
        VirtualGraph vg = ((VirtualGraphSupport)processor.getService(VirtualGraphSupport.class)).getWorkspacePersistent("profiles");
        processor.syncRequest((Write)new WriteRequest(vg){

            public void perform(WriteGraph graph) throws DatabaseException {
                Profiles.writeProfileActivity(graph, root, bean);
            }
        });
    }

    private static void writeProfileActivity(WriteGraph graph, Resource root, ProfileActivityBean bean) throws DatabaseException {
        String rootUri = graph.getPossibleURI(root);
        if (rootUri == null) {
            return;
        }
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        for (ProfileActivityBean.Profile p : bean.topLevelProfiles.values()) {
            Resource pr = Profiles.resolveRelativeUri((ReadGraph)graph, rootUri, p.relativeUri);
            if (pr == null) continue;
            for (String active : p.activeEntries) {
                Resource ar = Profiles.resolveRelativeUri((ReadGraph)graph, rootUri, active);
                if (ar == null) continue;
                graph.claim(pr, SIMU.IsActive, ar);
            }
        }
        Resource activeProfile = Profiles.resolveRelativeUri((ReadGraph)graph, rootUri, bean.activeProfile);
        if (activeProfile != null) {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            graph.claim(root, DIA.HasActiveProfile, DIA.HasActiveProfile_Inverse, activeProfile);
        }
    }

    static String possiblyRelativeUri(ReadGraph graph, String rootUri, Resource r) throws DatabaseException {
        if (r == null) {
            return null;
        }
        String uri = graph.getPossibleURI(r);
        if (rootUri != null && uri != null && uri.startsWith(rootUri)) {
            return uri.substring(rootUri.length());
        }
        return uri;
    }

    static Resource resolveRelativeUri(ReadGraph graph, String rootUri, String possiblyRelativeUri) throws DatabaseException {
        return possiblyRelativeUri != null ? graph.getPossibleResource(Profiles.resolveRelativeUri(rootUri, possiblyRelativeUri)) : null;
    }

    private static String resolveRelativeUri(String rootUri, String possiblyRelativeUri) {
        return possiblyRelativeUri.startsWith("http:/") ? possiblyRelativeUri : String.valueOf(rootUri) + possiblyRelativeUri;
    }
}

