/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.profile.TextStyle;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;

public abstract class ComponentTextStyle
extends TextStyle {
    public ComponentTextStyle() {
    }

    public ComponentTextStyle(double xOffset, double yOffset) {
        super(xOffset, yOffset);
    }

    @Override
    protected Resource getConfigurationComponent(ReadGraph graph, Resource element) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource component = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (component != null) {
            return component;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(element, DIA.Flag) && FlagUtil.isExternal(graph, element)) {
            for (Resource connector : graph.getObjects(element, DIA.Flag_ConnectionPoint)) {
                Resource connection = ConnectionUtil.getConnection(graph, connector);
                component = graph.getPossibleObject(connection, MOD.ElementToComponent);
                if (component == null) continue;
                return component;
            }
        }
        return null;
    }
}

