/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant;

import gnu.trove.map.hash.THashMap;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ServiceLocator;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteGraphConnectionClass;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.delta.RouteGraphDelta;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.PlainLineEndStyle;
import org.simantics.diagram.content.ResourceTerminal;
import org.simantics.diagram.participant.ConnectionBuilder;
import org.simantics.diagram.participant.ControlPoint;
import org.simantics.diagram.participant.RouteGraphConnectTool;
import org.simantics.diagram.participant.RouteGraphTarget;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.RouteGraphConnection;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.connection.IConnectionAdvisor;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.TerminalPainter;
import org.simantics.g2d.diagram.participant.pointertool.AbstractMode;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.impl.BranchPointTerminal;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.elementclass.BranchPoint;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.elementclass.FlagHandler;
import org.simantics.g2d.participant.RenderingQualityInteractor;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.utils.geom.DirectionSet;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.BranchPointNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.Quality;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.logging.TimeLogger;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class ConnectTool2
extends AbstractMode {
    public static final int PAINT_PRIORITY = 15;
    @DependencyReflection.Reference
    protected RenderingQualityInteractor quality;
    @DependencyReflection.Dependency
    protected TransformUtil util;
    @DependencyReflection.Dependency
    protected ElementPainter diagramPainter;
    @DependencyReflection.Dependency
    protected PointerInteractor pi;
    @DependencyReflection.Dependency
    protected PickContext pickContext;
    protected List<TerminalUtil.TerminalInfo> startTerminals;
    protected TerminalUtil.TerminalInfo startTerminal;
    protected TerminalUtil.TerminalInfo startFlag;
    protected final Point2D startPos;
    protected boolean createFlags;
    protected IElementClassProvider elementClassProvider;
    protected Deque<ControlPoint> controlPoints = new ArrayDeque<ControlPoint>();
    protected TerminalUtil.TerminalInfo selectedStartTerminal;
    protected TerminalUtil.TerminalInfo endTerminal;
    protected ConnectionJudgement connectionJudgment;
    protected ConnectionJudgement attachToConnectionJudgement;
    private BranchPoint.Direction forcedBranchPointDirection;
    protected Collection<Topology.Terminal> terminals = new ArrayList<Topology.Terminal>();
    protected Point2D lastMouseCanvasPos = new Point2D.Double();
    protected boolean mouseHasMoved = false;
    protected TerminalPainter.TerminalHoverStrategy originalStrategy = null;
    protected TerminalPainter.TerminalHoverStrategy terminalHoverStrategy = new TerminalPainter.TerminalHoverStrategy(){

        public boolean highlightEnabled() {
            return !ConnectTool2.this.isEndingInFlag();
        }

        public boolean highlight(TerminalUtil.TerminalInfo ti) {
            boolean reflexive = ConnectTool2.this.isStartTerminal(ti.e, ti.t);
            if (reflexive && !ConnectTool2.this.allowReflexiveConnections()) {
                return false;
            }
            return ConnectTool2.this.canConnect(ti.e, ti.t) != null;
        }
    };
    protected static final Composite ALPHA_COMPOSITE = AlphaComposite.getInstance(3, 0.75f);
    protected G2DParentNode ghostNode;
    protected TerminalUtil.TerminalInfo endFlag;
    protected G2DParentNode endFlagNode;
    private RouteGraphTarget lastRouteGraphTarget;
    private int mouseLeftReleaseCount = 0;

    public ConnectTool2(TerminalUtil.TerminalInfo startTerminal, int mouseId, Point2D startCanvasPos) {
        this(startTerminal == null ? Collections.emptyList() : Collections.singletonList(startTerminal), mouseId, startCanvasPos);
    }

    public ConnectTool2(List<TerminalUtil.TerminalInfo> startTerminals, int mouseId, Point2D startCanvasPos) {
        super(mouseId);
        if (startCanvasPos == null) {
            throw new NullPointerException("null start position");
        }
        if (startTerminals == null) {
            throw new NullPointerException("null start terminals");
        }
        this.startPos = startCanvasPos;
        this.lastMouseCanvasPos.setLocation(this.startPos);
        this.startTerminals = startTerminals;
        this.startTerminal = startTerminals.isEmpty() ? null : startTerminals.get(0);
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        if (this.quality != null) {
            this.quality.setStaticQuality(Quality.LOW);
        }
        this.originalStrategy = (TerminalPainter.TerminalHoverStrategy)this.getHint(TerminalPainter.TERMINAL_HOVER_STRATEGY);
        this.setHint(TerminalPainter.TERMINAL_HOVER_STRATEGY, this.terminalHoverStrategy);
    }

    protected void onDiagramSet(IDiagram newDiagram, IDiagram oldDiagram) {
        if (newDiagram != null) {
            ISynchronizationContext ctx = (ISynchronizationContext)newDiagram.getHint(SynchronizationHints.CONTEXT);
            if (ctx != null) {
                this.elementClassProvider = (IElementClassProvider)ctx.get(SynchronizationHints.ELEMENT_CLASS_PROVIDER);
            }
            this.createFlags = Boolean.TRUE.equals(newDiagram.getHint(DiagramHints.KEY_USE_CONNECTION_FLAGS));
            this.startConnection();
        }
    }

    public void removedFromContext(ICanvasContext ctx) {
        if (this.getHint(TerminalPainter.TERMINAL_HOVER_STRATEGY) == this.terminalHoverStrategy) {
            if (this.originalStrategy != null) {
                this.setHint(TerminalPainter.TERMINAL_HOVER_STRATEGY, this.originalStrategy);
            } else {
                this.removeHint(TerminalPainter.TERMINAL_HOVER_STRATEGY);
            }
        }
        if (this.quality != null) {
            this.quality.setStaticQuality(null);
        }
        super.removedFromContext(ctx);
    }

    protected void startConnection() {
        Point2D startPos = (Point2D)this.startPos.clone();
        ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR);
        if (snapAdvisor != null) {
            snapAdvisor.snap(startPos);
        }
        ControlPoint start = new ControlPoint(startPos);
        if (this.startTerminal != null) {
            assert (ElementUtils.peekDiagram((IElement)this.startTerminal.e) == this.diagram);
            Point2D.Double terminalPos = new Point2D.Double(this.startTerminal.posDia.getTranslateX(), this.startTerminal.posDia.getTranslateY());
            start.setPosition(terminalPos).setAttachedToTerminal(this.startTerminal);
        } else if (this.createFlags) {
            this.startFlag = this.createFlag(EdgeVisuals.EdgeEnd.Begin);
            start.setAttachedToTerminal(this.startFlag);
            this.showElement(this.ghostNode, "startFlag", this.startFlag.e, startPos);
        }
        this.controlPoints.add(start);
        this.controlPoints.add(new ControlPoint(startPos));
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.ghostNode = (G2DParentNode)parent.addNode(G2DParentNode.class);
        this.ghostNode.setZIndex(15);
        ShapeNode pathNode = (ShapeNode)this.ghostNode.getOrCreateNode("path", ShapeNode.class);
        pathNode.setColor((Paint)new Color(160, 0, 0));
        pathNode.setStroke((Stroke)new BasicStroke(0.1f, 0, 0, 10.0f, new float[]{0.5f, 0.2f}, 0.0f));
        pathNode.setScaleStroke(false);
        pathNode.setZIndex(0);
        G2DParentNode points = (G2DParentNode)this.ghostNode.getOrCreateNode("points", G2DParentNode.class);
        points.setZIndex(1);
        this.updateSG();
    }

    private RouteTerminal addControlPoint(RouteGraph routeGraph, ControlPoint cp) {
        TerminalUtil.TerminalInfo ti = cp.getAttachedTerminal();
        if (ti != null && ti != this.startFlag && ti != this.endFlag) {
            Rectangle2D bounds = ElementUtils.getElementBoundsOnDiagram((IElement)ti.e, (Rectangle2D)new Rectangle2D.Double());
            GeometryUtils.expandRectangle((Rectangle2D)bounds, (double)2.0);
            int allowedDirections = RouteGraphConnectionClass.shortestDirectionOutOfBounds(ti.posDia.getTranslateX(), ti.posDia.getTranslateY(), bounds);
            return routeGraph.addTerminal(ti.posDia.getTranslateX(), ti.posDia.getTranslateY(), bounds, allowedDirections, (ILineEndStyle)PlainLineEndStyle.INSTANCE);
        }
        double x = cp.getPosition().getX();
        double y = cp.getPosition().getY();
        int allowedDirections = 15;
        switch (cp.getDirection()) {
            case Horizontal: {
                allowedDirections = 5;
                break;
            }
            case Vertical: {
                allowedDirections = 10;
                break;
            }
            case Any: {
                allowedDirections = 15;
            }
        }
        return routeGraph.addTerminal(x, y, x, y, x, y, allowedDirections);
    }

    protected void updateSG() {
        if (this.controlPoints.size() != 2) {
            return;
        }
        ControlPoint begin = this.controlPoints.getFirst();
        ControlPoint end = this.controlPoints.getLast();
        RouteGraph routeGraph = new RouteGraph();
        RouteTerminal a = this.addControlPoint(routeGraph, begin);
        RouteTerminal b = this.addControlPoint(routeGraph, end);
        routeGraph.link(a, b);
        Path2D path = routeGraph.getPath2D();
        ShapeNode pathNode = (ShapeNode)this.ghostNode.getOrCreateNode("path", ShapeNode.class);
        pathNode.setShape((Shape)path);
        this.setDirty();
    }

    private G2DParentNode showElement(G2DParentNode parent, String nodeId, IElement element, Point2D pos) {
        return this.showElement(parent, nodeId, element, AffineTransform.getTranslateInstance(pos.getX(), pos.getY()));
    }

    private G2DParentNode showElement(G2DParentNode parent, String nodeId, IElement element, AffineTransform tr) {
        G2DParentNode elementParent = (G2DParentNode)parent.getOrCreateNode(nodeId, G2DParentNode.class);
        elementParent.setTransform(tr);
        elementParent.removeNodes();
        for (SceneGraph sg : element.getElementClass().getItemsByClass(SceneGraph.class)) {
            sg.init(element, elementParent);
        }
        return elementParent;
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        this.ghostNode.remove();
        this.ghostNode = null;
    }

    @EventHandlerReflection.EventHandler(priority=200)
    public boolean handleCommandEvents(CommandEvent ce) {
        if (ce.command.equals((Object)Commands.CANCEL)) {
            this.setDirty();
            this.remove();
            return true;
        }
        if (ce.command.equals((Object)Commands.ROTATE_ELEMENT_CCW) || ce.command.equals((Object)Commands.ROTATE_ELEMENT_CW)) {
            return this.rotateLastBranchPoint(ce.command.equals((Object)Commands.ROTATE_ELEMENT_CW));
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=2097172)
    public boolean handleKeyEvents(KeyEvent ke) {
        if (ke instanceof KeyEvent.KeyPressedEvent && ke.keyCode == 8) {
            return this.cancelPreviousBend();
        }
        if (ke.keyCode == 18 && this.createFlags) {
            this.endWithoutTerminal(this.lastMouseCanvasPos, this.shouldEndWithFlag(ke instanceof KeyEvent.KeyPressedEvent));
            return true;
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=2097172)
    public boolean handleEvent(MouseEvent me) {
        if (me.mouseId != this.mouseId) {
            return false;
        }
        if (me instanceof MouseEvent.MouseMovedEvent) {
            return this.processMouseMove((MouseEvent.MouseMovedEvent)me);
        }
        if (me instanceof MouseEvent.MouseButtonPressedEvent) {
            return this.processMouseButtonPress((MouseEvent.MouseButtonPressedEvent)me);
        }
        if (me instanceof MouseEvent.MouseButtonReleasedEvent) {
            return this.processMouseButtonRelease((MouseEvent.MouseButtonReleasedEvent)me);
        }
        return false;
    }

    protected boolean processMouseMove(MouseEvent.MouseMovedEvent me) {
        this.mouseHasMoved = true;
        Point2D mouseControlPos = me.controlPosition;
        Point2D mouseCanvasPos = this.util.controlToCanvas(mouseControlPos, (Point2D)new Point2D.Double());
        ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR);
        if (snapAdvisor != null) {
            snapAdvisor.snap(mouseCanvasPos);
        }
        this.lastMouseCanvasPos.setLocation(mouseCanvasPos);
        if (this.isEndingInFlag()) {
            this.endFlagNode.setTransform(AffineTransform.getTranslateInstance(mouseCanvasPos.getX(), mouseCanvasPos.getY()));
        }
        List tis = this.pi.pickTerminals(me.controlPosition);
        if (!(tis = TerminalUtil.findNearestOverlappingTerminals((List)tis)).isEmpty() && !this.containsStartTerminal(tis)) {
            for (TerminalUtil.TerminalInfo ti : tis) {
                Pair<ConnectionJudgement, TerminalUtil.TerminalInfo> canConnect = this.canConnect(ti.e, ti.t);
                if (canConnect == null) continue;
                this.connectionJudgment = (ConnectionJudgement)canConnect.first;
                if (!this.isEndingInFlag() || !TerminalUtil.isSameTerminal((TerminalUtil.TerminalInfo)ti, (TerminalUtil.TerminalInfo)this.endTerminal)) {
                    if (canConnect.second != null) {
                        this.controlPoints.getFirst().setPosition(((TerminalUtil.TerminalInfo)canConnect.second).posDia).setAttachedToTerminal((TerminalUtil.TerminalInfo)canConnect.second);
                    }
                    this.controlPoints.getLast().setPosition(ti.posDia).setAttachedToTerminal(ti);
                    this.selectedStartTerminal = (TerminalUtil.TerminalInfo)canConnect.second;
                    this.endTerminal = ti;
                }
                if (!this.endWithoutTerminal(this.lastMouseCanvasPos, this.shouldEndWithFlag((MouseEvent)me))) {
                    this.updateSG();
                }
                return false;
            }
        } else {
            RouteGraphTarget cp = RouteGraphConnectTool.pickRouteGraphConnection(this.diagram, this.pi.getCanvasPickShape(me.controlPosition), this.pi.getPickDistance());
            if (cp != null) {
                if (this.lastRouteGraphTarget != null && cp.getNode() != this.lastRouteGraphTarget.getNode()) {
                    cp.getNode().showBranchPoint(null);
                }
                this.lastRouteGraphTarget = cp;
                Point2D isectPos = cp.getIntersectionPosition();
                TerminalUtil.TerminalInfo ti = TerminalUtil.TerminalInfo.create((Point2D)isectPos, (IElement)cp.getElement(), (Topology.Terminal)BranchPointTerminal.existingTerminal((Point2D)isectPos, (DirectionSet)DirectionSet.ANY, (Shape)BranchPointNode.SHAPE), (Shape)BranchPointNode.SHAPE);
                Pair<ConnectionJudgement, TerminalUtil.TerminalInfo> canConnect = this.canConnect(ti.e, ti.t);
                if (canConnect != null) {
                    this.attachToConnectionJudgement = (ConnectionJudgement)canConnect.first;
                    this.controlPoints.getLast().setPosition(ti.posDia).setAttachedToTerminal(ti);
                    this.endTerminal = ti;
                    cp.getNode().showBranchPoint(isectPos);
                    if (!this.endWithoutTerminal(this.lastMouseCanvasPos, this.shouldEndWithFlag((MouseEvent)me))) {
                        this.updateSG();
                    }
                    return false;
                }
            } else if (this.lastRouteGraphTarget != null) {
                this.lastRouteGraphTarget.getNode().showBranchPoint(null);
                this.lastRouteGraphTarget = null;
            }
        }
        this.connectionJudgment = null;
        this.attachToConnectionJudgement = null;
        if (this.isEndTerminalDefined()) {
            this.controlPoints.getLast().setPosition(mouseCanvasPos).setDirection(this.calculateCurrentBranchPointDirection()).setAttachedToTerminal(null);
            this.endTerminal = null;
        } else {
            this.controlPoints.getLast().setPosition(mouseCanvasPos).setDirection(this.calculateCurrentBranchPointDirection());
        }
        if (!this.endWithoutTerminal(this.lastMouseCanvasPos, this.shouldEndWithFlag((MouseEvent)me))) {
            this.updateSG();
        }
        return false;
    }

    protected boolean processMouseButtonPress(MouseEvent.MouseButtonPressedEvent e) {
        MouseEvent.MouseButtonPressedEvent me = e;
        if (!this.mouseHasMoved) {
            return true;
        }
        if (me.button == 1) {
            Point2D mouseControlPos = me.controlPosition;
            Point2D mouseCanvasPos = this.util.getInverseTransform().transform(mouseControlPos, new Point2D.Double());
            ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR);
            if (snapAdvisor != null) {
                snapAdvisor.snap(mouseCanvasPos);
            }
            if (this.tryEndConnection()) {
                return true;
            }
            if (me.hasAnyModifier(8704) && !this.startTerminals.isEmpty()) {
                Pair<ConnectionJudgement, TerminalUtil.TerminalInfo> pair = this.canConnect(null, null);
                if (pair != null) {
                    this.connectionJudgment = (ConnectionJudgement)pair.first;
                    this.selectedStartTerminal = (TerminalUtil.TerminalInfo)pair.second;
                    this.createConnection();
                    this.setDirty();
                    this.remove();
                } else {
                    String tmsg = this.terminalsToString(this.startTerminals);
                    ErrorLogger.defaultLogWarning((String)("Can't resolve connection type for new connection when starting from one of the following terminals:\n" + tmsg), null);
                }
                return true;
            }
            if (this.routePointsAllowed() && (me.stateMask & 0x2C0) == 0) {
                this.controlPoints.add(this.newControlPointWithCalculatedDirection(mouseCanvasPos));
                this.resetForcedBranchPointDirection();
                this.updateSG();
            }
            return true;
        }
        if (me.button == 2) {
            return this.cancelPreviousBend();
        }
        return false;
    }

    protected boolean processMouseButtonRelease(MouseEvent.MouseButtonReleasedEvent me) {
        if (me.button == 1 && ++this.mouseLeftReleaseCount == 1) {
            return this.tryEndConnection();
        }
        return false;
    }

    private boolean tryEndConnection() {
        if (this.isEndTerminalDefined() && this.connectionJudgment != null) {
            this.createConnection();
            this.remove();
            return true;
        }
        if (this.lastRouteGraphTarget != null && this.attachToConnectionJudgement != null) {
            this.lastRouteGraphTarget.getNode().showBranchPoint(null);
            this.attachToConnection();
            this.remove();
            return true;
        }
        return false;
    }

    private void attachToConnection() {
        final ConnectionJudgement judgment = this.attachToConnectionJudgement;
        if (judgment == null) {
            ErrorLogger.defaultLogError((String)"Cannot attach to connection, no judgment available on connection validity", null);
            return;
        }
        final ConnectionBuilder builder = new ConnectionBuilder(this.diagram);
        final RouteGraph before = this.lastRouteGraphTarget.getNode().getRouteGraph();
        THashMap copyMap = new THashMap();
        final RouteGraph after = before.copy(copyMap);
        RouteLine attachTo = (RouteLine)copyMap.get((Object)this.lastRouteGraphTarget.getLine());
        after.makePersistent(attachTo);
        for (RouteLine line : after.getAllLines()) {
            if (line.isTransient() || line.isHorizontal() != attachTo.isHorizontal() || line.getPosition() != attachTo.getPosition()) continue;
            attachTo = line;
            break;
        }
        final RouteLine attachToLine = attachTo;
        final RouteGraphDelta delta = new RouteGraphDelta(before, after);
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                Resource connection = (Resource)ElementUtils.getObject((IElement)ConnectTool2.this.endTerminal.e);
                if (!delta.isEmpty()) {
                    new RouteGraphConnection(graph, connection).synchronize(graph, before, after, delta);
                }
                Resource line = RouteGraphConnection.deserialize((ServiceLocator)graph, attachToLine.getData());
                ArrayDeque<ControlPoint> cps = new ArrayDeque<ControlPoint>();
                Iterator<ControlPoint> iterator = ConnectTool2.this.controlPoints.descendingIterator();
                while (iterator.hasNext()) {
                    cps.add(iterator.next());
                }
                builder.attachToRouteGraph(graph, judgment, connection, line, cps, ConnectTool2.this.startTerminal, FlagClass.Type.In);
            }
        }, parameter -> {
            if (parameter != null) {
                ExceptionUtils.logAndShowError((Throwable)parameter);
            }
        });
    }

    protected boolean cancelPreviousBend() {
        if (!this.routePointsAllowed()) {
            return false;
        }
        if (this.isEndingInFlag()) {
            return true;
        }
        if (this.controlPoints.size() <= 2) {
            this.setDirty();
            this.remove();
            return true;
        }
        this.controlPoints.removeLast();
        this.controlPoints.getLast().setPosition(this.lastMouseCanvasPos);
        this.resetForcedBranchPointDirection();
        this.updateSG();
        return true;
    }

    protected boolean rotateLastBranchPoint(boolean clockwise) {
        BranchPoint.Direction oldDir = this.calculateCurrentBranchPointDirection();
        this.forcedBranchPointDirection = this.forcedBranchPointDirection == null ? oldDir.toggleDetermined() : (clockwise ? oldDir.cycleNext() : oldDir.cyclePrevious());
        this.controlPoints.getLast().setDirection(this.forcedBranchPointDirection);
        this.updateSG();
        return true;
    }

    protected void setDirection(IElement branchPoint, BranchPoint.Direction direction) {
        ((BranchPoint)branchPoint.getElementClass().getSingleItem(BranchPoint.class)).setDirectionPreference(branchPoint, direction);
    }

    protected BranchPoint.Direction forcedBranchPointDirection() {
        return this.forcedBranchPointDirection;
    }

    protected void resetForcedBranchPointDirection() {
        this.forcedBranchPointDirection = null;
    }

    protected void forceBranchPointDirection(BranchPoint.Direction direction) {
        this.forcedBranchPointDirection = direction;
    }

    protected BranchPoint.Direction calculateCurrentBranchPointDirection() {
        Iterator<ControlPoint> it;
        if (this.forcedBranchPointDirection != null) {
            return this.forcedBranchPointDirection;
        }
        if (this.controlPoints.size() > 2) {
            it = this.controlPoints.descendingIterator();
            it.next();
            ControlPoint secondLastCp = it.next();
            BranchPoint.Direction dir = secondLastCp.getDirection();
            switch (dir) {
                case Horizontal: {
                    return BranchPoint.Direction.Vertical;
                }
                case Vertical: {
                    return BranchPoint.Direction.Horizontal;
                }
            }
        }
        if (this.controlPoints.size() > 1) {
            it = this.controlPoints.descendingIterator();
            ControlPoint last = it.next();
            ControlPoint secondLast = it.next();
            double angle = Math.atan2(Math.abs(last.getPosition().getY() - secondLast.getPosition().getY()), Math.abs(last.getPosition().getX() - secondLast.getPosition().getX()));
            if (angle >= 0.0 && angle < 0.7853981633974483) {
                return BranchPoint.Direction.Horizontal;
            }
            if (angle > 0.7853981633974483 && angle <= 1.5707963267948966) {
                return BranchPoint.Direction.Vertical;
            }
        }
        return BranchPoint.Direction.Any;
    }

    protected boolean isEndingInFlag() {
        return this.endFlag != null;
    }

    protected boolean endWithoutTerminal(Point2D mousePos, boolean altDown) {
        if (!this.createFlags) {
            return false;
        }
        boolean endTerminalDefined = this.isEndTerminalDefined();
        if (altDown) {
            if (!this.isEndingInFlag()) {
                this.endFlag = this.createFlag(EdgeVisuals.EdgeEnd.End);
                this.endFlagNode = this.showElement(this.ghostNode, "endFlag", this.endFlag.e, mousePos);
                this.controlPoints.getLast().setDirection(this.calculateCurrentBranchPointDirection()).setAttachedToTerminal(this.endFlag);
                this.setHint(TerminalPainter.TERMINAL_HOVER_STRATEGY, this.terminalHoverStrategy);
                this.updateSG();
                return true;
            }
        } else if (this.isEndingInFlag()) {
            this.endFlag = null;
            this.endFlagNode.remove();
            this.endFlagNode = null;
            ControlPoint cp = this.controlPoints.getLast();
            cp.setDirection(this.calculateCurrentBranchPointDirection()).setAttachedToTerminal(this.endTerminal);
            if (endTerminalDefined) {
                cp.setPosition(this.endTerminal.posDia);
            } else {
                cp.setPosition(mousePos);
            }
            this.setHint(TerminalPainter.TERMINAL_HOVER_STRATEGY, this.terminalHoverStrategy);
            this.updateSG();
            return true;
        }
        return false;
    }

    protected void createConnection() {
        this.createConnection(this.selectedStartTerminal, this.endTerminal, this.connectionJudgment, this.controlPoints);
    }

    protected void createConnection(final TerminalUtil.TerminalInfo startTerminal, final TerminalUtil.TerminalInfo endTerminal, final ConnectionJudgement judgement, final Deque<ControlPoint> controlPoints) {
        TimeLogger.resetTimeAndLog(((Object)((Object)this)).getClass(), (String)"createConnection");
        if (judgement == null) {
            String tmsg = this.terminalsToString(Arrays.asList(startTerminal, endTerminal));
            ErrorLogger.defaultLogError((String)("Cannot create connection, no judgment available on connection validity when connecting the terminals:\n" + tmsg), null);
            return;
        }
        final ConnectionBuilder builder = new ConnectionBuilder(this.diagram);
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                builder.create(graph, judgement, controlPoints, startTerminal, endTerminal);
            }
        }, parameter -> {
            if (parameter != null) {
                ExceptionUtils.logAndShowError((Throwable)parameter);
            }
        });
    }

    protected ControlPoint newControlPointWithCalculatedDirection(Point2D canvasPos) {
        return new ControlPoint(canvasPos, this.calculateCurrentBranchPointDirection());
    }

    protected boolean isStartTerminal(IElement e, Topology.Terminal t) {
        if (this.startTerminal == null) {
            return false;
        }
        for (TerminalUtil.TerminalInfo st : this.startTerminals) {
            if (st.e != e || st.t != t) continue;
            return true;
        }
        return false;
    }

    protected boolean containsStartTerminal(List<TerminalUtil.TerminalInfo> tis) {
        if (this.startTerminal == null) {
            return false;
        }
        for (TerminalUtil.TerminalInfo st : this.startTerminals) {
            for (TerminalUtil.TerminalInfo et : tis) {
                if (st.e != et.e || st.t != et.t) continue;
                return true;
            }
        }
        return false;
    }

    protected static FlagClass.Type endToFlagType(EdgeVisuals.EdgeEnd end) {
        switch (end) {
            case Begin: {
                return FlagClass.Type.In;
            }
            case End: {
                return FlagClass.Type.Out;
            }
        }
        throw new IllegalArgumentException("unrecognized edge end: " + end);
    }

    protected TerminalUtil.TerminalInfo createFlag(EdgeVisuals.EdgeEnd connectionEnd) {
        ElementClass flagClass = this.elementClassProvider.get(ElementClasses.FLAG);
        IElement e = Element.spawnNew((ElementClass)flagClass);
        e.setHint(FlagClass.KEY_FLAG_TYPE, (Object)ConnectTool2.endToFlagType(connectionEnd));
        e.setHint(FlagClass.KEY_FLAG_MODE, (Object)FlagClass.Mode.Internal);
        TerminalUtil.TerminalInfo ti = new TerminalUtil.TerminalInfo();
        ti.e = e;
        ti.t = ElementUtils.getSingleTerminal((IElement)e);
        ti.posElem = TerminalUtil.getTerminalPosOnElement((IElement)e, (Topology.Terminal)ti.t);
        ti.posDia = TerminalUtil.getTerminalPosOnDiagram((IElement)e, (Topology.Terminal)ti.t);
        return ti;
    }

    protected boolean shouldEndWithFlag(MouseEvent me) {
        return this.shouldEndWithFlag(me.hasAnyModifier(8704));
    }

    protected boolean shouldEndWithFlag(boolean altPressed) {
        return altPressed && !this.isEndTerminalDefined() && this.createFlags && this.startFlag == null;
    }

    protected boolean isEndTerminalDefined() {
        return this.endTerminal != null;
    }

    protected boolean isFlagTerminal(TerminalUtil.TerminalInfo ti) {
        return ti.e.getElementClass().containsClass(FlagHandler.class);
    }

    protected boolean allowReflexiveConnections() {
        return false;
    }

    protected boolean routePointsAllowed() {
        return Boolean.TRUE.equals(this.diagram.getHint(DiagramHints.KEY_ALLOW_ROUTE_POINTS));
    }

    protected final Pair<ConnectionJudgement, TerminalUtil.TerminalInfo> canConnect(IElement endElement, Topology.Terminal endTerminal) {
        IConnectionAdvisor advisor = (IConnectionAdvisor)this.diagram.getHint(DiagramHints.CONNECTION_ADVISOR);
        Object judgement = this.canConnect(advisor, endElement, endTerminal);
        if (judgement == null) {
            return null;
        }
        if (judgement instanceof Pair) {
            return (Pair)judgement;
        }
        return Pair.make((Object)((ConnectionJudgement)judgement), (Object)this.startTerminal);
    }

    protected Object canConnect(IConnectionAdvisor advisor, IElement endElement, Topology.Terminal endTerminal) {
        if (advisor == null) {
            return Pair.make((Object)ConnectionJudgement.CANBEMADELEGAL, (Object)this.startTerminal);
        }
        if (this.startTerminals.isEmpty()) {
            ConnectionJudgement obj = (ConnectionJudgement)advisor.canBeConnected(null, null, null, endElement, endTerminal);
            return obj != null ? Pair.make((Object)obj, null) : null;
        }
        for (TerminalUtil.TerminalInfo st : this.startTerminals) {
            ConnectionJudgement obj = (ConnectionJudgement)advisor.canBeConnected(null, st.e, st.t, endElement, endTerminal);
            if (obj == null) continue;
            return Pair.make((Object)obj, (Object)st);
        }
        return null;
    }

    private String terminalsToString(final Iterable<TerminalUtil.TerminalInfo> ts) {
        try {
            return (String)Simantics.sync((ReadInterface)new UniqueRead<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    StringBuilder sb = new StringBuilder();
                    boolean first = true;
                    for (TerminalUtil.TerminalInfo ti : ts) {
                        Resource r;
                        if (!first) {
                            sb.append("\n");
                        }
                        first = false;
                        sb.append("element ");
                        Object o = ElementUtils.getObject((IElement)ti.e);
                        if (o instanceof Resource) {
                            Resource er = (Resource)o;
                            Resource cer = graph.getPossibleObject(er, MOD.ElementToComponent);
                            r = cer != null ? cer : er;
                            sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)r)).append(" : ");
                            for (Resource type : graph.getPrincipalTypes(r)) {
                                sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)type, (boolean)true));
                            }
                        } else {
                            sb.append(ti.e.toString());
                        }
                        sb.append(", terminal ");
                        if (ti.t instanceof ResourceTerminal) {
                            Resource tr = ((ResourceTerminal)ti.t).getResource();
                            Resource cp = graph.getPossibleObject(tr, DIA.HasConnectionPoint);
                            r = cp != null ? cp : tr;
                            sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)r, (boolean)true));
                            continue;
                        }
                        sb.append(ti.t.toString());
                    }
                    return sb.toString();
                }
            });
        }
        catch (DatabaseException e) {
            return e.getMessage();
        }
    }
}

