/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.flag.Splitter;
import org.simantics.diagram.internal.Activator;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.IElement;
import org.simantics.scl.commands.Command;
import org.simantics.scl.commands.Commands;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ConnectionSplitAndJoin
extends DynamicMenuContribution {
    private static final IContributionItem[] NONE = new IContributionItem[0];
    private ICanvasContext canvas;

    public void fill(Menu menu, int index) {
        IWorkbenchPart activePart = WorkbenchUtils.getActiveWorkbenchPart();
        if (activePart == null) {
            return;
        }
        ICanvasContext ctx = (ICanvasContext)activePart.getAdapter(ICanvasContext.class);
        if (ctx == null) {
            return;
        }
        this.canvas = ctx;
        try {
            super.fill(menu, index);
        }
        finally {
            this.canvas = null;
        }
    }

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        Collection<Object> localConnectedFlags = Collections.emptyList();
        Resource routeGraphConnection = null;
        EdgeResource edge = null;
        if (selection.length == 1) {
            routeGraphConnection = this.getRouteGraphConnection(graph, selection[0]);
            if (routeGraphConnection == null && (edge = this.getEdge(graph, selection[0])) == null) {
                localConnectedFlags = this.getLocalConnectedFlags(graph, selection);
            }
        } else {
            localConnectedFlags = this.getLocalConnectedFlags(graph, selection);
        }
        if (!localConnectedFlags.isEmpty()) {
            return new IContributionItem[]{new ActionContributionItem((IAction)new Join(graph.getSession(), this.canvas, localConnectedFlags))};
        }
        if (edge != null) {
            Selection sel = (Selection)this.canvas.getAtMostOneItemOfClass(Selection.class);
            if (sel == null) {
                return NONE;
            }
            Set elems = sel.getSelection(0);
            if (elems.size() != 1) {
                return NONE;
            }
            IElement edgeElement = ConnectionUtil.getSingleEdge(elems.iterator().next());
            if (edgeElement == null) {
                return NONE;
            }
            Point2D canvasPosition = (Point2D)this.canvas.getHintStack().getHint(DiagramHints.POPUP_MENU_CANVAS_POSITION);
            if (canvasPosition == null) {
                return NONE;
            }
            return new IContributionItem[]{new ActionContributionItem((IAction)new Split(graph.getSession(), this.canvas, canvasPosition, edgeElement, edge))};
        }
        if (routeGraphConnection != null) {
            Selection sel = (Selection)this.canvas.getAtMostOneItemOfClass(Selection.class);
            if (sel == null) {
                return NONE;
            }
            Set elems = sel.getSelection(0);
            if (elems.size() != 1) {
                return NONE;
            }
            Point2D canvasPosition = (Point2D)this.canvas.getHintStack().getHint(DiagramHints.POPUP_MENU_CANVAS_POSITION);
            if (canvasPosition == null) {
                return NONE;
            }
            return new IContributionItem[]{new ActionContributionItem((IAction)new SplitRouteGraph(graph.getSession(), this.canvas, canvasPosition, routeGraphConnection))};
        }
        return NONE;
    }

    private Resource getRouteGraphConnection(ReadGraph graph, Object object) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource connection = (Resource)AdaptionUtils.adaptToSingle((Object)object, Resource.class);
        if (connection != null && graph.isInstanceOf(connection, DIA.RouteGraphConnection)) {
            return connection;
        }
        return null;
    }

    private Collection<Resource> getLocalConnectedFlags(ReadGraph graph, Object[] selection) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> result = new ArrayList<Resource>(4);
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            Resource r = (Resource)AdaptionUtils.adaptToSingle((Object)s, Resource.class);
            if (r == null || !graph.isInstanceOf(r, DIA.Flag)) {
                return Collections.emptyList();
            }
            if (!this.isConnectedToSomething(graph, r)) {
                return Collections.emptyList();
            }
            Set<Resource> counterparts = FlagUtil.getCounterparts(graph, r);
            if (counterparts.isEmpty()) {
                return Collections.emptyList();
            }
            Collection flagDiagrams = OrderedSetUtils.getOwnerLists((ReadGraph)graph, (Resource)r, (Resource)DIA.Diagram);
            for (Resource counterpart : counterparts) {
                boolean joinedWithinSingleDiagram;
                boolean bl = joinedWithinSingleDiagram = !Collections.disjoint(flagDiagrams, OrderedSetUtils.getOwnerLists((ReadGraph)graph, (Resource)counterpart, (Resource)DIA.Diagram));
                if (!joinedWithinSingleDiagram) {
                    return Collections.emptyList();
                }
                if (this.isConnectedToSomething(graph, counterpart)) continue;
                return Collections.emptyList();
            }
            result.add(r);
            ++n2;
        }
        return result;
    }

    private boolean isConnectedToSomething(ReadGraph graph, Resource flag) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Iterator iterator = graph.getObjects(flag, STR.IsConnectedTo).iterator();
        if (iterator.hasNext()) {
            Resource connector = (Resource)iterator.next();
            Resource cntr = graph.getPossibleObject(connector, DIA.AreConnected);
            Resource conn = ConnectionUtil.getConnection(graph, cntr);
            return cntr != null && conn != null;
        }
        return false;
    }

    private EdgeResource getEdge(ReadGraph graph, Object object) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource connection = null;
        EdgeResource edge = (EdgeResource)AdaptionUtils.adaptToSingle((Object)object, EdgeResource.class);
        if (edge != null) {
            return edge;
        }
        connection = (Resource)AdaptionUtils.adaptToSingle((Object)object, Resource.class);
        if (connection != null && graph.isInstanceOf(connection, DiagramResource.getInstance((ReadGraph)graph).Connection)) {
            Collection connectors = graph.getObjects(connection, DIA.HasConnector);
            Collection branchPoints = graph.getObjects(connection, DIA.HasBranchPoint);
            if (branchPoints.isEmpty() && connectors.size() == 2) {
                Iterator it = connectors.iterator();
                Resource connector1 = (Resource)it.next();
                Resource connector2 = (Resource)it.next();
                return new EdgeResource(connector1, connector2);
            }
        }
        return null;
    }

    public static abstract class Helper
    extends Action {
        protected final Session session;
        protected final ICanvasContext context;

        public Helper(String label, Session session, ICanvasContext context) {
            super(label);
            this.session = session;
            this.context = context;
        }

        public void run() {
            try {
                this.session.syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        this.performAction(graph);
                    }
                });
                ThreadUtils.asyncExec((IThreadWorkQueue)this.context.getThreadAccess(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (context.isDisposed()) {
                            return;
                        }
                        Selection selection = (Selection)context.getAtMostOneItemOfClass(Selection.class);
                        if (selection != null) {
                            selection.clear(0);
                        }
                    }
                });
            }
            catch (DatabaseException e) {
                ExceptionUtils.logError((Throwable)e);
            }
        }

        protected abstract void performAction(WriteGraph var1) throws DatabaseException;
    }

    public static class Join
    extends Helper {
        private final Collection<Resource> flags;

        public Join(Session session, ICanvasContext context, Collection<Resource> flags) {
            super("Join Flags", session, context);
            this.setImageDescriptor(Activator.LINK_ICON);
            this.flags = flags;
        }

        @Override
        protected void performAction(WriteGraph graph) throws DatabaseException {
            Command command = Commands.get((ReadGraph)graph, (String)"Simantics/Diagram/joinFlagsLocal");
            command.execute((RequestProcessor)graph, (Resource)graph.syncRequest((Read)new IndexRoot(this.flags.iterator().next())), new Object[]{this.flags});
        }
    }

    public static class Split
    extends Helper {
        private final Point2D splitCanvasPos;
        private final IElement edgeElement;
        private final EdgeResource edge;

        public Split(Session session, ICanvasContext context, Point2D splitCanvasPos, IElement edgeElement, EdgeResource edge) {
            super("Split Connection", session, context);
            this.setImageDescriptor(Activator.LINK_BREAK_ICON);
            this.splitCanvasPos = splitCanvasPos;
            this.edgeElement = edgeElement;
            this.edge = edge;
        }

        @Override
        protected void performAction(WriteGraph graph) throws DatabaseException {
            new Splitter((ReadGraph)graph).split(graph, this.edgeElement, this.edge, this.splitCanvasPos);
        }
    }

    public static class SplitRouteGraph
    extends Helper {
        private final Point2D splitCanvasPos;
        private final Resource connection;

        public SplitRouteGraph(Session session, ICanvasContext context, Point2D splitCanvasPos, Resource connection) {
            super("Split Connection", session, context);
            this.setImageDescriptor(Activator.LINK_BREAK_ICON);
            this.splitCanvasPos = splitCanvasPos;
            this.connection = connection;
        }

        @Override
        protected void performAction(WriteGraph graph) throws DatabaseException {
            Command command = Commands.get((ReadGraph)graph, (String)"Simantics/Diagram/splitConnection");
            command.execute((RequestProcessor)graph, (Resource)graph.syncRequest((Read)new IndexRoot(this.connection)), new Object[]{this.connection, this.splitCanvasPos.getX(), this.splitCanvasPos.getY()});
        }
    }
}

