/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.UndoContext;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.scl.commands.Command;
import org.simantics.scl.commands.Commands;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.hints.IHintObservable;

public final class ElementTransforms {
    public static void align(final Resource[] resources, final SIDE side) {
        if (resources.length < 2) {
            return;
        }
        if (side == SIDE.HORIZ_BTW || side == SIDE.VERT_BTW) {
            return;
        }
        SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                IDiagram hints = Diagram.spawnNew((DiagramClass)DiagramClass.DEFAULT);
                ArrayList<AlignElement> elements = new ArrayList<AlignElement>();
                Resource[] resourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource r = resourceArray[n2];
                    AlignElement e = ElementTransforms.create((ReadGraph)graph, hints, r);
                    if (e != null) {
                        elements.add(e);
                    }
                    ++n2;
                }
                if (elements.size() < 2) {
                    return;
                }
                double mx = 0.0;
                double my = 0.0;
                for (AlignElement e : elements) {
                    mx += e.transform[4];
                    my += e.transform[5];
                }
                mx /= (double)elements.size();
                my /= (double)elements.size();
                int count = 0;
                for (AlignElement e : elements) {
                    if (side == SIDE.VERT || side == SIDE.LEFT || side == SIDE.RIGHT) {
                        if (!(Math.abs(e.transform[5] - my) < 0.1)) continue;
                        ++count;
                        continue;
                    }
                    if (!(Math.abs(e.transform[4] - mx) < 0.1)) continue;
                    ++count;
                }
                if (count > 1) {
                    return;
                }
                if (side == SIDE.HORIZ || side == SIDE.VERT) {
                    for (AlignElement e : elements) {
                        if (side == SIDE.VERT) {
                            DiagramGraphUtil.changeTransform(graph, e.element, new double[]{e.transform[0], e.transform[1], e.transform[2], e.transform[3], mx, e.transform[5]});
                            continue;
                        }
                        if (side != SIDE.HORIZ) continue;
                        DiagramGraphUtil.changeTransform(graph, e.element, new double[]{e.transform[0], e.transform[1], e.transform[2], e.transform[3], e.transform[4], my});
                    }
                } else {
                    double lx = ((AlignElement)elements.get((int)0)).transform[4] + ((AlignElement)elements.get((int)0)).rotatedBounds.getMinX();
                    double rx = ((AlignElement)elements.get((int)0)).transform[4] + ((AlignElement)elements.get((int)0)).rotatedBounds.getMaxX();
                    double ty = ((AlignElement)elements.get((int)0)).transform[5] + ((AlignElement)elements.get((int)0)).rotatedBounds.getMinY();
                    double by = ((AlignElement)elements.get((int)0)).transform[5] + ((AlignElement)elements.get((int)0)).rotatedBounds.getMaxY();
                    int i = 1;
                    while (i < elements.size()) {
                        double tlx = ((AlignElement)elements.get((int)i)).transform[4] + ((AlignElement)elements.get((int)i)).rotatedBounds.getMinX();
                        double trx = ((AlignElement)elements.get((int)i)).transform[4] + ((AlignElement)elements.get((int)i)).rotatedBounds.getMaxX();
                        double tty = ((AlignElement)elements.get((int)i)).transform[5] + ((AlignElement)elements.get((int)i)).rotatedBounds.getMinY();
                        double tby = ((AlignElement)elements.get((int)i)).transform[5] + ((AlignElement)elements.get((int)i)).rotatedBounds.getMaxY();
                        if (tlx < lx) {
                            lx = tlx;
                        }
                        if (trx > rx) {
                            rx = trx;
                        }
                        if (tty < ty) {
                            ty = tty;
                        }
                        if (tby > by) {
                            by = tby;
                        }
                        ++i;
                    }
                    for (AlignElement e : elements) {
                        mx = e.transform[4];
                        my = e.transform[5];
                        if (side == SIDE.LEFT) {
                            mx = lx - e.rotatedBounds.getMinX();
                        } else if (side == SIDE.RIGHT) {
                            mx = rx - e.rotatedBounds.getMaxX();
                        } else {
                            my = side == SIDE.TOP ? ty - e.rotatedBounds.getMinY() : by - e.rotatedBounds.getMaxY();
                        }
                        DiagramGraphUtil.changeTransform(graph, e.element, new double[]{e.transform[0], e.transform[1], e.transform[2], e.transform[3], mx, my});
                    }
                }
            }
        });
    }

    public static void dist(final Resource[] resources, final SIDE side) {
        if (resources.length < 3) {
            return;
        }
        SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                IDiagram hints = Diagram.spawnNew((DiagramClass)DiagramClass.DEFAULT);
                ArrayList<AlignElement> elements = new ArrayList<AlignElement>();
                Resource[] resourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource r = resourceArray[n2];
                    AlignElement e = ElementTransforms.create((ReadGraph)graph, hints, r);
                    if (e != null) {
                        elements.add(e);
                    }
                    ++n2;
                }
                if (elements.size() < 3) {
                    return;
                }
                switch (side) {
                    case LEFT: {
                        Collections.sort(elements, new XComparator());
                        AlignElement left = (AlignElement)elements.get(0);
                        AlignElement right = (AlignElement)elements.get(elements.size() - 1);
                        double leftEdge = left.transform[4] + left.rotatedBounds.getMinX();
                        double rightEdge = right.transform[4] + right.rotatedBounds.getMinX();
                        double totalDist = rightEdge - leftEdge;
                        double dist = totalDist / (double)(elements.size() - 1);
                        double d = leftEdge;
                        int i = 1;
                        while (i < elements.size() - 1) {
                            AlignElement e = (AlignElement)elements.get(i);
                            double mx = (d += dist) - e.rotatedBounds.getMinX();
                            DiagramGraphUtil.changeTransform(graph, e.element, new double[]{e.transform[0], e.transform[1], e.transform[2], e.transform[3], mx, e.transform[5]});
                            ++i;
                        }
                        break;
                    }
                    case VERT: {
                        Collections.sort(elements, new XComparator());
                        AlignElement left = (AlignElement)elements.get(0);
                        AlignElement right = (AlignElement)elements.get(elements.size() - 1);
                        double leftEdge = left.transform[4];
                        double rightEdge = right.transform[4];
                        double totalDist = rightEdge - leftEdge;
                        double dist = totalDist / (double)(elements.size() - 1);
                        double d = leftEdge;
                        int i = 1;
                        while (i < elements.size() - 1) {
                            AlignElement e = (AlignElement)elements.get(i);
                            double mx = d += dist;
                            DiagramGraphUtil.changeTransform(graph, e.element, new double[]{e.transform[0], e.transform[1], e.transform[2], e.transform[3], mx, e.transform[5]});
                            ++i;
                        }
                        break;
                    }
                    case RIGHT: {
                        Collections.sort(elements, new XComparator());
                        AlignElement left = (AlignElement)elements.get(0);
                        AlignElement right = (AlignElement)elements.get(elements.size() - 1);
                        double leftEdge = left.transform[4] + left.rotatedBounds.getMaxX();
                        double rightEdge = right.transform[4] + right.rotatedBounds.getMaxX();
                        double totalDist = rightEdge - leftEdge;
                        double dist = totalDist / (double)(elements.size() - 1);
                        double d = leftEdge;
                        int i = 1;
                        while (i < elements.size() - 1) {
                            AlignElement e = (AlignElement)elements.get(i);
                            double mx = (d += dist) - e.rotatedBounds.getMaxX();
                            DiagramGraphUtil.changeTransform(graph, e.element, new double[]{e.transform[0], e.transform[1], e.transform[2], e.transform[3], mx, e.transform[5]});
                            ++i;
                        }
                        break;
                    }
                    case VERT_BTW: {
                        Collections.sort(elements, new XComparator());
                        AlignElement left = (AlignElement)elements.get(0);
                        AlignElement right = (AlignElement)elements.get(elements.size() - 1);
                        double leftEdge = left.transform[4] + left.rotatedBounds.getMaxX();
                        double rightEdge = right.transform[4] + right.rotatedBounds.getMinX();
                        double totalDist = rightEdge - leftEdge;
                        double totalElementSize = 0.0;
                        int i = 1;
                        while (i < elements.size() - 1) {
                            totalElementSize += ((AlignElement)elements.get((int)i)).rotatedBounds.getWidth();
                            ++i;
                        }
                        double totalAvail = totalDist - totalElementSize;
                        double dist = totalAvail / (double)(elements.size() - 1);
                        double d = leftEdge;
                        int i2 = 1;
                        while (i2 < elements.size() - 1) {
                            AlignElement e = (AlignElement)elements.get(i2);
                            double mx = (d += dist) - e.rotatedBounds.getMinX();
                            d += e.bounds.getWidth();
                            DiagramGraphUtil.changeTransform(graph, e.element, new double[]{e.transform[0], e.transform[1], e.transform[2], e.transform[3], mx, e.transform[5]});
                            ++i2;
                        }
                        break;
                    }
                    case BOTTOM: {
                        Collections.sort(elements, new YComparator());
                        AlignElement top = (AlignElement)elements.get(0);
                        AlignElement bottom = (AlignElement)elements.get(elements.size() - 1);
                        double topEdge = top.transform[5] + top.rotatedBounds.getMaxY();
                        double bottomEdge = bottom.transform[5] + bottom.rotatedBounds.getMaxY();
                        double totalDist = bottomEdge - topEdge;
                        double dist = totalDist / (double)(elements.size() - 1);
                        double d = topEdge;
                        int i = 1;
                        while (i < elements.size() - 1) {
                            AlignElement e = (AlignElement)elements.get(i);
                            double my = (d += dist) - e.rotatedBounds.getMaxY();
                            DiagramGraphUtil.changeTransform(graph, e.element, new double[]{e.transform[0], e.transform[1], e.transform[2], e.transform[3], e.transform[4], my});
                            ++i;
                        }
                        break;
                    }
                    case TOP: {
                        Collections.sort(elements, new YComparator());
                        AlignElement top = (AlignElement)elements.get(0);
                        AlignElement bottom = (AlignElement)elements.get(elements.size() - 1);
                        double topEdge = top.transform[5] + top.rotatedBounds.getMinY();
                        double bottomEdge = bottom.transform[5] + bottom.rotatedBounds.getMinY();
                        double totalDist = bottomEdge - topEdge;
                        double dist = totalDist / (double)(elements.size() - 1);
                        double d = topEdge;
                        int i = 1;
                        while (i < elements.size() - 1) {
                            AlignElement e = (AlignElement)elements.get(i);
                            double my = (d += dist) - e.rotatedBounds.getMinY();
                            DiagramGraphUtil.changeTransform(graph, e.element, new double[]{e.transform[0], e.transform[1], e.transform[2], e.transform[3], e.transform[4], my});
                            ++i;
                        }
                        break;
                    }
                    case HORIZ: {
                        Collections.sort(elements, new YComparator());
                        AlignElement top = (AlignElement)elements.get(0);
                        AlignElement bottom = (AlignElement)elements.get(elements.size() - 1);
                        double topEdge = top.transform[5];
                        double bottomEdge = bottom.transform[5];
                        double totalDist = bottomEdge - topEdge;
                        double dist = totalDist / (double)(elements.size() - 1);
                        double d = topEdge;
                        int i = 1;
                        while (i < elements.size() - 1) {
                            AlignElement e = (AlignElement)elements.get(i);
                            double my = d += dist;
                            DiagramGraphUtil.changeTransform(graph, e.element, new double[]{e.transform[0], e.transform[1], e.transform[2], e.transform[3], e.transform[4], my});
                            ++i;
                        }
                        break;
                    }
                    case HORIZ_BTW: {
                        Collections.sort(elements, new YComparator());
                        AlignElement top = (AlignElement)elements.get(0);
                        AlignElement bottom = (AlignElement)elements.get(elements.size() - 1);
                        double topEdge = top.transform[5] + top.rotatedBounds.getMaxY();
                        double bottomEdge = bottom.transform[5] + bottom.rotatedBounds.getMinY();
                        double totalDist = bottomEdge - topEdge;
                        double totalElementSize = 0.0;
                        int i = 1;
                        while (i < elements.size() - 1) {
                            totalElementSize += ((AlignElement)elements.get((int)i)).rotatedBounds.getHeight();
                            ++i;
                        }
                        double totalAvail = totalDist - totalElementSize;
                        double dist = totalAvail / (double)(elements.size() - 1);
                        double d = topEdge;
                        int i3 = 1;
                        while (i3 < elements.size() - 1) {
                            AlignElement e = (AlignElement)elements.get(i3);
                            double my = (d += dist) - e.rotatedBounds.getMinY();
                            d += e.rotatedBounds.getHeight();
                            DiagramGraphUtil.changeTransform(graph, e.element, new double[]{e.transform[0], e.transform[1], e.transform[2], e.transform[3], e.transform[4], my});
                            ++i3;
                        }
                        break;
                    }
                }
            }
        });
    }

    public static void rotate(final Resource[] resources, final boolean clockwise) {
        SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                block11: {
                    AffineTransform at;
                    ArrayList<Resource> connections;
                    ArrayList<AlignElement> elements;
                    block10: {
                        graph.markUndoPoint();
                        IDiagram hints = Diagram.spawnNew((DiagramClass)DiagramClass.DEFAULT);
                        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                        elements = new ArrayList<AlignElement>();
                        connections = new ArrayList<Resource>();
                        Resource[] resourceArray = resources;
                        int n = resources.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Resource r = resourceArray[n2];
                            AlignElement e = ElementTransforms.create((ReadGraph)graph, hints, r);
                            if (e != null) {
                                elements.add(e);
                            } else if (graph.isInstanceOf(r, DIA.RouteGraphConnection)) {
                                connections.add(r);
                            }
                            ++n2;
                        }
                        if (elements.size() < 1) {
                            return;
                        }
                        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                        graph.addMetadata((Metadata)cm.add("Rotate " + elements.size() + " elements " + (clockwise ? "clockwise" : "counter-clockwise")));
                        AffineTransform affineTransform = at = clockwise ? AffineTransform.getQuadrantRotateInstance(1) : AffineTransform.getQuadrantRotateInstance(3);
                        if (elements.size() != 1 || !connections.isEmpty()) break block10;
                        for (AlignElement e : elements) {
                            AffineTransform eat = new AffineTransform(e.transform[0], e.transform[1], e.transform[2], e.transform[3], 0.0, 0.0);
                            eat.preConcatenate(at);
                            DiagramGraphUtil.changeTransform(graph, e.element, new double[]{eat.getScaleX(), eat.getShearY(), eat.getShearX(), eat.getScaleY(), e.transform[4], e.transform[5]});
                        }
                        break block11;
                    }
                    RectangularShape selectionBounds = null;
                    for (AlignElement e : elements) {
                        if (selectionBounds != null) {
                            ((Rectangle2D)selectionBounds).add(e.transform[4], e.transform[5]);
                            continue;
                        }
                        selectionBounds = new Rectangle2D.Double(e.transform[4], e.transform[5], 0.0, 0.0);
                    }
                    double cx = selectionBounds.getCenterX();
                    double cy = selectionBounds.getCenterY();
                    for (AlignElement e : elements) {
                        double x = e.transform[4];
                        double y = e.transform[5];
                        double dx = x - cx;
                        double dy = y - cy;
                        Point2D r = at.transform(new Point2D.Double(dx, dy), null);
                        double mx = r.getX() + cx;
                        double my = r.getY() + cy;
                        AffineTransform eat = new AffineTransform(e.transform[0], e.transform[1], e.transform[2], e.transform[3], 0.0, 0.0);
                        eat.preConcatenate(at);
                        DiagramGraphUtil.changeTransform(graph, e.element, new double[]{eat.getScaleX(), eat.getShearY(), eat.getShearX(), eat.getScaleY(), mx, my});
                    }
                    if (connections.isEmpty()) break block11;
                    Command rotateConnection = Commands.get((ReadGraph)graph, (String)"Simantics/Diagram/rotateConnection");
                    Resource model = (Resource)graph.syncRequest((Read)new IndexRoot((Resource)connections.get(0)));
                    for (Resource r : connections) {
                        rotateConnection.execute((RequestProcessor)graph, model, new Object[]{r, cx, cy, clockwise});
                    }
                }
            }
        });
    }

    public static void flip(final Resource[] resources, final boolean xAxis) {
        SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                block13: {
                    ArrayList<Resource> connections;
                    ArrayList<AlignElement> elements;
                    block12: {
                        graph.markUndoPoint();
                        IDiagram hints = Diagram.spawnNew((DiagramClass)DiagramClass.DEFAULT);
                        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                        elements = new ArrayList<AlignElement>();
                        connections = new ArrayList<Resource>();
                        Resource[] resourceArray = resources;
                        int n = resources.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Resource r = resourceArray[n2];
                            AlignElement e = ElementTransforms.create((ReadGraph)graph, hints, r);
                            if (e != null) {
                                elements.add(e);
                            } else if (graph.isInstanceOf(r, DIA.RouteGraphConnection)) {
                                connections.add(r);
                            }
                            ++n2;
                        }
                        if (elements.size() < 1) {
                            return;
                        }
                        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                        graph.addMetadata((Metadata)cm.add("Flip " + elements.size() + " elements " + (xAxis ? "vertically" : "horizontally")));
                        if (elements.size() != 1 || !connections.isEmpty()) break block12;
                        for (AlignElement e : elements) {
                            AffineTransform at2;
                            Object at;
                            if (xAxis) {
                                at = new AffineTransform(e.transform);
                                at2 = AffineTransform.getScaleInstance(1.0, -1.0);
                                ((AffineTransform)at).preConcatenate(at2);
                                DiagramGraphUtil.changeTransform(graph, e.element, new double[]{((AffineTransform)at).getScaleX(), ((AffineTransform)at).getShearY(), ((AffineTransform)at).getShearX(), ((AffineTransform)at).getScaleY(), e.transform[4], e.transform[5]});
                                continue;
                            }
                            at = new AffineTransform(e.transform);
                            at2 = AffineTransform.getScaleInstance(-1.0, 1.0);
                            ((AffineTransform)at).preConcatenate(at2);
                            DiagramGraphUtil.changeTransform(graph, e.element, new double[]{((AffineTransform)at).getScaleX(), ((AffineTransform)at).getShearY(), ((AffineTransform)at).getShearX(), ((AffineTransform)at).getScaleY(), e.transform[4], e.transform[5]});
                        }
                        break block13;
                    }
                    Rectangle2D selectionBounds = null;
                    for (AlignElement e : elements) {
                        if (selectionBounds != null) {
                            selectionBounds.add(e.transform[4], e.transform[5]);
                            continue;
                        }
                        selectionBounds = new Rectangle2D.Double(e.transform[4], e.transform[5], 0.0, 0.0);
                    }
                    for (AlignElement e : elements) {
                        AffineTransform at2;
                        AffineTransform at;
                        if (xAxis) {
                            double y = e.transform[5];
                            double cy = selectionBounds.getCenterY();
                            double my = cy + cy - y;
                            at = new AffineTransform(e.transform);
                            at2 = AffineTransform.getScaleInstance(1.0, -1.0);
                            at.preConcatenate(at2);
                            DiagramGraphUtil.changeTransform(graph, e.element, new double[]{at.getScaleX(), at.getShearY(), at.getShearX(), at.getScaleY(), e.transform[4], my});
                            continue;
                        }
                        double x = e.transform[4];
                        double cx = selectionBounds.getCenterX();
                        double mx = cx + cx - x;
                        at = new AffineTransform(e.transform);
                        at2 = AffineTransform.getScaleInstance(-1.0, 1.0);
                        at.preConcatenate(at2);
                        DiagramGraphUtil.changeTransform(graph, e.element, new double[]{at.getScaleX(), at.getShearY(), at.getShearX(), at.getScaleY(), mx, e.transform[5]});
                    }
                    if (connections.isEmpty()) break block13;
                    Command flipConnection = Commands.get((ReadGraph)graph, (String)"Simantics/Diagram/flipConnection");
                    Resource model = (Resource)graph.syncRequest((Read)new IndexRoot((Resource)connections.get(0)));
                    for (Resource r : connections) {
                        flipConnection.execute((RequestProcessor)graph, model, new Object[]{r, xAxis, xAxis ? selectionBounds.getCenterY() : selectionBounds.getCenterX()});
                    }
                }
            }
        });
    }

    private static AlignElement create(ReadGraph graph, IDiagram hints, Resource r) throws ManyObjectsForFunctionalRelationException, NoSingleResultException, ServiceException, DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(r, dr.Element) && !graph.isInstanceOf(r, dr.Connection)) {
            double[] transform = (double[])graph.getPossibleRelatedValue(r, dr.HasTransform);
            ElementClass ec = (ElementClass)graph.syncRequest(DiagramRequests.getElementClass(graph.getSingleType(r, dr.Element), (IHintObservable)hints));
            IElement e = Element.spawnNew((ElementClass)ec);
            Rectangle2D bounds = ElementUtils.getElementBounds((IElement)e);
            if (transform != null && bounds != null) {
                return new AlignElement(r, transform, bounds);
            }
        }
        return null;
    }

    public static Write setTransformRequest(final Collection<TransformedObject> elements) {
        return new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                for (TransformedObject element : elements) {
                    DiagramGraphUtil.changeTransform(graph, element.element, element.transform);
                }
            }
        };
    }

    public static Write concatenateTransformRequest(UndoContext undoContext, final Collection<TransformedObject> elements, final boolean preConcatenate) {
        return new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                for (TransformedObject element : elements) {
                    AffineTransform at = DiagramGraphUtil.getTransform((ReadGraph)graph, element.element);
                    if (preConcatenate) {
                        at.preConcatenate(element.transform);
                    } else {
                        at.concatenate(element.transform);
                    }
                    DiagramGraphUtil.setTransform(graph, element.element, at);
                }
            }
        };
    }

    private static class AlignElement {
        public Resource element;
        public double[] transform;
        public Rectangle2D bounds;
        public Rectangle2D rotatedBounds;

        public AlignElement(Resource element, double[] transform, Rectangle2D bounds) {
            this.element = element;
            this.transform = transform;
            this.bounds = bounds;
            this.rotatedBounds = this.getRotatedBounds();
        }

        public Rectangle2D getRotatedBounds() {
            AffineTransform at = new AffineTransform(this.transform[0], this.transform[1], this.transform[2], this.transform[3], 0.0, 0.0);
            return GeometryUtils.transformShape((Shape)this.bounds, (AffineTransform)at).getBounds2D();
        }

        public double getDeterminant() {
            return this.transform[0] * this.transform[3] - this.transform[1] * this.transform[2];
        }
    }

    public static enum SIDE {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        VERT,
        HORIZ,
        VERT_BTW,
        HORIZ_BTW;

    }

    public static class TransformedObject {
        public final Resource element;
        public final AffineTransform transform;

        public TransformedObject(Resource element) {
            this.element = element;
            this.transform = new AffineTransform();
        }

        public TransformedObject(Resource element, AffineTransform transform) {
            this.element = element;
            this.transform = transform;
        }
    }

    private static class XComparator
    implements Comparator<AlignElement> {
        private XComparator() {
        }

        @Override
        public int compare(AlignElement o1, AlignElement o2) {
            if (o1.transform[4] < o2.transform[4]) {
                return -1;
            }
            if (o1.transform[4] > o2.transform[4]) {
                return 1;
            }
            return 0;
        }
    }

    private static class YComparator
    implements Comparator<AlignElement> {
        private YComparator() {
        }

        @Override
        public int compare(AlignElement o1, AlignElement o2) {
            if (o1.transform[5] < o2.transform[5]) {
                return -1;
            }
            if (o1.transform[5] > o2.transform[5]) {
                return 1;
            }
            return 0;
        }
    }
}

