/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.guarded.GuardedAsyncProcedureWrapper;
import org.simantics.db.common.request.BinaryAsyncRead;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.diagram.adapter.ElementFactoryAdapter;
import org.simantics.diagram.adapter.ElementFactoryUtil;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.TransformSynchronizer;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.handler.impl.StaticSymbolImageInitializer;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.elementclass.ImageClass;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.AWTImage;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.ui.ErrorLogger;

public class RasterElementClassFactory
extends ElementFactoryAdapter {
    public static final ElementFactory INSTANCE = new RasterElementClassFactory();
    private static final StaticSymbolImpl STATIC_SYMBOL = new StaticSymbolImpl((Image)DefaultImages.HOURGLASS.get());

    @Override
    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, final AsyncProcedure<ElementClass> procedure) {
        graph.asyncRequest((AsyncRead)new ClassRequest(elementType, canvas, diagram), (AsyncListener)new TransientCacheAsyncListener<ElementClass>(){

            public void exception(AsyncReadGraph graph, Throwable t) {
                t.printStackTrace();
                procedure.exception(graph, t);
            }

            public void execute(AsyncReadGraph graph, ElementClass result) {
                procedure.execute(graph, (Object)result);
            }
        });
    }

    static void createClass(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        String id = "RasterElement: " + elementType.getResourceId();
        procedure.execute(graph, (Object)ElementClass.compile((ElementHandler[])new ElementHandler[]{TextImpl.INSTANCE, new StaticObjectAdapter((Object)elementType), DefaultTransform.INSTANCE, StaticSymbolImageInitializer.INSTANCE, STATIC_SYMBOL, ImageClass.ImageElementHandler.INSTANCE, SimpleElementLayers.INSTANCE}).setId(id));
    }

    @Override
    public void load(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource element, IElement e, AsyncProcedure<IElement> procedure) {
        e.setHint(SynchronizationHints.HINT_SYNCHRONIZER, (Object)TransformSynchronizer.INSTANCE);
        GuardedAsyncProcedureWrapper guard = new GuardedAsyncProcedureWrapper(procedure, 3);
        this.loadRaster(graph, diagram, element, e, (AsyncProcedure<IElement>)guard);
        ElementFactoryUtil.loadLayersForElement(graph, diagram, e, element, (AsyncProcedure<IElement>)guard);
        ElementFactoryUtil.readTransform(graph, element, e, (AsyncProcedure<IElement>)guard);
    }

    private void loadRaster(AsyncReadGraph graph, IDiagram diagram, Resource element, final IElement e, final AsyncProcedure<IElement> guard) {
        G2DResource G2D = (G2DResource)graph.getService(G2DResource.class);
        graph.forPossibleRelatedValue(element, G2D.HasRasterImage, (Binding)Bindings.BYTE_ARRAY, (AsyncProcedure)new AsyncProcedure<byte[]>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                guard.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, byte[] data) {
                if (data != null) {
                    try {
                        BufferedImage bi = ImageIO.read(new ByteArrayInputStream(data));
                        e.setHint(ElementHints.KEY_IMAGE, (Object)new AWTImage(bi));
                        guard.execute(graph, (Object)e);
                    }
                    catch (ProvisionException ex) {
                        ErrorLogger.defaultLogError((Throwable)ex);
                        e.setHint(ElementHints.KEY_IMAGE, DefaultImages.SVG.get());
                        guard.execute(graph, (Object)e);
                    }
                    catch (MalformedURLException e1) {
                        ErrorLogger.defaultLogError((Throwable)e1);
                        e.setHint(ElementHints.KEY_IMAGE, DefaultImages.SVG.get());
                        guard.execute(graph, (Object)e);
                    }
                    catch (IOException e1) {
                        ErrorLogger.defaultLogError((Throwable)e1);
                        e.setHint(ElementHints.KEY_IMAGE, DefaultImages.SVG.get());
                        guard.execute(graph, (Object)e);
                    }
                } else {
                    e.setHint(ElementHints.KEY_IMAGE, DefaultImages.UNKNOWN.get());
                    guard.execute(graph, (Object)e);
                }
            }
        });
    }

    static class ClassRequest
    extends BinaryAsyncRead<Resource, ICanvasContext, ElementClass> {
        private final IDiagram diagram;

        public ClassRequest(Resource elementType, ICanvasContext canvas, IDiagram diagram) {
            super((Object)elementType, (Object)canvas);
            this.diagram = diagram;
        }

        public void perform(AsyncReadGraph graph, AsyncProcedure<ElementClass> procedure) {
            RasterElementClassFactory.createClass(graph, (ICanvasContext)this.parameter2, this.diagram, (Resource)this.parameter, procedure);
        }
    }
}

