/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.wizards.models;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.simantics.browsing.ui.swt.AdaptableHintContext;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.graph.db.TGStatusMonitor;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.ArrayMap;

public class WizardModelsExportPage
extends WizardPage {
    private Text filePathField;
    private static String previouslyBrowsedFile = "";
    private Button browseDirectoriesButton;
    private Resource selectedModel;
    GraphExplorerComposite modelExplorer;
    private boolean selectionMade = false;

    public WizardModelsExportPage() {
        this("wizardModelsExportPage", null, null);
    }

    public WizardModelsExportPage(String pageName) {
        this(pageName, null, null);
    }

    public WizardModelsExportPage(String pageName, String initialPath, IStructuredSelection currentSelection) {
        super(pageName);
        this.setPageComplete(false);
        this.setTitle("Export Model");
        this.setDescription("Choose the Model and the export location, then press Finish.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createTree(workArea);
    }

    private void createProjectsRoot(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText("Select the export location for Model:");
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.filePathField = new Text(projectGroup, 2048);
        GridData directoryPathData = new GridData(4, 0, true, false);
        directoryPathData.widthHint = new PixelConverter((Control)this.filePathField).convertWidthInCharsToPixels(25);
        this.filePathField.setLayoutData((Object)directoryPathData);
        this.filePathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                previouslyBrowsedFile = WizardModelsExportPage.this.filePathField.getText();
            }
        });
        if (previouslyBrowsedFile != null) {
            this.filePathField.setText(previouslyBrowsedFile);
            this.validatePage();
        }
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText("Browse");
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardModelsExportPage.this.handleLocationDirectoryButtonPressed();
            }
        });
    }

    private void createTree(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText("Select Model to export:");
        Resource input = (Resource)SimanticsUI.getProject().get();
        this.modelExplorer = new GraphExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), null, workArea, 2052);
        this.modelExplorer.setBrowseContexts(new String[]{"http://www.simantics.org/Sysdyn-1.1/ImportModuleTree"});
        this.modelExplorer.finish();
        this.modelExplorer.setInput(null, (Object)input);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.modelExplorer);
        ((Tree)this.modelExplorer.getExplorer().getControl()).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WizardModelsExportPage.this.selectionMade = true;
                WizardModelsExportPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                WizardModelsExportPage.this.selectionMade = true;
                WizardModelsExportPage.this.validatePage();
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.filePathField.setFocus();
    }

    protected void handleLocationDirectoryButtonPressed() {
        String selectedFile;
        Shell shell = this.filePathField.getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        String[] ext = new String[]{"*.sysdyn"};
        dialog.setFilterExtensions(ext);
        dialog.setText("Export Model");
        String dirName = this.filePathField.getText().trim();
        File path = new File(dirName);
        if (path.exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedFile = dialog.open()) != null) {
            this.filePathField.setText(selectedFile);
            this.validatePage();
        }
    }

    public static <T> T getExplorerResource(GraphExplorerComposite explorer, Class<T> clazz) {
        if (explorer == null) {
            return null;
        }
        ISelection selection = ((ISelectionProvider)explorer.getAdapter(ISelectionProvider.class)).getSelection();
        if (selection == null) {
            return null;
        }
        IStructuredSelection iss = (IStructuredSelection)selection;
        AdaptableHintContext inc = (AdaptableHintContext)iss.getFirstElement();
        if (inc == null) {
            return null;
        }
        Object resource = inc.getAdapter(clazz);
        return (T)resource;
    }

    public boolean createProjects() {
        final String selected = previouslyBrowsedFile;
        if (selected == null) {
            return false;
        }
        this.selectedModel = WizardModelsExportPage.getExplorerResource(this.modelExplorer, Resource.class);
        if (this.selectedModel == null) {
            return false;
        }
        SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                TransferableGraphConfiguration2 conf = new TransferableGraphConfiguration2(graph, WizardModelsExportPage.this.selectedModel);
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (TransferableGraphSource tgs = (TransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(conf));){
                        TransferableGraphs.writeTransferableGraph((RequestProcessor)graph, (TransferableGraphSource)tgs, (File)new File(selected), (TGStatusMonitor)TGStatusMonitor.NULL_MONITOR);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.sysdyn.ui", "Failed to export model, see exception for details.", (Throwable)e));
                }
            }
        });
        return true;
    }

    void validatePage() {
        if (previouslyBrowsedFile.isEmpty() || !this.selectionMade) {
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }
}

