/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.modules;

import java.util.Collection;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.model.modifiers.ModifierRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.IndependentVariable;
import org.simantics.sysdyn.representation.Variability;
import org.simantics.sysdyn.ui.properties.widgets.modules.ModuleParameterOverrideUtils;
import org.simantics.sysdyn.ui.properties.widgets.modules.ParameterNode;
import org.simantics.ui.SimanticsUI;

public class ParameterModifierRule
implements ModifierRule {
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Object.class);
    }

    public Labeler.Modifier getModifier(ReadGraph graph, Object content, String columnKey) throws DatabaseException {
        if (content instanceof ParameterNode && "Value".equals(columnKey)) {
            final ParameterNode node = (ParameterNode)content;
            return new Labeler.Modifier(){

                public String getValue() {
                    Read<String> request = new Read<String>(){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            String parameterExpression = ModuleParameterOverrideUtils.getParameterExpressionOrOverride(graph, node.getParent(), node.getIndependentVariable());
                            return parameterExpression != null ? parameterExpression : "";
                        }
                    };
                    try {
                        return (String)SimanticsUI.getSession().syncRequest((Read)request);
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                        return "";
                    }
                }

                public String isValid(String label) {
                    if (label.isEmpty()) {
                        return null;
                    }
                    if (Variability.CONTINUOUS.equals((Object)Variability.getVariability((IndependentVariable)node.getIndependentVariable(), (String)label, (boolean)false, (Configuration)node.getParentConfiguration()))) {
                        return "Not valid";
                    }
                    return null;
                }

                public void modify(final String label) {
                    SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            for (Resource r : (Collection)graph.syncRequest((Read)new ObjectsWithType(node.getParent(), L0.ConsistsOf, sr.Module_ParameterOverride))) {
                                if (!node.getVariableResource().equals(graph.getPossibleObject(r, sr.Module_ParameterOverride_overriddenParameter))) continue;
                                RemoverUtil.remove((WriteGraph)graph, (Resource)r);
                                break;
                            }
                            if (label != null && !label.isEmpty()) {
                                GraphUtils.create2((WriteGraph)graph, (Resource)sr.Module_ParameterOverride, (Object[])new Object[]{sr.Module_ParameterOverride_overriddenParameter, node.getVariableResource(), sr.Module_ParameterOverride_overrideExpression, label, L0.PartOf, node.getParent()});
                            }
                        }
                    });
                }
            };
        }
        return null;
    }
}

