/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ComponentUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.editor.DiagramViewer;
import org.simantics.sysdyn.ui.editor.SysdynEditorInput;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ShowModuleHandler
extends AbstractHandler {
    private static final String EDITOR_ID = "org.simantics.sysdyn.ui.diagramViewer";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection s = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        final Resource[] resources = ResourceAdaptionUtils.toResources((Object)s);
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(editor instanceof DiagramEditor)) {
            return null;
        }
        final DiagramViewer viewer = (DiagramViewer)((DiagramEditor)editor).getViewer();
        if (viewer == null) {
            return null;
        }
        SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                Resource runtime = viewer.getRuntime();
                String uri = (String)graph.getPossibleRelatedValue(runtime, dr.RuntimeDiagram_HasVariable, (Binding)Bindings.STRING);
                Variable parent = Variables.getVariable((ReadGraph)graph, (String)uri);
                final Resource model = Variables.getModel((ReadGraph)graph, (Variable)parent);
                Resource[] resourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    Variable variable;
                    Resource element = resourceArray[n2];
                    ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    StructuralResource2 st = StructuralResource2.getInstance((ReadGraph)graph);
                    Resource component = graph.getPossibleObject(element, mr.ElementToComponent);
                    Resource componentType = graph.getPossibleType(component, sr.Module);
                    Resource configuration = graph.getPossibleObject(componentType, st.IsDefinedBy);
                    final Resource diagram = ComponentUtils.getPossibleCompositeDiagram((ReadGraph)graph, (Resource)configuration);
                    String rvi = "";
                    try {
                        variable = parent.browse(graph, component);
                        rvi = Variables.getRVI((ReadGraph)graph, (Variable)variable);
                    }
                    catch (MissingVariableException e) {
                        variable = Variables.getVariable((ReadGraph)graph, (String)graph.getURI(component));
                    }
                    final String finalRvi = rvi;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String editorId = ShowModuleHandler.EDITOR_ID;
                                WorkbenchUtils.openEditor((String)editorId, (IEditorInput)new SysdynEditorInput(editorId, diagram, model, finalRvi));
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    ++n2;
                }
            }
        });
        return null;
    }
}

