/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import java.io.DataOutput;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.WriteBindings;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.ClusterBuilder;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.CoreInitialization;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.MissingDependencyException;
import org.simantics.graph.db.TGStatusMonitor;
import org.simantics.graph.db.TransferableGraphImporter;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphUtils;
import org.simantics.graph.representation.Value;
import org.simantics.graph.utils.TGResourceUtil;

public class TransferableGraphImportProcess
implements TransferableGraphImporter {
    public static String LOG_FILE = "transferableGraphs.log";
    private static final boolean LOG = false;
    static DataOutput log;
    TransferableGraph1 tg;
    IImportAdvisor advisor;
    TGStatusMonitor monitor;
    final TGResourceUtil resourceUtil = new TGResourceUtil();
    Resource[] resources;
    ClusterBuilder.ResourceHandle[] handles;
    Set<String> missingExternals = new HashSet<String>();
    Resource RootLibrary;
    Resource String;
    Resource Library;
    Resource InstanceOf;
    Resource ConsistsOf;
    Resource PartOf;
    Resource HasName;
    Resource NameOf;

    private static void log(String line) {
    }

    public TransferableGraphImportProcess(TransferableGraph1 tg, IImportAdvisor advisor, TGStatusMonitor monitor) {
        this.tg = tg;
        this.advisor = advisor;
        this.monitor = monitor;
    }

    public TransferableGraphImportProcess(TransferableGraph1 tg, IImportAdvisor advisor) {
        this(tg, advisor, null);
    }

    public void findBuiltins(WriteOnlyGraph g) throws DatabaseException {
        this.RootLibrary = g.getBuiltin("http:/");
        this.String = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "String");
        this.Library = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "Library");
        this.InstanceOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "InstanceOf");
        this.ConsistsOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "ConsistsOf");
        this.PartOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "PartOf");
        this.HasName = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "HasName");
        this.NameOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "NameOf");
    }

    public void findBuiltins(ReadGraph g) throws DatabaseException {
        this.RootLibrary = g.getBuiltin("http:/");
        this.String = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "String");
        this.Library = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "Library");
        this.InstanceOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "InstanceOf");
        this.ConsistsOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "ConsistsOf");
        this.PartOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "PartOf");
        this.HasName = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "HasName");
        this.NameOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "NameOf");
    }

    void initialPrepare(WriteOnlyGraph graph) throws DatabaseException {
        this.findBuiltins(graph);
        this.resources = new Resource[this.tg.resourceCount];
        int Root2 = -1;
        int SimanticsDomain = -1;
        int Layer02 = -1;
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            if (identity.definition instanceof Internal) {
                Internal def = (Internal)identity.definition;
                Resource res = null;
                if (def.parent == Layer02) {
                    try {
                        res = graph.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + def.name);
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {}
                } else if (def.parent == SimanticsDomain) {
                    if (def.name.equals("Layer0-1.1")) {
                        Layer02 = identity.resource;
                    }
                } else if (def.parent == Root2 && def.name.equals("www.simantics.org")) {
                    SimanticsDomain = identity.resource;
                }
                if (res == null) {
                    res = this.createChild(graph, this.resources[def.parent], def.name);
                } else {
                    this.createChild(graph, res, this.resources[def.parent], def.name);
                }
                this.resources[identity.resource] = res;
            } else if (identity.definition instanceof Root) {
                Root2 = identity.resource;
                this.resources[identity.resource] = this.RootLibrary;
            }
            ++n2;
        }
    }

    void addMissing(String external) {
        HashSet<String> removals = new HashSet<String>();
        for (String ext : this.missingExternals) {
            if (!ext.startsWith(external)) continue;
            return;
        }
        for (String ext : this.missingExternals) {
            if (!external.startsWith(ext)) continue;
            removals.add(ext);
        }
        this.missingExternals.removeAll(removals);
        this.missingExternals.add(external);
    }

    void prepare(ReadGraph graph) throws DatabaseException {
        this.findBuiltins(graph);
        Resource[] resources = new Resource[this.tg.resourceCount];
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Resource parent;
            External def;
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (definition instanceof External) {
                Resource child;
                def = (External)definition;
                if (def.parent == -1) {
                    resources[identity.resource] = this.RootLibrary;
                } else if ("@inverse".equals(def.name)) {
                    parent = resources[def.parent];
                    resources[identity.resource] = child = graph.getInverse(parent);
                } else {
                    parent = resources[def.parent];
                    if (parent != null) {
                        child = (Resource)((Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(parent), (AsyncProcedure)new TransientCacheAsyncListener())).get(def.name);
                        if (child == null) {
                            String uri = graph.getPossibleURI(parent);
                            if (uri == null) {
                                this.addMissing(java.lang.String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)parent)) + " /" + def.name);
                            } else {
                                this.addMissing(java.lang.String.valueOf(graph.getURI(parent)) + "/" + def.name);
                            }
                        }
                        resources[identity.resource] = child;
                    } else {
                        this.addMissing(java.lang.String.valueOf(TransferableGraphUtils.getURI((TransferableGraph1)this.tg, (int)def.parent)) + "/" + def.name);
                    }
                }
            } else if (!(definition instanceof Internal)) {
                if (definition instanceof Root) {
                    Root root = (Root)definition;
                    if (root.name.equals("")) {
                        resources[identity.resource] = this.RootLibrary;
                    } else {
                        Resource existing = this.advisor.analyzeRoot(graph, root);
                        if (existing != null) {
                            resources[identity.resource] = existing;
                        }
                    }
                } else if (definition instanceof Optional) {
                    def = (External)definition;
                    parent = resources[def.parent];
                    if (parent != null) {
                        resources[identity.resource] = (Resource)((Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(parent))).get(def.name);
                    }
                }
            }
            ++n2;
        }
        this.resources = resources;
        if (!this.missingExternals.isEmpty()) {
            throw new MissingDependencyException(this);
        }
    }

    Resource createChild(WriteOnlyGraph graph, Resource parent, String name) throws DatabaseException {
        Resource child = graph.newResource();
        Resource nameResource = graph.newResource();
        graph.claim(nameResource, this.InstanceOf, null, this.String);
        graph.claimValue(nameResource, (Object)name, WriteBindings.STRING);
        graph.claim(child, this.HasName, this.NameOf, nameResource);
        return child;
    }

    @Override
    public Resource createChild(WriteOnlyGraph graph, Resource child, Resource parent, String name) throws DatabaseException {
        graph.claim(parent, this.ConsistsOf, this.PartOf, child);
        Resource nameResource = graph.newResource();
        graph.claim(nameResource, this.InstanceOf, null, this.String);
        graph.claimValue(nameResource, (Object)name, WriteBindings.STRING);
        graph.claim(child, this.HasName, this.NameOf, nameResource);
        return child;
    }

    int[] getClustering() {
        Variant v = (Variant)this.tg.extensions.get("clustering");
        if (v == null) {
            return null;
        }
        try {
            return (int[])v.getValue((Binding)Bindings.INT_ARRAY);
        }
        catch (AdaptException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    Variant translate(SerialisationSupport ss, Value value, ClusterBuilder.ResourceHandle[] handles) throws DatabaseException {
        try {
            ResourceAdapter adapter = new ResourceAdapter(ss, value);
            this.resourceUtil.adaptValue(value.value.getBinding(), value.value.getValue(), (TGResourceUtil.LongAdapter)adapter);
            Variant result = value.value;
            if (adapter.original != null) {
                value.value = adapter.original;
            }
            return result;
        }
        catch (AccessorException e) {
            e.printStackTrace();
            return value.value;
        }
    }

    Variant translate2(Value value, Resource[] resources) throws DatabaseException {
        try {
            ResourceAdapter2 adapter = new ResourceAdapter2(value);
            this.resourceUtil.adaptValue(value.value.getBinding(), value.value.getValue(), (TGResourceUtil.LongAdapter)adapter);
            Variant result = value.value;
            if (adapter.original != null) {
                value.value = adapter.original;
            }
            return result;
        }
        catch (AccessorException e) {
            e.printStackTrace();
            return value.value;
        }
    }

    void write(WriteOnlyGraph graph) throws DatabaseException {
        int i;
        Object child;
        Resource[] resources = this.resources;
        ClusterBuilder.ResourceHandle[] handles = this.handles = new ClusterBuilder.ResourceHandle[resources.length];
        int[] clustering = this.getClustering();
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (resources[identity.resource] == null && !(definition instanceof External)) {
                Internal def;
                if (definition instanceof Internal) {
                    def = (Internal)definition;
                    resources[identity.resource] = this.createChild(graph, resources[def.parent], def.name);
                } else if (definition instanceof Root) {
                    Root root = (Root)definition;
                    resources[identity.resource] = this.advisor.createRoot(graph, root);
                } else if (definition instanceof Optional) {
                    def = (Optional)definition;
                    child = this.createChild(graph, resources[def.parent], def.name);
                    graph.claim((Resource)child, this.InstanceOf, null, this.Library);
                    resources[identity.resource] = (Resource)child;
                }
            }
            ++n2;
        }
        ClusterBuilder builder = (ClusterBuilder)graph.getService(ClusterBuilder.class);
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        if (clustering != null) {
            i = 0;
            child = clustering;
            int def = clustering.length;
            int definition = 0;
            while (definition < def) {
                int c = child[definition];
                builder.newCluster();
                int r = 0;
                while (r < c) {
                    handles[i] = resources[i] == null ? builder.newResource() : builder.resource(resources[i]);
                    ++r;
                    ++i;
                }
                ++definition;
            }
            while (i < resources.length) {
                handles[i] = resources[i] == null ? builder.newResource() : builder.resource(resources[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < resources.length) {
                handles[i] = resources[i] == null ? builder.newResource() : builder.resource(resources[i]);
                ++i;
            }
        }
        int[] statements = this.tg.statements;
        int i2 = 0;
        while (i2 < statements.length) {
            int sub = statements[i2];
            int pred = statements[i2 + 1];
            int inv = statements[i2 + 2];
            int obj = statements[i2 + 3];
            ClusterBuilder.ResourceHandle subject = handles[sub];
            ClusterBuilder.ResourceHandle predicate = handles[pred];
            ClusterBuilder.ResourceHandle object = handles[obj];
            if (resources[sub] == null) {
                subject.addStatement(graph, predicate, object);
            } else {
                graph.claim(handles[sub].resource(ss), handles[pred].resource(ss), null, handles[obj].resource(ss));
            }
            if (inv >= 0) {
                if (resources[obj] == null) {
                    ClusterBuilder.ResourceHandle inverse = handles[inv];
                    object.addStatement(graph, inverse, subject);
                } else {
                    Resource s = handles[obj].resource(ss);
                    if (!graph.isImmutable(s)) {
                        graph.claim(s, handles[inv].resource(ss), null, handles[sub].resource(ss));
                    }
                }
            }
            i2 += 4;
        }
        Value[] valueArray = this.tg.values;
        int n3 = this.tg.values.length;
        int n4 = 0;
        while (n4 < n3) {
            Value value = valueArray[n4];
            Variant variant = this.translate(ss, value, handles);
            int file = value.resource & Integer.MIN_VALUE;
            int resource = value.resource & Integer.MAX_VALUE;
            if (file != 0) {
                throw new UnsupportedOperationException();
            }
            graph.claimValue(handles[resource].resource(ss), variant.getValue(), variant.getBinding());
            ++n4;
        }
    }

    private int updatePercentage(int percentage, int done, int total) {
        int current;
        if (this.monitor != null && (done & 0x3F) == 0 && (current = 100 * done / total) > percentage) {
            percentage = current;
            this.monitor.status(percentage);
        }
        return percentage;
    }

    void write2(WriteOnlyGraph graph) throws DatabaseException {
        Resource[] resources = this.resources;
        Identity[] identityArray = this.tg.identities;
        int n = this.tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (resources[identity.resource] == null && !(definition instanceof External)) {
                Internal def;
                if (definition instanceof Internal) {
                    def = (Internal)definition;
                    resources[identity.resource] = this.createChild(graph, resources[def.parent], def.name);
                } else if (definition instanceof Root) {
                    Root root = (Root)definition;
                    resources[identity.resource] = this.advisor.createRoot(graph, root);
                } else if (definition instanceof Optional) {
                    def = (Optional)definition;
                    Resource child = this.createChild(graph, resources[def.parent], def.name);
                    graph.claim(child, this.InstanceOf, null, this.Library);
                    resources[identity.resource] = child;
                }
            }
            ++n2;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i] == null) {
                resources[i] = graph.newResource();
            }
            ++i;
        }
        int total = this.tg.statements.length + this.tg.values.length;
        int done = 0;
        int percentage = 0;
        int[] statements = this.tg.statements;
        int i2 = 0;
        while (i2 < statements.length) {
            int inv = statements[i2 + 2];
            graph.claim(resources[statements[i2]], resources[statements[i2 + 1]], inv < 0 ? null : resources[inv], resources[statements[i2 + 3]]);
            percentage = this.updatePercentage(percentage, done++, total);
            i2 += 4;
        }
        Value[] valueArray = this.tg.values;
        int n3 = this.tg.values.length;
        int n4 = 0;
        while (n4 < n3) {
            Value value = valueArray[n4];
            Variant variant = this.translate2(value, resources);
            int file = value.resource & Integer.MIN_VALUE;
            int resource = value.resource & Integer.MAX_VALUE;
            if (file != 0) {
                throw new UnsupportedOperationException();
            }
            graph.claimValue(resources[resource], variant.getValue(), variant.getBinding());
            percentage = this.updatePercentage(percentage, done++, total);
            ++n4;
        }
    }

    @Override
    public long[] getResourceIds(SerialisationSupport serializer) throws DatabaseException {
        int count = this.resources.length;
        long[] resourceIds = new long[count];
        if (this.handles != null) {
            int i = 0;
            while (i < count) {
                resourceIds[i] = serializer.getRandomAccessId(this.handles[i].resource(serializer));
                ++i;
            }
        } else {
            int i = 0;
            while (i < count) {
                resourceIds[i] = serializer.getRandomAccessId(this.resources[i]);
                ++i;
            }
        }
        return resourceIds;
    }

    class ResourceAdapter
    implements TGResourceUtil.LongAdapter {
        final SerialisationSupport ss;
        final Value value;
        Variant original;

        ResourceAdapter(SerialisationSupport ss, Value value) {
            this.ss = ss;
            this.value = value;
        }

        public long adapt(long in) {
            Resource res;
            if (this.original == null) {
                this.original = this.value.value.clone();
            }
            if ((res = TransferableGraphImportProcess.this.handles[(int)in].resource(this.ss)) == null) {
                return in;
            }
            return res.getResourceId();
        }
    }

    class ResourceAdapter2
    implements TGResourceUtil.LongAdapter {
        final Value value;
        Variant original;

        ResourceAdapter2(Value value) {
            this.value = value;
        }

        public long adapt(long in) {
            Resource res;
            if (this.original == null) {
                this.original = this.value.value.clone();
            }
            if ((res = TransferableGraphImportProcess.this.resources[(int)in]) == null) {
                return in;
            }
            return res.getResourceId();
        }
    }
}

