/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.objmap.IFunction;
import org.simantics.objmap.MappingException;
import org.simantics.objmap.impl.Link;
import org.simantics.objmap.impl.Mapping;

public class RangeUpdateRequest
implements Read<Boolean>,
SyncListener<Boolean> {
    Link link;
    IFunction<Resource, Object> map;
    Mapping mapping;

    public RangeUpdateRequest(Link link, IFunction<Resource, Object> map, Mapping mapping) {
        this.link = link;
        this.map = map;
        this.mapping = mapping;
    }

    public Boolean perform(ReadGraph g) throws DatabaseException {
        if (this.map != null) {
            boolean updated = this.link.type.updateRange(g, this.map, this.link.domainElement, this.link.rangeElement);
            this.map = null;
            return updated;
        }
        if (this.mapping != null) {
            this.mapping.domainModified(this.link);
            this.mapping = null;
            return Boolean.FALSE;
        }
        return null;
    }

    public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
        if (throwable instanceof DatabaseException) {
            throw (DatabaseException)throwable;
        }
        throw new MappingException(throwable);
    }

    public void execute(ReadGraph graph, Boolean result) throws DatabaseException {
    }

    public boolean isDisposed() {
        return this.mapping == null || this.link.removed || this.mapping.isDisposed();
    }
}

