/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.objmap.IMappingRule;
import org.simantics.objmap.annotations.RelatedValue;
import org.simantics.objmap.annotations.factories.DataTypeUtils;
import org.simantics.objmap.rules.ValueRule;
import org.simantics.objmap.rules.adapters.IdentityAdapter;
import org.simantics.objmap.rules.adapters.ValueAdapter;
import org.simantics.objmap.rules.domain.RelatedValueAccessor;
import org.simantics.objmap.rules.factory.IFieldRuleFactory;
import org.simantics.objmap.rules.range.AdaptedRangeAccessor;
import org.simantics.objmap.rules.range.FieldAccessor;
import org.simantics.objmap.rules.range.IRangeAccessor;

public class RelatedValueRuleFactory
implements IFieldRuleFactory {
    @Override
    public IMappingRule create(ReadGraph g, Annotation _annotation, Field field) throws ResourceNotFoundException, ValidationException, ServiceException {
        Resource valueType;
        RelatedValue annotation = (RelatedValue)_annotation;
        Class<? extends ValueAdapter> adapterClass = annotation.adapter();
        IRangeAccessor<Object> rangeAccessor = new FieldAccessor<Object>(field);
        if (adapterClass == IdentityAdapter.class) {
            valueType = DataTypeUtils.dataTypeOfClass(g, field.getType());
        } else {
            try {
                ValueAdapter adapter = adapterClass.newInstance();
                rangeAccessor = new AdaptedRangeAccessor(rangeAccessor, adapter);
                valueType = adapter.rangeTypeToDomainType(g, field.getType());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return new ValueRule(new RelatedValueAccessor(g.getResource(annotation.value()), valueType), rangeAccessor);
    }
}

