/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.Pair;

class IndexSchema {
    public static final EnumSet<Type> NUMERIC_TYPES = EnumSet.of(Type.INT, Type.LONG, Type.FLOAT, Type.DOUBLE);
    public final Pair<String, String>[] fields;
    public final Map<String, Type> typeMap;

    public IndexSchema(Pair<String, String>[] fields) {
        this.fields = fields;
        THashMap typeMap = new THashMap();
        Pair<String, String>[] pairArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<String, String> field = pairArray[n2];
            Type type = IndexSchema.parseType(field);
            typeMap.put((String)field.first, type);
            ++n2;
        }
        this.typeMap = Collections.unmodifiableMap(typeMap);
    }

    public boolean hasField(String fieldName) {
        return this.typeMap.get(fieldName) != null;
    }

    private static Type parseType(Pair<String, String> field) {
        switch ((String)field.second) {
            case "Int": {
                return Type.INT;
            }
            case "Long": {
                return Type.LONG;
            }
            case "Float": {
                return Type.FLOAT;
            }
            case "Double": {
                return Type.DOUBLE;
            }
            case "String": {
                return Type.STRING;
            }
            case "Text": {
                return Type.TEXT;
            }
        }
        throw new IllegalArgumentException("Unrecognized index field type '" + (String)field.second + "' for field '" + (String)field.first + "'");
    }

    public static IndexSchema readFromRelation(RequestProcessor processor, final Resource relation) {
        try {
            return (IndexSchema)processor.syncRequest((Read)new UniqueRead<IndexSchema>(){

                public IndexSchema perform(ReadGraph graph) throws DatabaseException {
                    return IndexSchema.readFromRelation(graph, relation);
                }
            });
        }
        catch (DatabaseException e) {
            throw new RuntimeDatabaseException((Throwable)e);
        }
    }

    public static IndexSchema readFromRelation(ReadGraph graph, Resource relation) throws DatabaseException {
        try {
            GenericRelation r = (GenericRelation)graph.adapt(relation, GenericRelation.class);
            return new IndexSchema(r.getFields());
        }
        catch (IllegalArgumentException e) {
            throw new DatabaseException("Failed to read index schema for relation " + relation + ". See cause for reason.", (Throwable)e);
        }
    }

    public static enum Type {
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING,
        TEXT;

    }
}

