/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.editor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.ui.workbench.editor.EditorAdapterDescriptor;

public class EditorAdapterDescriptorImpl
implements EditorAdapterDescriptor {
    private final String id;
    private final String groupId;
    private final EditorAdapter adapter;
    private final String[] inContexts;

    public EditorAdapterDescriptorImpl(String id, String groupId, EditorAdapter adapter, String[] inContexts) {
        this.id = id;
        if (groupId != null && groupId.isEmpty()) {
            groupId = null;
        }
        this.groupId = groupId;
        this.adapter = adapter;
        if (inContexts != null && inContexts.length == 0) {
            inContexts = null;
        }
        this.inContexts = inContexts;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public EditorAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public Collection<String> getInContexts() {
        if (this.inContexts == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.inContexts);
    }

    @Override
    public boolean isActive(Collection<?> activeContextIds) {
        if (this.inContexts == null) {
            return true;
        }
        String[] stringArray = this.inContexts;
        int n = this.inContexts.length;
        int n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            if (activeContextIds.contains(o)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EditorAdapterDescriptorImpl.class.getSimpleName()).append(" id=").append(this.id).append(" gId=").append(this.groupId);
        return sb.toString();
    }
}

