/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.dialogs;

import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.simantics.db.Resource;
import org.simantics.db.exception.InvalidResourceReferenceException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.ui.SimanticsUI;

public abstract class ResourceSelectionDialog<T>
extends FilteredItemsSelectionDialog {
    Map<T, String> nameMap;
    String title;

    public ResourceSelectionDialog(Shell shell, Map<T, String> parameter, String title) {
        super(shell, true);
        this.nameMap = parameter;
        this.title = title;
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ResourceSelectionDialog.this.nameMap.get(element);
            }
        };
        this.setListLabelProvider((ILabelProvider)labelProvider);
        this.setDetailsLabelProvider((ILabelProvider)labelProvider);
        this.setSelectionHistory(new ResourceSelectionHistory());
        this.setTitle(title);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ResourceSelectionDialogItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        for (T o : this.nameMap.keySet()) {
            contentProvider.add(o, itemsFilter);
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    protected abstract IDialogSettings getBaseDialogSettings();

    protected IDialogSettings getDialogSettings() {
        IDialogSettings base = this.getBaseDialogSettings();
        IDialogSettings settings = base.getSection(this.title);
        if (settings == null) {
            settings = base.addNewSection(this.title);
        }
        return settings;
    }

    public String getElementName(Object item) {
        return this.nameMap.get(item);
    }

    protected Comparator<?> getItemsComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ResourceSelectionDialog.this.nameMap.get(o1).compareToIgnoreCase(ResourceSelectionDialog.this.nameMap.get(o2));
            }
        };
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    class ResourceSelectionDialogItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public ResourceSelectionDialogItemsFilter() {
            super((FilteredItemsSelectionDialog)ResourceSelectionDialog.this);
            String patternText = this.getPattern();
            this.patternMatcher = new SearchPattern();
            if (patternText != null && patternText.length() > 0) {
                this.patternMatcher.setPattern(patternText);
            } else {
                this.patternMatcher.setPattern("*");
            }
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            return this.matches(ResourceSelectionDialog.this.nameMap.get(item));
        }
    }

    class ResourceSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        ResourceSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
            if (item instanceof Resource) {
                try {
                    SerialisationSupport support = (SerialisationSupport)SimanticsUI.getSession().getService(SerialisationSupport.class);
                    memento.putTextData(support.getResourceSerializer().createRandomAccessId((Resource)item));
                }
                catch (InvalidResourceReferenceException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

