/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.tester;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.expressions.PropertyTester;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.ValueTypeMismatchException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class BasicResourcePropertyTester
extends PropertyTester {
    private static final boolean DEBUG = false;
    protected static final String RESOURCE_TYPE = "resourceType";
    protected static final String ALL_RESOURCES_OF_TYPE = "allResourcesOfType";
    protected static final String INHERITS = "inherits";
    protected static final String ALL_INHERIT = "allInherit";
    protected static final String NAME_MATCHES = "nameMatches";
    protected static final String HAS_TAG = "hasTag";
    protected static final String HAS_PARENT = "hasParent";
    protected static final String HAS_STATEMENT = "hasStatement";
    private static final OntologyVersions VERSIONS = OntologyVersions.getInstance();

    public boolean test(Object receiver, final String property, final Object[] args, final Object expectedValue) {
        boolean multiResourceTest;
        final Resource resource = ResourceAdaptionUtils.toSingleResource(receiver);
        final Resource[] resources = ResourceAdaptionUtils.toResources(receiver);
        if (resources.length == 0) {
            return false;
        }
        boolean bl = multiResourceTest = ALL_RESOURCES_OF_TYPE.equals(property) || ALL_INHERIT.equals(property);
        if (!multiResourceTest && resource == null) {
            return false;
        }
        if (DatabaseJob.inProgress()) {
            return false;
        }
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null) {
            return false;
        }
        try {
            return (Boolean)RequestUtil.trySyncRequest((Session)ctx.getSession(), (long)SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT, (long)SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT, (Object)false, (Read)new UniqueRead<Boolean>(){

                public Boolean perform(ReadGraph g) throws DatabaseException {
                    if (multiResourceTest) {
                        return BasicResourcePropertyTester.this.doTest(g, resources, property, args, expectedValue);
                    }
                    return BasicResourcePropertyTester.this.doTest(g, resource, property, args, expectedValue);
                }
            });
        }
        catch (InterruptedException | DatabaseException throwable) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean doTest(ReadGraph g, Resource resource, String property, Object[] args, Object expectedValue) throws DatabaseException {
        if (RESOURCE_TYPE.equals(property)) {
            try {
                int i = 0;
                while (i < args.length) {
                    if (g.isInstanceOf(resource, g.getResource(VERSIONS.currentVersion((String)args[i])))) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                return false;
            }
            return false;
        }
        if (INHERITS.equals(property)) {
            try {
                int i = 0;
                while (i < args.length) {
                    if (g.isInheritedFrom(resource, g.getResource(VERSIONS.currentVersion((String)args[i])))) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                return false;
            }
            return false;
        }
        if (NAME_MATCHES.equals(property)) {
            if (args.length == 0) {
                return false;
            }
            Pattern[] patterns = new Pattern[args.length];
            int i = 0;
            while (i < args.length) {
                patterns[i] = Pattern.compile((String)args[i]);
                ++i;
            }
            try {
                Layer0 L0 = Layer0.getInstance((ReadGraph)g);
                for (Resource r : g.getObjects(resource, L0.HasName)) {
                    String name = (String)g.getPossibleValue(r, (Binding)Bindings.STRING);
                    if (name == null) continue;
                    Pattern[] patternArray = patterns;
                    int n = patterns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Pattern p = patternArray[n2];
                        Matcher m = p.matcher(name);
                        if (m.matches()) {
                            return true;
                        }
                        ++n2;
                    }
                }
            }
            catch (ValueTypeMismatchException e) {
                e.printStackTrace();
            }
            catch (BindingException e) {
                e.printStackTrace();
            }
            return false;
        }
        if (HAS_TAG.equals(property)) {
            try {
                int i = 0;
                while (i < args.length) {
                    Resource tag = (Resource)g.syncRequest(Queries.resource((String)((String)args[i])));
                    if (g.hasStatement(resource, tag)) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                return false;
            }
        }
        if (HAS_PARENT.equals(property)) {
            try {
                int i = 0;
                while (i < args.length) {
                    Resource type = (Resource)g.syncRequest(Queries.resource((String)((String)args[i])));
                    Resource parent = (Resource)g.syncRequest((AsyncRead)new PossibleTypedParent(resource, type));
                    if (parent != null) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                return false;
            }
        }
        if (HAS_STATEMENT.equals(property)) {
            try {
                int i = 0;
                while (i < args.length) {
                    Resource predicate = g.getResource(VERSIONS.currentVersion((String)args[i]));
                    if (g.hasStatement(resource, predicate)) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                return false;
            }
        }
        return false;
    }

    protected boolean doTest(ReadGraph g, Resource[] resources, String property, Object[] args, Object expectedValue) throws DatabaseException {
        if (ALL_RESOURCES_OF_TYPE.equals(property)) {
            Resource[] argTypes = new Resource[args.length];
            boolean argTypesResolved = false;
            int i = 0;
            while (i < args.length) {
                try {
                    argTypes[i] = g.getResource(VERSIONS.currentVersion((String)args[i]));
                    argTypesResolved = true;
                }
                catch (ResourceNotFoundException resourceNotFoundException) {}
                ++i;
            }
            if (!argTypesResolved) {
                return false;
            }
            Resource[] resourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource = resourceArray[n2];
                Set rts = g.getTypes(resource);
                boolean hasArgType = false;
                int t = 0;
                while (t < argTypes.length) {
                    if (argTypes[t] != null && rts.contains(argTypes[t])) {
                        hasArgType = true;
                    }
                    ++t;
                }
                if (!hasArgType) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (ALL_INHERIT.equals(property)) {
            Resource[] argTypes = new Resource[args.length];
            boolean argTypesResolved = false;
            int i = 0;
            while (i < args.length) {
                try {
                    argTypes[i] = g.getResource(VERSIONS.currentVersion((String)args[i]));
                    argTypesResolved = true;
                }
                catch (ResourceNotFoundException resourceNotFoundException) {}
                ++i;
            }
            if (!argTypesResolved) {
                return false;
            }
            Resource[] resourceArray = resources;
            int n = resources.length;
            int n3 = 0;
            while (n3 < n) {
                Resource resource = resourceArray[n3];
                boolean inheritsArgType = false;
                int t = 0;
                while (t < argTypes.length) {
                    if (argTypes[t] != null && g.isInheritedFrom(resource, argTypes[t])) {
                        inheritsArgType = true;
                    }
                    ++t;
                }
                if (!inheritsArgType) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }
}

