/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.selection;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.IsInstanceOf;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableURI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.ui.ISelectionUtils;

public class WorkbenchSelectionUtils {
    public static Resource getPossibleResource(ExecutionEvent event) throws DatabaseException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return WorkbenchSelectionUtils.getPossibleResource(selection);
    }

    public static Variable getPossibleVariable(ExecutionEvent event) throws DatabaseException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return WorkbenchSelectionUtils.getPossibleVariable(selection);
    }

    public static List<WorkbenchSelectionElement> getWorkbenchSelectionElements(ISelection selection) {
        return ISelectionUtils.filterSelection((ISelection)selection, WorkbenchSelectionElement.class);
    }

    public static String getPossibleJSON(Object selection) throws DatabaseException {
        WorkbenchSelectionElement element = WorkbenchSelectionUtils.getPossibleWorkbenchSelectionElement(selection);
        return element != null ? WorkbenchSelectionUtils.getPossibleJSON(element) : null;
    }

    public static Resource getPossibleResource(Object selection) throws DatabaseException {
        WorkbenchSelectionElement element = WorkbenchSelectionUtils.getPossibleWorkbenchSelectionElement(selection);
        return element != null ? WorkbenchSelectionUtils.getPossibleResource(element) : null;
    }

    public static Variable getPossibleVariable(Object selection) throws DatabaseException {
        WorkbenchSelectionElement element = WorkbenchSelectionUtils.getPossibleWorkbenchSelectionElement(selection);
        return element != null ? WorkbenchSelectionUtils.getPossibleVariable(element) : null;
    }

    public static Resource getPossibleResourceFromSelection(RequestProcessor processor, Object selection) throws DatabaseException {
        WorkbenchSelectionElement element = WorkbenchSelectionUtils.getPossibleWorkbenchSelectionElement(selection);
        return element != null ? WorkbenchSelectionUtils.getPossibleResource(processor, element) : null;
    }

    public static Variable getPossibleVariableFromSelection(RequestProcessor processor, Object selection) throws DatabaseException {
        WorkbenchSelectionElement element = WorkbenchSelectionUtils.getPossibleWorkbenchSelectionElement(selection);
        return element != null ? WorkbenchSelectionUtils.getPossibleVariable(processor, element) : null;
    }

    public static Variable getPossibleVariable(Object[] selection) throws DatabaseException {
        if (selection.length != 1) {
            return null;
        }
        if (!(selection[0] instanceof WorkbenchSelectionElement)) {
            return null;
        }
        return WorkbenchSelectionUtils.getPossibleVariable((WorkbenchSelectionElement)selection[0]);
    }

    public static <T> T getPossibleElement(Object[] selection, WorkbenchSelectionContentType<T> contentType) throws DatabaseException {
        if (selection.length != 1) {
            return null;
        }
        if (!(selection[0] instanceof WorkbenchSelectionElement)) {
            return null;
        }
        WorkbenchSelectionElement wse = (WorkbenchSelectionElement)selection[0];
        return wse.getContent(contentType);
    }

    public static String getPossibleJSON(WorkbenchSelectionElement wse) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleJSON((RequestProcessor)Simantics.getSession(), wse);
    }

    public static Resource getPossibleResource(WorkbenchSelectionElement wse) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleResource((RequestProcessor)Simantics.getSession(), wse);
    }

    public static Variable getPossibleVariable(WorkbenchSelectionElement wse) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleVariable((RequestProcessor)Simantics.getSession(), wse);
    }

    public static Variable getPossibleVariableSCL(ReadGraph graph, WorkbenchSelectionElement wse) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleVariable((RequestProcessor)graph, wse);
    }

    public static Resource getPossibleResourceSCL(ReadGraph graph, WorkbenchSelectionElement wse) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleResource((RequestProcessor)graph, wse);
    }

    public static String getPossibleJSON(RequestProcessor processor, Object input) throws DatabaseException {
        Variable var = WorkbenchSelectionUtils.getPossibleVariable(processor, input);
        if (var != null) {
            String uri = (String)processor.syncRequest((Read)new VariableURI(var));
            return "{ \"type\":\"Variable\", \"uri\" : \"" + uri + "\" }";
        }
        Resource res = WorkbenchSelectionUtils.getPossibleResource(processor, input);
        if (res != null) {
            return "{ type:\"Resource\" }";
        }
        return "{ type:\"Unknown\" }";
    }

    public static Resource getPossibleResource(RequestProcessor processor, Object input) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleResource(processor, input, null);
    }

    public static Resource getPossibleResource(RequestProcessor processor, Object input, Resource type) throws DatabaseException {
        Object element;
        if (input instanceof Collection && !((Collection)input).isEmpty() && (element = ((Collection)input).iterator().next()) instanceof Resource) {
            return (Resource)element;
        }
        Resource resource = WorkbenchSelectionUtils.getPossibleElement(input, new AnyResource(processor));
        if (resource == null) {
            return resource;
        }
        if (type != null) {
            if (((Boolean)processor.sync((ReadInterface)new IsInstanceOf(resource, type))).booleanValue()) {
                return resource;
            }
            return null;
        }
        return resource;
    }

    public static Variable getPossibleVariable(RequestProcessor processor, Object input) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleElement(input, new AnyVariable(processor));
    }

    public static <T> T getPossibleElement(Object input, WorkbenchSelectionContentType<T> contentType) {
        Object single = WorkbenchSelectionUtils.getPossibleSingleElement(input);
        if (single == null) {
            return null;
        }
        if (single instanceof WorkbenchSelectionElement) {
            WorkbenchSelectionElement element = (WorkbenchSelectionElement)single;
            return element.getContent(contentType);
        }
        return null;
    }

    public static WorkbenchSelectionElement getPossibleSelectionElement(Object input) {
        Object o;
        Collection c;
        if (input instanceof WorkbenchSelectionElement) {
            return (WorkbenchSelectionElement)input;
        }
        if (input instanceof Collection && (c = (Collection)input).size() == 1 && (o = c.iterator().next()) instanceof WorkbenchSelectionElement) {
            return (WorkbenchSelectionElement)o;
        }
        return null;
    }

    private static Object getPossibleSingleElement(Object input) {
        Collection c;
        if (input instanceof WorkbenchSelectionElement) {
            return input;
        }
        if (input instanceof Collection && (c = (Collection)input).size() == 1) {
            return c.iterator().next();
        }
        return null;
    }

    private static WorkbenchSelectionElement getPossibleWorkbenchSelectionElement(Object selection) {
        return WorkbenchSelectionUtils.getPossibleObject(selection, WorkbenchSelectionElement.class);
    }

    private static <T> T getPossibleObject(Object selection, Class<T> clazz) {
        return (T)(clazz.isInstance(selection) ? selection : ISelectionUtils.filterSingleSelection((Object)selection, clazz));
    }
}

