/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.Collections;
import java.util.Map;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.browsing.ui.graph.impl.GraphStringModifier;
import org.simantics.browsing.ui.graph.impl.LabelerUtil;
import org.simantics.browsing.ui.graph.impl.LazyGraphLabeler;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;

public class StringRepresentationLabelerFactory
implements LabelerFactory {
    String column = "single";

    public StringRepresentationLabelerFactory() {
    }

    public StringRepresentationLabelerFactory(String column) {
        this.column = column;
    }

    public Labeler create(PrimitiveQueryUpdater updater, final NodeContext context, BuiltinKeys.LabelerKey key) {
        assert (updater != null);
        assert (context != null);
        return new LazyGraphLabeler(updater, context, key){

            @Override
            public Map<String, String> labels(ReadGraph graph) throws DatabaseException {
                Resource r = (Resource)context.getConstant(BuiltinKeys.INPUT);
                String representation = LabelerUtil.safeStringRepresentation(graph, r);
                return Collections.singletonMap(StringRepresentationLabelerFactory.this.column, representation);
            }

            public Labeler.Modifier getModifier(GraphExplorer.ModificationContext modificationContext, String key) {
                ISessionContext session = Simantics.getSessionContext();
                if (session == null) {
                    return null;
                }
                if (StringRepresentationLabelerFactory.this.column.equals(key)) {
                    return new GraphStringModifier(context, (RequestProcessor)session.getSession()){

                        @Override
                        public void doModify(WriteGraph graph, String label) throws DatabaseException {
                            this.getModifier().modify(graph, (Object)label);
                        }

                        @Override
                        public String createModifierInput(String fromLabel) {
                            return fromLabel;
                        }
                    };
                }
                return null;
            }
        };
    }
}

