/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.utils;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.profile.Profiles;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;

public class ProfileEntries {
    public static void createStandardProfiles(WriteGraph graph, Resource model) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource simulationPlaybackProfile = ProfileEntries.createProfile(graph, "Simulation Playback", sr.SimulationPlaybackProfile, sr.Profiles_SimulationPlaybackColours);
        Resource defaultProfile = ProfileEntries.createProfile(graph, "Default", sr.DefaultProfile, sr.Profiles_IssueWarnings, sr.Profiles_ShadowVisualizations);
        graph.claim(model, L0.ConsistsOf, simulationPlaybackProfile);
        graph.claim(model, L0.ConsistsOf, defaultProfile);
        graph.claim(model, DIA.HasActiveProfile, defaultProfile);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        graph.claim(defaultProfile, SIMU.IsActive, null, sr.Profiles_IssueWarnings);
        graph.claim(defaultProfile, SIMU.IsActive, null, sr.Profiles_ShadowVisualizations);
        graph.claim(simulationPlaybackProfile, SIMU.IsActive, null, sr.Profiles_SimulationPlaybackColours);
    }

    public static Resource createProfile(WriteGraph graph, String name, Resource type, Resource ... entries) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource profile = Profiles.createProfile((WriteGraph)graph, (String)name, (Resource[])entries);
        graph.deny(profile, L0.InstanceOf);
        graph.claim(profile, L0.InstanceOf, null, type);
        return profile;
    }
}

