/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.simantics.db.procedure.Listener;
import org.simantics.document.server.DocumentHistory;
import org.simantics.document.server.JSONObject;
import org.simantics.utils.datastructures.Pair;

public class DocumentHistoryCollector {
    static Map<String, DocumentHistory> histories = new THashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentHistory getHistory(String location, boolean create) {
        Map<String, DocumentHistory> map = histories;
        synchronized (map) {
            DocumentHistory history = histories.get(location);
            if (history == null && create) {
                history = new DocumentHistory();
                DocumentHistoryCollector.pruneHistories();
                histories.put(location, history);
            }
            return history;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pruneHistories() {
        Map<String, DocumentHistory> map = histories;
        synchronized (map) {
            Iterator<Map.Entry<String, DocumentHistory>> iter = histories.entrySet().iterator();
            while (iter.hasNext()) {
                DocumentHistory entryHistory;
                Map.Entry<String, DocumentHistory> entry = iter.next();
                DocumentHistory documentHistory = entryHistory = entry.getValue();
                synchronized (documentHistory) {
                    if (!entryHistory.hasListeners()) {
                        iter.remove();
                    }
                }
            }
        }
    }

    public static Pair<Integer, Collection<JSONObject>> readChanges(String location, int sequenceNumber) {
        DocumentHistory history = DocumentHistoryCollector.getHistory(location, false);
        if (history != null) {
            return history.readChanges(sequenceNumber);
        }
        return null;
    }

    public static Pair<Integer, Collection<JSONObject>> getContent(Listener<Integer> listener, String location, int sequenceNumber) {
        DocumentHistory history = DocumentHistoryCollector.getHistory(location, true);
        return history.getContent(listener, location, sequenceNumber);
    }
}

