/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.handler.impl;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementLayers;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.element.handler.Pick2;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.layers.ILayers;
import org.simantics.scenegraph.utils.GeometryUtils;

public class PickContextImpl
implements PickContext {
    public static final PickContextImpl INSTANCE = new PickContextImpl();

    @Override
    public void pick(IDiagram diagram, PickRequest request, Collection<IElement> finalResult) {
        assert (diagram != null);
        assert (request != null);
        assert (finalResult != null);
        ILayers layers = (ILayers)diagram.getHint(DiagramHints.KEY_LAYERS);
        Collection<IElement> result = finalResult;
        if (request.pickSorter != null) {
            result = new ArrayList<IElement>();
        }
        Rectangle2D.Double elementBounds = new Rectangle2D.Double();
        block2: for (IElement e : diagram.getSnapshot()) {
            InternalSize b;
            Transform t;
            AffineTransform canvasToElement;
            ElementLayers el;
            if (ElementUtils.isHidden(e)) continue;
            ElementClass ec = e.getElementClass();
            if (layers != null && !layers.getIgnoreFocusSettings() && (el = ec.getAtMostOneItemOfClass(ElementLayers.class)) != null && !el.isFocusable(e, layers) || request.pickFilter != null && !request.pickFilter.accept(e) || (canvasToElement = (t = e.getElementClass().getSingleItem(Transform.class)).getTransform(e)) == null) continue;
            double det = canvasToElement.getDeterminant();
            if (det == 0.0) {
                canvasToElement.setToTranslation(canvasToElement.getTranslateX(), canvasToElement.getTranslateY());
            }
            if ((b = e.getElementClass().getAtMostOneItemOfClass(InternalSize.class)) == null) continue;
            elementBounds.setFrame(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
            b.getBounds(e, elementBounds);
            if (Double.isNaN(((RectangularShape)elementBounds).getWidth()) || Double.isNaN(((RectangularShape)elementBounds).getHeight())) continue;
            Shape elementBoundsOnCanvas = org.simantics.g2d.utils.GeometryUtils.transformShape(elementBounds, canvasToElement);
            if (elementBoundsOnCanvas instanceof Rectangle2D) {
                elementBoundsOnCanvas = elementBoundsOnCanvas.getBounds2D();
            }
            elementBoundsOnCanvas = elementBoundsOnCanvas.getBounds2D();
            GeometryUtils.expandRectangle((Rectangle2D)((Rectangle2D)elementBoundsOnCanvas), (double)0.001, (double)0.001, (double)0.001, (double)0.001);
            List<Pick> pickHandlers = e.getElementClass().getItemsByClass(Pick.class);
            if (!pickHandlers.isEmpty()) {
                if (!org.simantics.g2d.utils.GeometryUtils.intersects(request.pickArea, elementBoundsOnCanvas)) continue;
                for (Pick p : pickHandlers) {
                    if (p instanceof Pick2) {
                        Pick2 p2 = (Pick2)p;
                        if (p2.pick(e, request.pickArea, request.pickPolicy, result) <= 0) continue;
                        continue block2;
                    }
                    if (!p.pickTest(e, request.pickArea, request.pickPolicy)) continue;
                    result.add(e);
                    continue block2;
                }
                continue;
            }
            List<Outline> shapeHandlers = e.getElementClass().getItemsByClass(Outline.class);
            if (!shapeHandlers.isEmpty()) {
                Shape elementShape;
                AffineTransform elementToCanvas;
                if (!org.simantics.g2d.utils.GeometryUtils.intersects(request.pickArea, elementBoundsOnCanvas)) continue;
                try {
                    elementToCanvas = canvasToElement.createInverse();
                }
                catch (NoninvertibleTransformException e1) {
                    throw new RuntimeException(e1);
                }
                Shape pickShapeInElementCoords = org.simantics.g2d.utils.GeometryUtils.transformShape(request.pickArea, elementToCanvas);
                if (request.pickPolicy == PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS) {
                    for (Outline es : shapeHandlers) {
                        elementShape = es.getElementShape(e);
                        if (elementShape == null) continue block2;
                        if (!org.simantics.g2d.utils.GeometryUtils.intersects(pickShapeInElementCoords, elementShape)) continue;
                        result.add(e);
                        continue block2;
                    }
                    continue;
                }
                if (request.pickPolicy != PickRequest.PickPolicy.PICK_CONTAINED_OBJECTS) continue;
                for (Outline es : shapeHandlers) {
                    elementShape = es.getElementShape(e);
                    if (!org.simantics.g2d.utils.GeometryUtils.contains(pickShapeInElementCoords, elementShape)) continue block2;
                }
                result.add(e);
                continue;
            }
            if (request.pickPolicy == PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS) {
                if (!org.simantics.g2d.utils.GeometryUtils.intersects(request.pickArea, elementBoundsOnCanvas)) continue;
                result.add(e);
                continue;
            }
            if (request.pickPolicy != PickRequest.PickPolicy.PICK_CONTAINED_OBJECTS || !org.simantics.g2d.utils.GeometryUtils.contains(request.pickArea, elementBoundsOnCanvas)) continue;
            result.add(e);
        }
        if (request.pickSorter != null) {
            request.pickSorter.sort((List)result);
            finalResult.addAll(result);
        }
    }
}

