/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.canvas.impl;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.canvas.IContentContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.IEventHandlerStack;
import org.simantics.utils.datastructures.context.IContext;
import org.simantics.utils.datastructures.context.IContextListener;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintStack;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public abstract class AbstractCanvasParticipant
implements ICanvasParticipant {
    private ICanvasContext context;
    private IThreadWorkQueue thread;
    protected IHintContext localHintCtx = null;
    protected int localPriority = 0;
    protected IHintContext hintCtx = null;
    protected IHintStack hintStack;
    protected SGNodeReflection.CanvasSGNodeDefinition[] sghandlers;
    protected EventHandlerReflection.EventHandlerDefinition[] eventHandlers;
    protected HintReflection.HintListenerDefinition[] hintListeners;
    protected DependencyReflection.ReferenceDefinition[] refDefs;
    protected boolean depsSatisfied = false;
    private final IContextListener<ICanvasParticipant> ctxListener = new IContextListener<ICanvasParticipant>(){

        public void itemAdded(IContext<ICanvasParticipant> sender, ICanvasParticipant item) {
            AbstractCanvasParticipant.this._itemAdded((IContext<ICanvasParticipant>)sender, item);
            if (!AbstractCanvasParticipant.this.depsSatisfied) {
                AbstractCanvasParticipant.this.depsSatisfied = AbstractCanvasParticipant.this.checkDependencies();
            }
        }

        public void itemRemoved(IContext<ICanvasParticipant> sender, ICanvasParticipant item) {
            AbstractCanvasParticipant.this._itemRemoved((IContext<ICanvasParticipant>)sender, item);
            AbstractCanvasParticipant.this.depsSatisfied = AbstractCanvasParticipant.this.depsSatisfied;
        }
    };
    Set<Field> missingDependencies = new HashSet<Field>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _itemAdded(IContext<ICanvasParticipant> sender, ICanvasParticipant item) {
        IContextListener<ICanvasParticipant> iContextListener = this.ctxListener;
        synchronized (iContextListener) {
            Class<?> c = item.getClass();
            try {
                DependencyReflection.ReferenceDefinition[] referenceDefinitionArray = this.refDefs;
                int n = this.refDefs.length;
                int n2 = 0;
                while (n2 < n) {
                    DependencyReflection.ReferenceDefinition def = referenceDefinitionArray[n2];
                    Class<?> defClass = def.requirement;
                    if (defClass.isAssignableFrom(c)) {
                        Field f = def.field;
                        Object value = f.get(this);
                        assert (value == null);
                        f.set(this, item);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _itemRemoved(IContext<ICanvasParticipant> sender, ICanvasParticipant item) {
        IContextListener<ICanvasParticipant> iContextListener = this.ctxListener;
        synchronized (iContextListener) {
            Class<?> c = item.getClass();
            try {
                DependencyReflection.ReferenceDefinition[] referenceDefinitionArray = this.refDefs;
                int n = this.refDefs.length;
                int n2 = 0;
                while (n2 < n) {
                    DependencyReflection.ReferenceDefinition def = referenceDefinitionArray[n2];
                    Class<?> defClass = def.requirement;
                    Field f = def.field;
                    if (defClass.isAssignableFrom(c)) {
                        f.set(this, null);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public AbstractCanvasParticipant() {
        this.sghandlers = SGNodeReflection.getSGHandlers(this);
        this.eventHandlers = EventHandlerReflection.getEventHandlers((Object)this);
        this.refDefs = DependencyReflection.getDependencies(this, DependencyReflection.ReferenceType.CanvasParticipant);
        this.hintListeners = HintReflection.getDependencies(this);
        if (this.refDefs.length == 0) {
            this.depsSatisfied = true;
        }
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        assert (ctx != null);
        assert (this.context == null);
        this.context = ctx;
        this.hintStack = ctx.getHintStack();
        this.thread = ctx.getThreadAccess();
        IEventHandlerStack eventHandlerStack = this.getContext().getEventHandlerStack();
        Object[] objectArray = this.eventHandlers;
        int n = this.eventHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            EventHandlerReflection.EventHandlerDefinition eventHandler = objectArray[n2];
            eventHandlerStack.add((Object)eventHandler.eventHandler, eventHandler.priority);
            ++n2;
        }
        if (this.refDefs.length != 0) {
            this.getContext().addContextListener(this.ctxListener);
            objectArray = (ICanvasParticipant[])this.getContext().toArray();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                EventHandlerReflection.EventHandlerDefinition cp = objectArray[n2];
                this._itemAdded(this.getContext(), (ICanvasParticipant)cp);
                ++n2;
            }
            this.depsSatisfied = this.checkDependencies();
        }
        IHintStack stack = this.getContext().getHintStack();
        IThreadWorkQueue thread = this.getContext().getThreadAccess();
        Object[] objectArray2 = this.hintListeners;
        int n3 = this.hintListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            HintReflection.HintListenerDefinition def = objectArray2[n4];
            stack.addKeyHintListener(thread, def.key, (IHintListener)def);
            ++n4;
        }
        objectArray2 = this.sghandlers;
        n3 = this.sghandlers.length;
        n4 = 0;
        while (n4 < n3) {
            Object sg = objectArray2[n4];
            if (((SGNodeReflection.CanvasSGNodeDefinition)sg).initDesignation != null) {
                switch (((SGNodeReflection.CanvasSGNodeDefinition)sg).initDesignation) {
                    case CONTROL: {
                        ((SGNodeReflection.CanvasSGNodeDefinition)sg).init((G2DParentNode)ctx.getSceneGraph());
                        break;
                    }
                    case CANVAS: {
                        ((SGNodeReflection.CanvasSGNodeDefinition)sg).init(ctx.getCanvasNode());
                    }
                }
            }
            ++n4;
        }
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        assert (ctx != null);
        if (this.context == null) {
            throw new RuntimeException("Interactor was not in any context");
        }
        if (this.refDefs.length != 0) {
            this.getContext().removeContextListener(this.ctxListener);
        }
        SGNodeReflection.CanvasSGNodeDefinition[] canvasSGNodeDefinitionArray = this.sghandlers;
        int n = this.sghandlers.length;
        int n2 = 0;
        while (n2 < n) {
            SGNodeReflection.CanvasSGNodeDefinition sg = canvasSGNodeDefinitionArray[n2];
            sg.cleanup();
            ++n2;
        }
        IEventHandlerStack eventHandlerStack = this.context.getEventHandlerStack();
        EventHandlerReflection.EventHandlerDefinition[] eventHandlerDefinitionArray = this.eventHandlers;
        int n3 = this.eventHandlers.length;
        n = 0;
        while (n < n3) {
            EventHandlerReflection.EventHandlerDefinition eventHandler = eventHandlerDefinitionArray[n];
            eventHandlerStack.remove((Object)eventHandler.eventHandler);
            ++n;
        }
        IHintStack stack = this.getContext().getHintStack();
        IThreadWorkQueue thread = this.getContext().getThreadAccess();
        HintReflection.HintListenerDefinition[] hintListenerDefinitionArray = this.hintListeners;
        int n4 = this.hintListeners.length;
        int n5 = 0;
        while (n5 < n4) {
            HintReflection.HintListenerDefinition def = hintListenerDefinitionArray[n5];
            stack.removeKeyHintListener(thread, def.key, (IHintListener)def);
            ++n5;
        }
        if (this.localHintCtx != null) {
            this.context.getHintStack().removeHintContext(this.localHintCtx);
        }
        this.context = null;
    }

    public boolean isRemoved() {
        return this.context == null;
    }

    public void remove() {
        if (this.isRemoved()) {
            throw new RuntimeException("Interactor has already been removed from the context");
        }
        this.context.remove(this);
    }

    public IHintStack getHintStack() {
        return this.hintStack;
    }

    public synchronized IHintContext getLocalHintContext() {
        return this.localHintCtx;
    }

    public synchronized IHintContext getWriteableHintStack() {
        if (this.hintCtx == null) {
            this.hintCtx = this.getHintStack().createStackRead(this.getLocalHintContext());
        }
        return this.hintCtx;
    }

    public IHintContext getWriteableHintContext() {
        ICanvasContext ctx = this.context;
        assert (ctx != null);
        if (this.localHintCtx != null) {
            return this.localHintCtx;
        }
        return ctx.getDefaultHintContext();
    }

    public <E> E getHint(IHintContext.Key key) {
        return (E)this.hintStack.getHint(key);
    }

    public boolean hasHint(IHintContext.Key key) {
        return this.hintStack.getHint(key) != null;
    }

    public void setHint(IHintContext.Key key, Object value) {
        if (!this.getThread().currentThreadAccess()) {
            throw new IllegalStateException("illegal thread access, expected " + this.getThread().getThread() + ", was in " + Thread.currentThread());
        }
        this.getWriteableHintContext().setHint(key, value);
    }

    public void removeHint(IHintContext.Key key) {
        if (!this.getThread().currentThreadAccess()) {
            throw new IllegalStateException("illegal thread access");
        }
        this.getWriteableHintContext().removeHint(key);
    }

    public void syncExec(Runnable r) {
        ThreadUtils.syncExec((IThreadWorkQueue)this.getThread(), (Runnable)r);
    }

    public void asyncExec(Runnable r) {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.getThread(), (Runnable)r);
    }

    public void createLocalHintContext(int priority) {
        this.localHintCtx = new HintContext();
    }

    public void setHintAsync(final IHintContext.Key key, final Object value) {
        assert (this.context != null);
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractCanvasParticipant.this.isRemoved()) {
                    return;
                }
                if (AbstractCanvasParticipant.this.localHintCtx != null) {
                    AbstractCanvasParticipant.this.localHintCtx.setHint(key, value);
                } else {
                    AbstractCanvasParticipant.this.context.getDefaultHintContext().setHint(key, value);
                }
            }
        });
    }

    public ICanvasContext getContext() {
        return this.context;
    }

    public IThreadWorkQueue getThread() {
        return this.thread;
    }

    public void assertDependencies() {
        assert (this.depsSatisfied);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkDependencies() {
        IContextListener<ICanvasParticipant> iContextListener = this.ctxListener;
        synchronized (iContextListener) {
            try {
                DependencyReflection.ReferenceDefinition[] referenceDefinitionArray = this.refDefs;
                int n = this.refDefs.length;
                int n2 = 0;
                while (n2 < n) {
                    DependencyReflection.ReferenceDefinition rd = referenceDefinitionArray[n2];
                    if (rd.dependency) {
                        Field f = rd.field;
                        Object o = f.get(this);
                        if (o == null) {
                            this.missingDependencies.add(f);
                            return false;
                        }
                        this.missingDependencies.remove(f);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    public void setDirty() {
        ICanvasContext ctx = this.getContext();
        if (ctx == null) {
            return;
        }
        IContentContext cctx = ctx.getContentContext();
        if (cctx == null) {
            return;
        }
        cctx.setDirty();
    }
}

