/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.common.matrix;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.databoard.binding.mutable.Variant;

public class VariantMatrix {
    public int rows;
    public int columns;
    public Variant[] data;

    public VariantMatrix() {
    }

    public VariantMatrix(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.data = new Variant[rows * columns];
    }

    public int getColumnCount() {
        return this.columns;
    }

    public int getRowCount() {
        return this.rows;
    }

    public Variant get(int row, int column) {
        return this.data[column * this.rows + row];
    }

    public void setColumn(int column, Collection<Variant> objects) {
        int index = this.rows * column;
        for (Variant o : objects) {
            this.data[index++] = o;
        }
    }

    public void set(int row, int column, Variant object) {
        this.data[this.rows * column + row] = object;
    }

    public Collection<Variant> getColumn(int column) {
        ArrayList<Variant> result = new ArrayList<Variant>();
        int i = 0;
        while (i < this.rows) {
            result.add(this.data[this.rows * column + i]);
            ++i;
        }
        return result;
    }

    public Collection<Variant> getRow(int row) {
        ArrayList<Variant> result = new ArrayList<Variant>();
        int i = 0;
        while (i < this.columns) {
            result.add(this.data[row + this.columns * i]);
            ++i;
        }
        return result;
    }
}

