/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Set;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.elements.EditorStateManager;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.ExportableWidget;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.nodes.SVGNodeAssignment;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.utils.NodeUtil;

@ExportableWidget.RasterOutputWidget
public class SVGNode
extends org.simantics.scenegraph.g2d.nodes.SVGNode {
    private static final long serialVersionUID = 4735066193941274186L;
    transient EditorStateManager esm = null;
    transient boolean parametersProcessed = false;

    public void cleanup() {
        if (this.esm != null) {
            this.removeEventHandler((IEventHandler)this);
        }
        super.cleanup();
    }

    public void render(Graphics2D g2d) {
        if (!this.parametersProcessed) {
            SingleElementNode sne = this.getSingleElementNode();
            Boolean enableEditing = (Boolean)sne.getParameter("enableEditing");
            if (enableEditing != null && enableEditing.booleanValue()) {
                this.esm = new EditorStateManager(this);
                this.addEventHandler((IEventHandler)this);
            }
            this.parametersProcessed = true;
        }
        super.render(g2d);
    }

    protected int dynamicHash() {
        return this.esm != null ? this.esm.currentHash() : 0;
    }

    protected boolean applyAssignments(SVGDiagram diagram, List<SVGNodeAssignment> assignments) throws SVGException {
        boolean changed = super.applyAssignments(diagram, assignments);
        if (this.esm != null && !this.esm.applyEditMode(diagram)) {
            diagram.updateTime(0.0);
        }
        return changed;
    }

    private boolean isSelected(IG2DNode node) {
        Set elems;
        ICanvasContext ctx = DiagramNodeUtil.getCanvasContext((IG2DNode)this);
        IElement ie = DiagramNodeUtil.getElement(ctx, node);
        if (ie == null) {
            return false;
        }
        Selection sel = (Selection)ctx.getAtMostOneItemOfClass(Selection.class);
        return sel != null && (elems = sel.getSelection(0)).size() == 1 && elems.contains(ie);
    }

    private boolean isSelected() {
        SingleElementNode sne = this.getSingleElementNode();
        if (this.isSelected((IG2DNode)sne)) {
            return true;
        }
        ParentNode n = sne.getParent();
        while (n != null) {
            if (this.isSelected((IG2DNode)n)) {
                return true;
            }
            n = n.getParent();
        }
        return false;
    }

    protected boolean mouseClicked(MouseEvent.MouseClickEvent e) {
        if (this.esm != null) {
            if (this.esm.isEditMode()) {
                this.esm.applyEdit();
                this.esm.deactivateEdit();
                return true;
            }
            if (this.isSelected() && this.esm.tryToStartEditMode(this.diagramCache, e)) {
                return true;
            }
        }
        return super.mouseClicked(e);
    }

    SingleElementNode getSingleElementNode() {
        ICanvasContext ctx = DiagramNodeUtil.getCanvasContext((IG2DNode)this);
        if (ctx == null) {
            return null;
        }
        return (SingleElementNode)NodeUtil.getNearestParentOfType((INode)this, SingleElementNode.class);
    }

    protected boolean keyPressed(KeyEvent.KeyPressedEvent e) {
        if (this.esm != null && this.esm.keyPressed(e)) {
            return true;
        }
        return super.keyPressed(e);
    }

    protected boolean handleCommand(CommandEvent e) {
        if (this.esm != null && !this.esm.isEditMode() && "org.eclipse.ui.edit.rename".equals(e.command.id) && this.isSelected() && this.esm.tryToStartEditMode(this.diagramCache)) {
            return true;
        }
        return super.handleCommand(e);
    }

    public int getEventMask() {
        return EventTypes.KeyPressedMask | EventTypes.MouseClickMask | EventTypes.CommandMask;
    }
}

