/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads.ua;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.simantics.utils.threads.ua.AbstractState;
import org.simantics.utils.threads.ua.StateListener;
import org.simantics.utils.threads.ua.WorkMonitor;
import org.simantics.utils.threads.ua.WorkState;

public class Work<T>
extends AbstractState<WorkState, RuntimeException>
implements WorkMonitor,
RunnableFuture<T> {
    Callable<T> c;
    Runnable r;
    Thread thread;
    transient Exception error;
    transient T result;
    boolean canceled;

    public static Work<Object> createMonitor(Runnable r) {
        return new Work<Object>(r);
    }

    public static Work<Object> createMonitor(Runnable r, StateListener<WorkState> listener) {
        Work<Object> result = new Work<Object>(r);
        result.addStateListener(listener);
        return result;
    }

    public static <T> Work<T> createMonitor(Callable<T> r) {
        return new Work<T>(r);
    }

    public static <T> Work<T> createMonitor(Callable<T> r, StateListener<WorkState> listener) {
        Work<T> result = new Work<T>(r);
        result.addStateListener(listener);
        return result;
    }

    public Work(Runnable runnable) {
        super(WorkState.Ready);
        if (runnable == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.r = runnable;
    }

    public Work(Runnable runnable, T result) {
        super(WorkState.Ready);
        if (runnable == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.r = runnable;
        this.result = result;
    }

    public Work(Callable<T> c) {
        super(WorkState.Ready);
        if (c == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.c = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        WorkState s = (WorkState)((Object)this.getState());
        if (s != WorkState.Ready) {
            throw new RuntimeException("Work must be restarted before it can be reused");
        }
        this.thread = Thread.currentThread();
        if (this.setState(WorkState.Working, null, WorkState.READY_STATE) == WorkState.Working) {
            return;
        }
        try {
            if (this.r != null) {
                this.r.run();
            } else {
                this.result = this.c.call();
            }
        }
        catch (Exception e) {
            this.error = e;
            this.setState(WorkState.Error);
        }
        WorkState newState = WorkState.Complete;
        Work work = this;
        synchronized (work) {
            s = (WorkState)((Object)this.getState());
            if (s == WorkState.Interrupting) {
                Thread.interrupted();
                newState = WorkState.Interrupted;
            }
        }
        this.setState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Work work = this;
        synchronized (work) {
            WorkState s = (WorkState)((Object)this.getState());
            if (s != WorkState.Ready && s != WorkState.Working) {
                return false;
            }
        }
        if (this.attemptSetState(WorkState.READY_STATE, WorkState.Canceled) == WorkState.Ready) {
            this.canceled |= true;
            return true;
        }
        if (mayInterruptIfRunning && this.attemptSetState(WorkState.WORKING_STATE, WorkState.Interrupting) == WorkState.Working) {
            this.canceled |= true;
            this.thread.interrupt();
            return true;
        }
        return false;
    }

    @Override
    protected boolean isStateTransitionAllowed(WorkState oldState, WorkState newState) {
        return true;
    }

    @Override
    public void setError(RuntimeException error) {
        super.setError(error);
    }

    public synchronized void restart() {
        WorkState s = (WorkState)((Object)this.getState());
        if (s == WorkState.Ready) {
            return;
        }
        if (!s.isFinalState()) {
            throw new RuntimeException("Work cannot be restarted until the previous run has completed.");
        }
        this.setState(WorkState.Ready);
    }

    @Override
    public Runnable getRunnable() {
        return this.r;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        WorkState s = this.waitForState(WorkState.FINAL_STATES);
        if (s == WorkState.Canceled) {
            throw new CancellationException();
        }
        if (s == WorkState.Interrupted) {
            throw new InterruptedException();
        }
        if (s == WorkState.Error) {
            throw new ExecutionException(this.error);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        WorkState s = this.waitForState(WorkState.FINAL_STATES, timeout, unit);
        if (s == WorkState.Canceled) {
            throw new CancellationException();
        }
        if (s == WorkState.Interrupted) {
            throw new InterruptedException();
        }
        if (s == WorkState.Error) {
            throw new ExecutionException(this.error);
        }
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return WorkState.FINAL_STATES.contains(this.getState());
    }
}

