/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.ui;

import java.lang.ref.WeakReference;
import org.simantics.scenegraph.INode;

class NodeProxy {
    WeakReference<INode> ref;
    String id;

    NodeProxy(INode n) {
        this(n, null);
    }

    NodeProxy(INode n, String id) {
        this.ref = new WeakReference<INode>(n);
        this.id = id;
    }

    INode getNode() {
        return (INode)this.ref.get();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        INode n = this.getNode();
        if (this.id != null) {
            sb.append("[");
            sb.append(this.id);
            sb.append("] ");
        }
        if (n == null) {
            sb.append("(collected)");
        } else {
            sb.append(n.getSimpleClassName());
        }
        return sb.toString();
    }

    public String getTypeName() {
        INode n = this.getNode();
        return n == null ? "-" : n.getSimpleClassName();
    }

    public String getInternalId() {
        INode n = this.getNode();
        if (n == null) {
            return "-";
        }
        return n.getId().toString();
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        INode node = this.getNode();
        result = 31 * result + (node == null ? 0 : node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeProxy other = (NodeProxy)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        INode node = this.getNode();
        INode otherNode = other.getNode();
        if (node == null || otherNode == null) {
            return false;
        }
        return node.equals(otherNode);
    }
}

