/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.sensitivity;

import java.util.HashMap;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ITrackedColorProvider;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.jfreechart.chart.properties.DoubleValidator;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.SysdynBasicColorProvider;
import org.simantics.sysdyn.ui.properties.widgets.factories.DoublePropertyFactory;
import org.simantics.sysdyn.ui.properties.widgets.factories.DoublePropertyModifier;
import org.simantics.sysdyn.ui.properties.widgets.sensitivity.IDistributionProperties;
import org.simantics.sysdyn.ui.properties.widgets.sensitivity.SensitivityDistributionKeys;

public class UniformDistributionProperties
implements IDistributionProperties {
    private TrackedText minValue;
    private TrackedText maxValue;
    private Resource resource;

    public UniformDistributionProperties(Resource resource) {
        this.resource = resource;
    }

    @Override
    public Composite createContent(Composite parent, ISessionContext context, WidgetSupport support) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label label = new Label(composite, 0);
        label.setText("Min value");
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.minValue = new TrackedText(composite, support, 2048);
        this.minValue.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/UniformDistribution/minValue"));
        this.minValue.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/UniformDistribution/minValue"));
        this.minValue.setInputValidator((IInputValidator)new DoubleValidator(false));
        this.minValue.setColorProvider((ITrackedColorProvider)new SysdynBasicColorProvider((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), (Control)this.minValue.getWidget())));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.minValue.getWidget());
        label = new Label(composite, 0);
        label.setText("Max value");
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.maxValue = new TrackedText(composite, support, 2048);
        this.maxValue.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Sysdyn-1.1/UniformDistribution/maxValue"));
        this.maxValue.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/UniformDistribution/maxValue"));
        this.maxValue.setInputValidator((IInputValidator)new DoubleValidator(false));
        this.maxValue.setColorProvider((ITrackedColorProvider)new SysdynBasicColorProvider((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), (Control)this.maxValue.getWidget())));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.maxValue.getWidget());
        return composite;
    }

    @Override
    public void getCachedValues(HashMap<String, String> cahcedValues) {
        cahcedValues.put(SensitivityDistributionKeys.MIN, this.minValue.getText());
        cahcedValues.put(SensitivityDistributionKeys.MAX, this.maxValue.getText());
    }

    @Override
    public void applyCache(WriteGraph graph, HashMap<String, String> cachedValues) throws DatabaseException {
        String max;
        if (this.resource == null) {
            return;
        }
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        String min = cachedValues.get(SensitivityDistributionKeys.MIN);
        if (min != null) {
            try {
                Double d = Double.parseDouble(min);
                graph.claimLiteral(this.resource, SR.UniformDistribution_minValue, (Object)d, (Binding)Bindings.DOUBLE);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((max = cachedValues.get(SensitivityDistributionKeys.MAX)) != null) {
            try {
                Double d = Double.parseDouble(max);
                graph.claimLiteral(this.resource, SR.UniformDistribution_maxValue, (Object)d, (Binding)Bindings.DOUBLE);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

