/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.menu;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynPlaybackExperiment;
import org.simantics.ui.SimanticsUI;

public class PlaybackSliderContribution
extends ToolBarContributionItem {
    Runnable timeListener;
    SysdynPlaybackExperiment spe;
    Slider s;
    Double startTime;
    Double endTime;
    boolean ignoreChange = false;

    public void fill(ToolBar parent, int index) {
        if (parent != null) {
            IExperimentManager manager = (IExperimentManager)SimanticsUI.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
            IExperiment experiment = manager.getActiveExperiment();
            if (experiment == null || !(experiment instanceof SysdynPlaybackExperiment)) {
                return;
            }
            this.spe = (SysdynPlaybackExperiment)experiment;
            Double[] numbers = new Double[2];
            try {
                numbers = (Double[])SimanticsUI.getSession().syncRequest((Read)new Read<Double[]>(){

                    public Double[] perform(ReadGraph graph) throws DatabaseException {
                        Double[] numbers = new Double[2];
                        Resource model = PlaybackSliderContribution.this.spe.getModel();
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        numbers[0] = (Double)graph.getRelatedValue(model, sr.SysdynModel_startTime);
                        numbers[1] = (Double)graph.getRelatedValue(model, sr.SysdynModel_stopTime);
                        return numbers;
                    }
                });
            }
            catch (DatabaseException e1) {
                e1.printStackTrace();
            }
            ToolItem ti = new ToolItem(parent, 2);
            Composite composite = new Composite((Composite)parent, 0);
            GridLayoutFactory.fillDefaults().margins(3, -1).numColumns(2).applyTo(composite);
            GridDataFactory.fillDefaults().applyTo((Control)composite);
            this.s = new Slider(composite, 0);
            this.s.setMinimum(0);
            this.s.setMaximum(100);
            this.s.setIncrement(1);
            this.s.setPageIncrement(1);
            this.s.setThumb(1);
            final Label label = new Label(composite, 0);
            GridDataFactory.fillDefaults().hint(70, -1).applyTo((Control)label);
            label.setText("0.0");
            ti.setWidth(270);
            ti.setControl((Control)composite);
            this.startTime = numbers[0];
            this.endTime = numbers[1];
            final DecimalFormat format = new DecimalFormat();
            format.setMinimumFractionDigits(0);
            format.setMaximumFractionDigits(2);
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            symbols.setGroupingSeparator(' ');
            format.setDecimalFormatSymbols(symbols);
            this.s.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Slider s = (Slider)e.widget;
                    Double time = (double)s.getSelection() / 99.0 * (PlaybackSliderContribution.this.endTime - PlaybackSliderContribution.this.startTime) + PlaybackSliderContribution.this.startTime;
                    PlaybackSliderContribution.this.spe.setTimeAndContinue(time.doubleValue());
                    if (!label.isDisposed()) {
                        label.setText(format.format(time));
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (this.timeListener != null) {
                this.spe.removeTimeListener(this.timeListener);
            }
            this.timeListener = new Runnable(){

                @Override
                public void run() {
                    PlaybackSliderContribution.this.s.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).PlaybackSliderContribution.this.startTime.equals((this).PlaybackSliderContribution.this.spe.getStartTime()) || !(this).PlaybackSliderContribution.this.endTime.equals((this).PlaybackSliderContribution.this.spe.getEndTime())) {
                                (this).PlaybackSliderContribution.this.startTime = (this).PlaybackSliderContribution.this.spe.getStartTime();
                                (this).PlaybackSliderContribution.this.endTime = (this).PlaybackSliderContribution.this.spe.getEndTime();
                            }
                            int value = (int)Math.round(((this).PlaybackSliderContribution.this.spe.getTime() - (this).PlaybackSliderContribution.this.startTime) / ((this).PlaybackSliderContribution.this.endTime - (this).PlaybackSliderContribution.this.startTime) * 99.0);
                            (this).PlaybackSliderContribution.this.s.setSelection(value);
                            label.setText(format.format((this).PlaybackSliderContribution.this.spe.getTime()));
                        }
                    });
                }
            };
            this.spe.addTimeListener(this.timeListener);
        }
    }

    public void dispose() {
        if (this.timeListener != null && this.spe != null) {
            this.spe.removeTimeListener(this.timeListener);
            this.timeListener = null;
        }
        super.dispose();
    }
}

