/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.geom.AffineTransform;
import java.util.function.Consumer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.elements.ITextListener;
import org.simantics.diagram.elements.TextElementNoBounds;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.participant.SGFocusParticipant;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.chassis.SWTChassis;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.utils.Alignment;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.elements.SysdynTextNode;
import org.simantics.sysdyn.ui.utils.SysdynWorkbenchUtils;
import org.simantics.sysdyn.ui.utils.VariableNameValidator;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.hints.IHintContext;

public class SysdynTextElementNoBounds
extends TextElementNoBounds {
    private static final long serialVersionUID = -148784588840819612L;
    public static final IHintContext.Key ELEMENT_INITIALIZED = new IHintContext.KeyOf(Boolean.class, "SYSDYN_TEXT_ELEMENT_INITIALIZED");

    public SysdynTextElementNoBounds() {
        super(0.0, 0.0, Alignment.LEADING, 0.0);
    }

    public SysdynTextElementNoBounds(double originX, double originY, Alignment horizontalAlignment) {
        super(originX, originY, horizontalAlignment, 0.0);
    }

    public SysdynTextElementNoBounds(double originX, double originY, Alignment horizontalAlignment, double borderWidth) {
        super(originX, originY, horizontalAlignment, borderWidth);
    }

    public SysdynTextElementNoBounds(double originX, double originY, Alignment horizontalAlignment, double borderWidth, double paddingX, double paddingY, boolean editable) {
        super(originX, originY, horizontalAlignment, borderWidth, paddingX, paddingY, editable);
    }

    protected <T extends SysdynTextNode> Consumer<T> getCallback(final IElement e, G2DParentNode parent, Class<T> nodeClass) {
        return new Consumer<T>(){

            @Override
            public void accept(T node) {
                node.setTextListener(new ITextListener(){
                    String textBeforeEdit;
                    Resource component;

                    public void textChanged() {
                        TextNode node = (TextNode)e.getHint(SG_NODE);
                        if (!new VariableNameValidator().isValid(this.component, node.getText(), false)) {
                            node.setColor(Color.RED);
                        } else {
                            node.setColor(ElementUtils.getTextColor((IElement)e, (Color)Color.BLACK));
                        }
                    }

                    public void textEditingStarted() {
                        TextNode node = (TextNode)e.getHint(SG_NODE);
                        if (node == null) {
                            return;
                        }
                        this.textBeforeEdit = node.getText();
                        if (this.component != null) {
                            return;
                        }
                        Object o = e.getHint(ElementHints.KEY_OBJECT);
                        if (o != null && o instanceof Resource) {
                            final Resource element = (Resource)o;
                            SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

                                public void run(ReadGraph graph) throws DatabaseException {
                                    component = graph.getPossibleObject(element, ModelingResources.getInstance((ReadGraph)graph).ElementToComponent);
                                }
                            });
                        }
                    }

                    public void textEditingCancelled() {
                        TextNode node = (TextNode)e.getHint(SG_NODE);
                        if (node != null) {
                            if (new VariableNameValidator().isValid(this.component, node.getText(), false)) {
                                node.setColor(ElementUtils.getTextColor((IElement)e, (Color)Color.BLACK));
                            }
                            SysdynTextElementNoBounds.this.endEdit(node);
                        }
                    }

                    public void textEditingEnded() {
                        TextNode node = (TextNode)e.getHint(SG_NODE);
                        if (node == null) {
                            return;
                        }
                        String text = node.getText();
                        if (!new VariableNameValidator().isValid(this.component, text, false)) {
                            text = this.textBeforeEdit;
                            node.setEditMode(false);
                            node.setText(text);
                            if (new VariableNameValidator().isValid(this.component, text, false)) {
                                node.setColor(ElementUtils.getTextColor((IElement)e, (Color)Color.BLACK));
                            }
                        } else {
                            Object o = e.getHint(ElementHints.KEY_OBJECT);
                            final String textAfterEdit = text;
                            if (o != null && o instanceof Resource) {
                                SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                                    public void perform(WriteGraph graph) throws DatabaseException {
                                        Resource configuration = graph.getPossibleObject(component, Layer0.getInstance((ReadGraph)graph).PartOf);
                                        new VariableNameValidator().renameInAllEquations(graph, configuration, textBeforeEdit, textAfterEdit);
                                    }
                                });
                            }
                        }
                        ElementUtils.setText((IElement)e, (String)text);
                        IDiagram diagram = ElementUtils.getDiagram((IElement)e);
                        DiagramUtils.synchronizeHintsToBackend((IDiagram)diagram, (IElement[])new IElement[]{e});
                        SysdynTextElementNoBounds.this.endEdit(node);
                    }
                });
            }
        };
    }

    public static void unflipText(IElement e) {
        Object o = e.getHint(SG_NODE);
        if (o instanceof TextNode) {
            TextNode text = (TextNode)o;
            AffineTransform at = new AffineTransform(text.getTransform());
            double x = at.getTranslateX();
            double y = at.getTranslateY();
            at.setToRotation(0.0);
            at.setToTranslation(x, y);
            at.setTransform(at);
        }
    }

    protected void activateEdit(final IElement e) {
        final SysdynTextNode node = (SysdynTextNode)e.getHint(SG_NODE);
        if (node == null) {
            return;
        }
        final ICanvasContext ctx = DiagramNodeUtil.getCanvasContext((IG2DNode)node);
        if (ctx == null) {
            return;
        }
        if (!node.isEditMode()) {
            IWorkbenchPage page = SysdynWorkbenchUtils.getActivePageOfEditor();
            final DiagramEditor editor = (DiagramEditor)page.getActiveEditor();
            final ICanvasContext editorCtx = (ICanvasContext)editor.getViewer().getAdapter(ICanvasContext.class);
            editor.getViewer().getComposite().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Control c = editor.getViewer().getComposite().getDisplay().getFocusControl();
                    if (c == null || "BasicSymbols".equals(c.getParent().getToolTipText())) {
                        editorCtx.add((Object)new SGFocusParticipant((SWTChassis)editor.getViewer().getComposite(), "org.simantics.modeling.ui.diagramming"){

                            public void focusGained(FocusEvent event) {
                                editor.getViewer().getComposite().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (Boolean.TRUE.equals(node.setEditMode(true))) {
                                            node.activateEdit(0, e, ctx, true);
                                            node.repaint();
                                        }
                                    }
                                });
                                ctx.remove((Object)this);
                            }

                            public void focusLost(FocusEvent e2) {
                            }
                        });
                        editor.setFocus();
                    } else if (Boolean.TRUE.equals(node.setEditMode(true))) {
                        node.activateEdit(0, e, ctx, true);
                        node.repaint();
                    }
                }
            });
        }
    }

    protected TextNode getOrCreateTextNode(IElement e, G2DParentNode parent) {
        return (TextNode)ElementUtils.getOrCreateNode((IElement)e, (ParentNode)parent, (IHintContext.Key)SG_NODE, (String)"text", SysdynTextNode.class, this.getCallback(e, parent, SysdynTextNode.class));
    }

    public void init(final IElement e, G2DParentNode parent) {
        super.init(e, parent);
        Boolean isInitialized = (Boolean)e.getHint(ELEMENT_INITIALIZED);
        Object o = e.getHint(ElementHints.KEY_OBJECT);
        if (o instanceof Resource && !Boolean.TRUE.equals(isInitialized)) {
            final Resource element = (Resource)o;
            try {
                SimanticsUI.getSession().syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                        ModelingResources MR = ModelingResources.getInstance((ReadGraph)graph);
                        Resource component = graph.getPossibleObject(element, MR.ElementToComponent);
                        if (component == null) {
                            return;
                        }
                        Resource r = graph.getPossibleObject(component, SR.IndependentVariable_isUninitialized);
                        if (r == null) {
                            return;
                        }
                        if (!graph.isInstanceOf(r, SR.Loop)) {
                            SysdynTextElementNoBounds.this.activateEdit(e);
                        }
                        graph.deny(component, SR.IndependentVariable_isUninitialized, r);
                    }
                });
            }
            catch (DatabaseException e1) {
                e1.printStackTrace();
            }
            e.setHint(ELEMENT_INITIALIZED, (Object)Boolean.TRUE);
        }
        SysdynTextElementNoBounds.unflipText(e);
    }

    public boolean handleMouseEvent(IElement e, ICanvasContext ctx, MouseEvent me) {
        return super.handleMouseEvent(e, ctx, me);
    }
}

