/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.SingleObjectWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.jfreechart.chart.ChartUtils;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.sysdyn.ui.browser.nodes.AbstractChartNode;
import org.simantics.ui.SimanticsUI;

public class LineChartNode
extends AbstractChartNode<Resource> {
    public LineChartNode(Resource data) {
        super(data);
    }

    @Override
    protected void addVariableToChart(final Variable variable) {
        SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                Resource plot = (Resource)graph.syncRequest((Read)new SingleObjectWithType((Resource)LineChartNode.this.data, l0.ConsistsOf, jfree.Plot));
                if (plot == null) {
                    return;
                }
                Resource rangeAxis = null;
                Resource dataset = null;
                Resource rangeAxisList = graph.getPossibleObject(plot, jfree.Plot_rangeAxisList);
                if (rangeAxisList == null || ListUtils.toList((ReadGraph)graph, (Resource)rangeAxisList).isEmpty()) {
                    rangeAxis = ChartUtils.createNumberRangeAxis((WriteGraph)graph, (Resource)plot);
                    Resource domainAxis = graph.getPossibleObject(plot, jfree.Plot_domainAxis);
                    dataset = ChartUtils.createXYDataset((WriteGraph)graph, (Resource)plot, (Resource)domainAxis, (Resource)rangeAxis);
                } else {
                    rangeAxis = (Resource)ListUtils.toList((ReadGraph)graph, (Resource)rangeAxisList).get(0);
                    dataset = graph.getPossibleObject(rangeAxis, jfree.Dataset_mapToRangeAxis_Inverse);
                }
                String rvi = Variables.getRVI((ReadGraph)graph, (Variable)variable);
                ChartUtils.createSeries((WriteGraph)graph, (Resource)dataset, (String)rvi);
            }
        });
    }
}

