/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.contributions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.graph.contributor.viewpoint.ViewpointContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.browser.nodes.BookNode;
import org.simantics.sysdyn.ui.browser.nodes.ConfigurationNode;
import org.simantics.sysdyn.ui.browser.nodes.EnumerationNode;
import org.simantics.sysdyn.ui.browser.nodes.InputNode;
import org.simantics.sysdyn.ui.browser.nodes.ModuleNode;
import org.simantics.sysdyn.ui.browser.nodes.VariableNode;
import org.simantics.utils.strings.AlphanumComparator;

public class Configuration
extends ViewpointContributor<ConfigurationNode<Resource>> {
    public Collection<?> getContribution(ReadGraph graph, ConfigurationNode<Resource> configuration) throws DatabaseException {
        Resource represents;
        Variable v;
        ArrayList<AbstractNode> result = new ArrayList<AbstractNode>();
        Variable variable = configuration.getVariable();
        if (variable == null) {
            return result;
        }
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        TreeMap<String, Variable> variables = new TreeMap<String, Variable>((Comparator<String>)AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
        TreeMap<String, Variable> inputs = new TreeMap<String, Variable>((Comparator<String>)AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
        TreeMap<String, Variable> modules = new TreeMap<String, Variable>((Comparator<String>)AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
        TreeMap<String, Variable> enumerations = new TreeMap<String, Variable>((Comparator<String>)AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
        for (Variable child : variable.getChildren(graph)) {
            Resource represents2 = child.getRepresents(graph);
            if (graph.isInstanceOf(represents2, sr.IndependentVariable)) {
                variables.put(child.getName(graph), child);
                continue;
            }
            if (graph.isInstanceOf(represents2, sr.Input)) {
                inputs.put(child.getName(graph), child);
                continue;
            }
            if (graph.isInstanceOf(represents2, sr.Module)) {
                modules.put(child.getName(graph), child);
                continue;
            }
            if (!graph.isInstanceOf(represents2, sr.Enumeration)) continue;
            enumerations.put(child.getName(graph), child);
        }
        for (String s : variables.keySet()) {
            v = (Variable)variables.get(s);
            represents = v.getRepresents(graph);
            result.add(new VariableNode(v, represents));
        }
        for (String s : inputs.keySet()) {
            v = (Variable)inputs.get(s);
            represents = v.getRepresents(graph);
            result.add(new InputNode(v, represents));
        }
        for (String s : modules.keySet()) {
            v = (Variable)modules.get(s);
            represents = v.getRepresents(graph);
            result.add(new ModuleNode(v, represents));
        }
        for (String s : enumerations.keySet()) {
            v = (Variable)enumerations.get(s);
            represents = v.getRepresents(graph);
            result.add(new EnumerationNode(v, represents));
        }
        for (Resource r : (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)configuration.data, Layer0.getInstance((ReadGraph)graph).ConsistsOf, SpreadsheetResource.getInstance((ReadGraph)graph).Book))) {
            result.add(new BookNode(r));
        }
        return result;
    }

    public String getViewpointId() {
        return "Standard";
    }
}

