/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.SelectionDataResolver;
import org.simantics.browsing.ui.platform.GraphExplorerView;
import org.simantics.browsing.ui.swt.AdaptableHintContext;
import org.simantics.browsing.ui.swt.ContextMenuInitializer;
import org.simantics.browsing.ui.swt.DefaultSelectionDataResolver;
import org.simantics.browsing.ui.swt.GraphExplorerFactory;
import org.simantics.browsing.ui.swt.IContextMenuInitializer;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.ReadInterface;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.browser.BrowserSelection;
import org.simantics.sysdyn.ui.browser.nodes.VariableNode;
import org.simantics.sysdyn.ui.properties.SysdynPropertyPage;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.datastructures.BinaryFunction;
import org.simantics.utils.datastructures.hints.IHintContext;

public class SysdynBrowser
extends GraphExplorerView {
    private static final Set<String> browseContexts = new HashSet<String>(Arrays.asList("http://www.simantics.org/Sysdyn-1.1/Browser", "http://www.semantum.fi/SimupediaWorkbench-1.0/OldBrowser", "http://www.simantics.org/Image-1.1/Browser"));
    private BinaryFunction<Object[], GraphExplorer, Object[]> selectionTransformation = new BinaryFunction<Object[], GraphExplorer, Object[]>(){

        public Object[] call(GraphExplorer explorer, Object[] objects) {
            Object[] result = new Object[objects.length];
            int i = 0;
            while (i < objects.length) {
                SelectionElement context;
                NodeContext ctx = (NodeContext)objects[i];
                VariableNode vn = (VariableNode)((Object)ctx.getAdapter(VariableNode.class));
                if (vn != null && vn.getVariable() != null) {
                    context = new SelectionElement(vn.getVariable(), (Resource)vn.data, SelectionHints.KEY_MAIN, SelectionHints.KEY_SELECTION_PROPERTY);
                    context.setHint(SelectionHints.KEY_MAIN, new BrowserSelection(objects[i], vn));
                    context.setHint(SelectionHints.KEY_SELECTION_PROPERTY, vn.getVariable());
                } else {
                    Object resource = ctx.getAdapter(Resource.class);
                    context = new SelectionElement(null, resource == null ? null : (Resource)resource, SelectionHints.KEY_MAIN);
                    context.setHint(SelectionHints.KEY_MAIN, objects[i]);
                }
                result[i] = context;
                ++i;
            }
            return result;
        }

        class SelectionElement
        extends AdaptableHintContext {
            private Variable variable;
            private Resource resource;

            public SelectionElement(Variable variable, Resource resource, IHintContext.Key ... keys) {
                super(keys);
                this.variable = variable;
                this.resource = resource;
            }

            public <T> T getContent(WorkbenchSelectionContentType<T> contentType) {
                if (contentType instanceof AnyResource) {
                    return (T)this.resource;
                }
                if (contentType instanceof AnyVariable) {
                    AnyVariable type;
                    block6: {
                        type = (AnyVariable)contentType;
                        if (this.variable != null) {
                            return (T)this.variable;
                        }
                        if (this.resource != null) break block6;
                        return null;
                    }
                    try {
                        return (T)type.processor.sync((ReadInterface)new ResourceRead<Variable>(this.resource){

                            public Variable perform(ReadGraph graph) throws DatabaseException {
                                return Variables.getPossibleVariable((ReadGraph)graph, (Resource)this.resource);
                            }
                        });
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                }
                return null;
            }
        }
    };

    protected GraphExplorer createExplorerControl(Composite parent) {
        return GraphExplorerFactory.getInstance().selectionDataResolver((SelectionDataResolver)new DefaultSelectionDataResolver()).selectionTransformation(this.selectionTransformation).create(parent, this.getStyle());
    }

    protected IContextMenuInitializer getContextMenuInitializer() {
        return new ContextMenuInitializer("#SysdynBrowserPopup");
    }

    protected Set<String> getBrowseContexts() {
        return browseContexts;
    }

    protected void createControls(Composite parent) {
        Activator.initializeResourceManager(parent.getDisplay());
        super.createControls(parent);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertyPage.class) {
            return new SysdynPropertyPage(this.getSite(), Collections.singleton("http://www.simantics.org/Sysdyn-1.1/Browser"));
        }
        return super.getAdapter(adapter);
    }

    public SysdynBrowser() {
        this.hideComparatorSelector = true;
        this.hideViewpointSelector = true;
    }
}

