/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.layer0.variable.AbstractChildVariable;
import org.simantics.db.layer0.variable.ConstantPropertyVariable;
import org.simantics.db.layer0.variable.ConstantPropertyVariableBuilder;
import org.simantics.db.layer0.variable.Variable;

public class ConstantChildVariable
extends AbstractChildVariable {
    final Variable parent;
    final String name;
    final Map<String, ConstantPropertyVariable> properties;

    public ConstantChildVariable(Variable parent, String name) {
        this.parent = parent;
        this.name = name;
        this.properties = new THashMap();
    }

    public ConstantChildVariable(Variable parent, String name, Collection<ConstantPropertyVariableBuilder> propertyBuilders) {
        this(parent, name);
        for (ConstantPropertyVariableBuilder b : propertyBuilders) {
            ConstantPropertyVariable property = b.build(this);
            this.properties.put(b.getName(), property);
        }
    }

    public ConstantChildVariable(Variable parent, String name, ConstantPropertyVariableBuilder ... propertyBuilders) {
        this(parent, name);
        ConstantPropertyVariableBuilder[] constantPropertyVariableBuilderArray = propertyBuilders;
        int n = propertyBuilders.length;
        int n2 = 0;
        while (n2 < n) {
            ConstantPropertyVariableBuilder b = constantPropertyVariableBuilderArray[n2];
            ConstantPropertyVariable property = b.build(this);
            this.properties.put(b.getName(), property);
            ++n2;
        }
    }

    public ConstantChildVariable(Variable parent, String name, String[] propertyNames, Binding[] bindings, Object ... values) {
        this(parent, name);
        this.buildProperties(this, propertyNames, bindings, values, this.properties);
    }

    private Map<String, Variable> buildProperties(Variable parent, String[] propertyNames, Binding[] bindings, Object ... values) {
        assert (parent != null);
        assert (propertyNames.length == bindings.length);
        assert (propertyNames.length == values.length);
        HashMap<String, Variable> result = new HashMap<String, Variable>();
        int i = 0;
        while (i < values.length) {
            String property = propertyNames[i];
            result.put(property, new ConstantPropertyVariable(parent, property, values[i], bindings[i]));
            ++i;
        }
        return result;
    }

    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph, Map<String, Variable> properties) throws DatabaseException {
        if (properties == null) {
            properties = new HashMap<String, Variable>(this.properties.size());
        }
        properties.putAll(this.properties);
        return properties;
    }

    @Override
    public Variable getPossibleDomainProperty(ReadGraph graph, String name) throws DatabaseException {
        return this.properties.get(name);
    }

    @Override
    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        return this.name;
    }

    @Override
    public String getLabel(ReadGraph graph) throws DatabaseException {
        Variable variable = this.getPossibleDomainProperty(graph, "HasLabel");
        if (variable != null) {
            return (String)variable.getValue(graph);
        }
        return this.name;
    }

    @Override
    public Resource getRepresents(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Resource getType(ReadGraph graph) throws DatabaseException {
        return (Resource)this.getDomainProperty(graph, "Type").getValue(graph);
    }

    @Override
    public Resource getPossibleType(ReadGraph graph) throws DatabaseException {
        Variable v = this.getPossibleDomainProperty(graph, "Type");
        return v != null ? (Resource)v.getPossibleValue(graph) : null;
    }

    @Override
    public Resource getType(ReadGraph graph, Resource baseType) throws DatabaseException {
        Resource type = this.getPossibleType(graph, baseType);
        if (type != null) {
            return type;
        }
        throw new NoSingleResultException("variable " + this.getPossibleURI(graph) + " has no type");
    }

    @Override
    public Resource getPossibleType(ReadGraph graph, Resource baseType) throws DatabaseException {
        Variable typev = this.getPossibleDomainProperty(graph, "Type");
        if (typev == null) {
            return null;
        }
        Resource type = (Resource)typev.getValue(graph);
        return type != null && graph.isInheritedFrom(type, baseType) ? type : null;
    }

    @Override
    public Collection<Variable> getProperties(ReadGraph graph, String classification) throws DatabaseException {
        ArrayList<ConstantPropertyVariable> result = null;
        ConstantPropertyVariable singleResult = null;
        for (ConstantPropertyVariable property : this.properties.values()) {
            if (!property.getClassifications(graph).contains(classification)) continue;
            if (result == null && singleResult == null) {
                singleResult = property;
                continue;
            }
            if (result == null && singleResult != null) {
                result = new ArrayList<ConstantPropertyVariable>();
                result.add(singleResult);
                result.add(property);
                continue;
            }
            result.add(property);
        }
        if (result != null) {
            return result;
        }
        if (singleResult != null) {
            return Collections.singletonList(singleResult);
        }
        return Collections.emptyList();
    }
}

