/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.query;

import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.query.AddChartItem;
import org.simantics.charts.query.ChartAndSubscriptionItemData;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.subscription.FindSubscription;
import org.simantics.modeling.subscription.NewSubscription;
import org.simantics.trend.configuration.Scale;
import org.simantics.trend.impl.Plot;

public class ChartAndSubscriptionItemWriteAction
extends WriteRequest {
    ChartAndSubscriptionItemData data;
    Resource chartItem;

    public ChartAndSubscriptionItemWriteAction(Resource chartItem, ChartAndSubscriptionItemData data) {
        this.data = data;
        this.chartItem = chartItem;
    }

    public void perform(WriteGraph g) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        ChartResource CHART = ChartResource.getInstance((ReadGraph)g);
        Resource chart = g.getPossibleObject(this.chartItem, L0.PartOf);
        Resource model = (Resource)g.syncRequest((Read)new PossibleModel(chart));
        Resource subscriptionItem = g.getPossibleObject(this.chartItem, CHART.Chart_Item_HasSubscriptionItem);
        Resource subscription = subscriptionItem == null ? null : g.getPossibleObject(subscriptionItem, L0.PartOf);
        g.claim(this.chartItem, CHART.Chart_Item_Renderer, this.data.binaryMode ? CHART.Renderer_Binary : CHART.Renderer_Analog);
        Resource rdm = AddChartItem.getDrawmode((ReadGraph)g, this.data.drawmode);
        if (rdm != null) {
            g.deny(this.chartItem, CHART.Chart_Item_DrawMode);
            g.claim(this.chartItem, CHART.Chart_Item_DrawMode, rdm);
        }
        if (this.data.scale != null) {
            Resource r = this.data.scale instanceof Scale.Auto ? CHART.ScaleMode_AutoScale : CHART.ScaleMode_ManualScale;
            g.deny(this.chartItem, CHART.Chart_Item_ScaleMode);
            g.claim(this.chartItem, CHART.Chart_Item_ScaleMode, r);
        }
        if (this.data.min != null) {
            g.claimLiteral(this.chartItem, CHART.Chart_Item_ScaleMode_Min, (Object)this.data.min, (Binding)Bindings.DOUBLE);
        }
        if (this.data.max != null) {
            g.claimLiteral(this.chartItem, CHART.Chart_Item_ScaleMode_Max, (Object)this.data.max, (Binding)Bindings.DOUBLE);
        }
        g.denyValue(this.chartItem, G2D.HasStrokeWidth);
        if (this.data.strokeWidth != null && this.data.strokeWidth.floatValue() != Plot.TREND_LINE_STROKE.getLineWidth()) {
            g.claimLiteral(this.chartItem, G2D.HasStrokeWidth, L0.Float, (Object)this.data.strokeWidth, (Binding)Bindings.FLOAT);
        }
        g.denyValue(this.chartItem, G2D.HasColor);
        if (this.data.color != null) {
            g.claimLiteral(this.chartItem, G2D.HasColor, G2D.Color, (Object)this.data.color, (Binding)Bindings.FLOAT_ARRAY);
        }
        if (this.data.hasSubscriptionItem && subscriptionItem != null) {
            String subscriptionLabel = (String)g.getPossibleRelatedValue(subscription, L0.HasLabel);
            if (this.data.subscription != null && !this.data.subscription.equals(subscriptionLabel)) {
                Resource newSubscription = (Resource)g.sync((ReadInterface)new FindSubscription(model, null, this.data.subscription));
                if (newSubscription == null) {
                    NewSubscription ns = new NewSubscription(model, this.data.subscription);
                    g.sync((WriteInterface)ns);
                    newSubscription = ns.subscription;
                }
                g.deny(subscription, L0.ConsistsOf, subscriptionItem);
                g.claim(newSubscription, L0.ConsistsOf, subscriptionItem);
            }
            if (this.data.label != null) {
                g.claimLiteral(subscriptionItem, L0.HasLabel, (Object)this.data.label, (Binding)Bindings.STRING);
            }
            if (this.data.mutableCollectionSettings) {
                if (this.data.interval != null) {
                    g.claimLiteral(subscriptionItem, MOD.Subscription_Item_SamplingInterval, (Object)this.data.interval, (Binding)Bindings.DOUBLE);
                }
                if (this.data.deadband != null) {
                    g.claimLiteral(subscriptionItem, MOD.Subscription_Item_Deadband, (Object)this.data.deadband, (Binding)Bindings.DOUBLE);
                }
            }
            if (this.data.unit != null) {
                g.claimLiteral(subscriptionItem, MOD.Subscription_Item_Unit, (Object)this.data.unit, (Binding)Bindings.STRING);
            }
            if (this.data.gain != null) {
                g.claimLiteral(subscriptionItem, MOD.Subscription_Item_Gain, (Object)this.data.gain, (Binding)Bindings.DOUBLE);
            }
            if (this.data.bias != null) {
                g.claimLiteral(subscriptionItem, MOD.Subscription_Item_Bias, (Object)this.data.bias, (Binding)Bindings.DOUBLE);
            }
        }
    }
}

