/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.WriteBindings;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.ClusterBuilder2;
import org.simantics.db.service.ClusterBuilderFactory;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.XSupport;
import org.simantics.graph.db.CoreInitialization;
import org.simantics.graph.db.IImportAdvisor2;
import org.simantics.graph.db.MissingDependencyException;
import org.simantics.graph.db.TGStatusMonitor;
import org.simantics.graph.db.TransferableGraphImporter;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraphUtils;
import org.simantics.graph.utils.TGResourceUtil;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingTransferableGraphImportProcess
implements TransferableGraphImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingTransferableGraphImportProcess.class);
    Resource indexRoot;
    TransferableGraphSource tg;
    VirtualGraph vg;
    IImportAdvisor2 advisor;
    TGStatusMonitor monitor;
    ClusterBuilder2 builder;
    final TGResourceUtil resourceUtil = new TGResourceUtil();
    int[] handles;
    Map<String, Integer> allMissingExternals = new HashMap<String, Integer>();
    Set<String> missingExternals = new HashSet<String>();
    Map<String, Resource> resolvedParents = new HashMap<String, Resource>();
    TIntObjectHashMap<Resource> existingInternalMap = new TIntObjectHashMap();
    int resourceCount;
    Identity[] identities;
    TreeMap<String, Variant> extensions;
    Resource RootLibrary;
    Resource String;
    Resource ExternalEntity;
    Resource Library;
    Resource InstanceOf;
    Resource ConsistsOf;
    Resource PartOf;
    Resource HasName;
    Resource NameOf;

    public StreamingTransferableGraphImportProcess(Session session, VirtualGraph vg, TransferableGraphSource tg, IImportAdvisor2 advisor) {
        this(session, vg, tg, advisor, null);
    }

    public StreamingTransferableGraphImportProcess(Session session, VirtualGraph vg, TransferableGraphSource tg, IImportAdvisor2 advisor, TGStatusMonitor monitor) {
        this.tg = tg;
        this.vg = vg;
        this.advisor = advisor;
        this.monitor = monitor;
    }

    private int updatePercentage(int percentage, int done, int total) {
        int current;
        if (this.monitor != null && (done & 0x3F) == 0 && (current = 100 * done / total) > percentage) {
            percentage = current;
            this.monitor.status(percentage);
        }
        return percentage;
    }

    public void readIdentities(ReadGraph g) throws Exception {
        this.extensions = this.tg.getExtensions();
        this.resourceCount = this.tg.getResourceCount();
        this.identities = new Identity[this.tg.getIdentityCount()];
        this.tg.forIdentities(g, new TransferableGraphSource.TransferableGraphSourceProcedure<Identity>(){
            int counter = 0;

            @Override
            public void execute(Identity value) throws Exception {
                StreamingTransferableGraphImportProcess.this.identities[this.counter++] = value;
            }
        });
    }

    public void findBuiltins(WriteOnlyGraph g) throws DatabaseException {
        this.RootLibrary = g.getBuiltin("http:/");
        this.String = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "String");
        this.Library = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "Library");
        this.InstanceOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "InstanceOf");
        this.ConsistsOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "ConsistsOf");
        this.PartOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "PartOf");
        this.HasName = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "HasName");
        this.NameOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "NameOf");
        this.ExternalEntity = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "ExternalEntity");
    }

    public void findBuiltins(ReadGraph g) throws DatabaseException {
        this.RootLibrary = g.getBuiltin("http:/");
        this.String = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "String");
        this.Library = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "Library");
        this.InstanceOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "InstanceOf");
        this.ConsistsOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "ConsistsOf");
        this.PartOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "PartOf");
        this.HasName = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "HasName");
        this.NameOf = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "NameOf");
        this.ExternalEntity = g.getBuiltin(java.lang.String.valueOf(CoreInitialization.LAYER0) + "ExternalEntity");
    }

    void addMissing(int handleIndex, String external) {
        this.allMissingExternals.put(external, handleIndex);
        HashSet<String> removals = new HashSet<String>();
        for (String ext : this.missingExternals) {
            if (!ext.startsWith(java.lang.String.valueOf(external) + "/")) continue;
            return;
        }
        for (String ext : this.missingExternals) {
            if (!external.startsWith(java.lang.String.valueOf(ext) + "/")) continue;
            removals.add(ext);
        }
        this.missingExternals.removeAll(removals);
        this.missingExternals.add(external);
    }

    void prepare(ReadGraph graph) throws Exception {
        Resource target = this.advisor.getTarget();
        if (target != null) {
            this.indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(target));
        }
        this.findBuiltins(graph);
        this.readIdentities(graph);
        ClusterBuilderFactory factory = (ClusterBuilderFactory)graph.getService(ClusterBuilderFactory.class);
        ClusterBuilder2 builder = factory.create(this.vg, false);
        this.handles = new int[this.resourceCount];
        TIntObjectMap identityMap = TransferableGraphUtils.mapIdentities((Identity[])this.identities);
        Identity[] identityArray = this.identities;
        int n = this.identities.length;
        int n2 = 0;
        while (n2 < n) {
            External def;
            Identity identity = identityArray[n2];
            IdentityDefinition definition = identity.definition;
            if (definition instanceof External) {
                def = (External)definition;
                if (def.parent == -1) {
                    this.handles[identity.resource] = builder.handle(this.RootLibrary);
                } else if ("@inverse".equals(def.name)) {
                    int child;
                    int parent = this.handles[def.parent];
                    this.handles[identity.resource] = child = builder.handle(graph.getInverse(builder.resource(parent)));
                } else {
                    Resource parent;
                    int handle = this.handles[def.parent];
                    Resource resource = parent = handle != 0 ? builder.resource(handle) : null;
                    if (parent != null) {
                        this.resolvedParents.put(graph.getURI(parent), parent);
                        Map childMap = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(parent), (AsyncProcedure)TransientCacheAsyncListener.instance());
                        Resource child = (Resource)childMap.get(def.name);
                        if (child == null) {
                            this.addMissing(identity.resource, java.lang.String.valueOf(graph.getURI(parent)) + "/" + URIStringUtils.escape((String)def.name));
                        } else {
                            this.handles[identity.resource] = builder.handle(child);
                        }
                    } else {
                        this.addMissing(identity.resource, java.lang.String.valueOf(TransferableGraphUtils.getURI((int)this.resourceCount, (TIntObjectMap)identityMap, (int)def.parent)) + "/" + URIStringUtils.escape((String)def.name));
                    }
                }
            } else if (definition instanceof Internal) {
                String uri = TransferableGraphUtils.getURI((int)this.resourceCount, (TIntObjectMap)identityMap, (int)identity.resource);
                Resource existing = graph.getPossibleResource(uri);
                if (existing != null) {
                    this.existingInternalMap.put(identity.resource, (Object)existing);
                }
            } else if (definition instanceof Root) {
                Root root = (Root)definition;
                if (root.name.equals("")) {
                    this.handles[identity.resource] = builder.handle(this.RootLibrary);
                } else {
                    Resource existing = this.advisor.analyzeRoot(graph, root);
                    if (existing != null) {
                        this.handles[identity.resource] = builder.handle(existing);
                    }
                }
            } else if (definition instanceof Optional) {
                def = (External)definition;
                Resource parent = builder.resource(this.handles[def.parent]);
                if (parent != null) {
                    this.handles[identity.resource] = builder.handle((Resource)((Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(parent))).get(def.name));
                }
            }
            ++n2;
        }
        if (!this.missingExternals.isEmpty() && this.failOnMissingEntities()) {
            throw new MissingDependencyException(this);
        }
    }

    private boolean failOnMissingEntities() {
        return "true".equalsIgnoreCase(System.getProperty("org.simantics.tg.import.failOnMissingEntities", "false"));
    }

    @Override
    public Resource createChild(WriteOnlyGraph graph, Resource parent, Resource child, String name) throws DatabaseException {
        if (child == null) {
            child = graph.newResource();
        }
        Resource nameResource = graph.newResource();
        graph.claim(nameResource, this.InstanceOf, null, this.String);
        graph.claimValue(nameResource, (Object)name, WriteBindings.STRING);
        graph.claim(child, this.HasName, this.NameOf, nameResource);
        return child;
    }

    int[] getClustering() {
        Variant v = this.extensions.get("clustering");
        if (v == null) {
            return null;
        }
        try {
            return (int[])v.getValue((Binding)Bindings.INT_ARRAY);
        }
        catch (AdaptException e) {
            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    int[] getClusterSets() {
        Variant v = this.extensions.get("clusterSets");
        if (v == null) {
            return null;
        }
        try {
            return (int[])v.getValue((Binding)Bindings.INT_ARRAY);
        }
        catch (AdaptException e) {
            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    boolean needTranslation(Datatype type) {
        return this.resourceUtil.mayHaveResource(type);
    }

    void findClusterSet(WriteOnlyGraph graph, Resource rootLibrary, int[] clustering, int[] clusterSets, long[] clusters, int id) throws DatabaseException {
        ClusteringSupport support = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        if (id == -1 || id == -2) {
            return;
        }
        Resource indexRootClusterSetResource = rootLibrary;
        if (this.indexRoot != null && support.isClusterSet(this.indexRoot)) {
            indexRootClusterSetResource = this.indexRoot;
        } else {
            graph.setClusterSet4NewResource(rootLibrary);
            graph.flushCluster();
        }
        int indexRootCsHandle = this.builder.handle(indexRootClusterSetResource);
        int pos = 0;
        int index = 0;
        while (index < clustering.length) {
            if (id < (pos += clustering[index])) {
                int cs = clusterSets[index];
                if (this.handles[id] == 0) {
                    int csHandle = 0;
                    if (cs == -1) {
                        csHandle = this.builder.handle(rootLibrary);
                    } else if (cs == -2) {
                        if (this.indexRoot == null) {
                            throw new DatabaseException("No index root was available in TG import.");
                        }
                        csHandle = indexRootCsHandle;
                    } else {
                        this.findClusterSet(graph, rootLibrary, clustering, clusterSets, clusters, cs);
                        csHandle = this.handles[cs];
                    }
                    if (clusters[index] != 0L) {
                        this.builder.selectCluster(clusters[index]);
                    } else if (cs >= 0) {
                        this.builder.newCluster(csHandle);
                    }
                    this.handles[id] = this.builder.newResource(csHandle);
                    clusters[index] = support.getCluster(this.builder.resource(this.handles[id]));
                    this.builder.createClusterSet(this.handles[id]);
                }
                return;
            }
            ++index;
        }
    }

    void createMissing(WriteOnlyGraph graph) throws Exception {
        if (this.allMissingExternals.isEmpty()) {
            return;
        }
        XSupport xs = (XSupport)graph.getService(XSupport.class);
        Pair serviceMode = xs.getServiceMode();
        xs.setServiceMode(true, false);
        try {
            ArrayList<String> missing = new ArrayList<String>(this.allMissingExternals.keySet());
            Collections.sort(missing);
            for (String uri : missing) {
                Resource parent;
                String[] parts = URIStringUtils.splitURI((String)uri);
                if (parts[0].equals("http://")) {
                    parts[0] = "http:/";
                }
                if ((parent = this.resolvedParents.get(parts[0])) == null) {
                    throw new IllegalStateException("Missing URI: " + uri);
                }
                Resource childResource = graph.newResource();
                graph.claim(childResource, this.InstanceOf, null, this.ExternalEntity);
                Resource nameResource = graph.newResource();
                graph.claim(nameResource, this.InstanceOf, null, this.String);
                graph.claimValue(nameResource, (Object)URIStringUtils.unescape((String)parts[1]), WriteBindings.STRING);
                graph.claim(childResource, this.HasName, this.NameOf, nameResource);
                graph.claim(parent, this.ConsistsOf, this.PartOf, childResource);
                this.resolvedParents.put(uri, childResource);
                this.handles[this.allMissingExternals.get((Object)uri).intValue()] = this.builder.handle(childResource);
            }
        }
        finally {
            xs.setServiceMode(((Boolean)serviceMode.first).booleanValue(), ((Boolean)serviceMode.second).booleanValue());
        }
    }

    void write(final WriteOnlyGraph graph) throws Exception {
        int c;
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        ClusterBuilderFactory factory = (ClusterBuilderFactory)graph.getService(ClusterBuilderFactory.class);
        if (this.advisor instanceof IImportAdvisor2) {
            boolean allowImmutable = this.advisor.allowImmutableModifications();
            this.builder = factory.create(this.vg, allowImmutable);
        } else {
            this.builder = factory.create(this.vg, false);
        }
        this.createMissing(graph);
        final int[] handles = this.handles;
        int[] clustering = this.getClustering();
        if (clustering != null) {
            int c2;
            int j;
            int[] clusterSets = this.getClusterSets();
            if (clusterSets != null) {
                assert (clustering.length == clusterSets.length);
                long[] clusters = new long[clustering.length];
                int i = 0;
                while (i < clusterSets.length) {
                    this.findClusterSet(graph, graph.getRootLibrary(), clustering, clusterSets, clusters, clusterSets[i]);
                    ++i;
                }
                i = 0;
                j = 0;
                while (j < clustering.length) {
                    c2 = clustering[j];
                    int s = clusterSets[j];
                    int setHandle = 0;
                    if (s == -1) {
                        setHandle = this.builder.handle(graph.getRootLibrary());
                    } else if (s == -2) {
                        if (this.indexRoot == null) {
                            throw new DatabaseException("No index root was available in TG import.");
                        }
                        setHandle = this.builder.handle(this.indexRoot);
                    } else {
                        setHandle = handles[s];
                    }
                    if (clusters[j] != 0L) {
                        this.builder.selectCluster(clusters[j]);
                    } else if (s >= 0) {
                        this.builder.newCluster(setHandle);
                    }
                    int r = 0;
                    while (r < c2) {
                        if (handles[i] == 0) {
                            handles[i] = this.builder.newResource();
                        }
                        ++r;
                        ++i;
                    }
                    ++j;
                }
                while (i < handles.length) {
                    if (handles[i] == 0) {
                        handles[i] = this.builder.newResource();
                    }
                    ++i;
                }
            } else {
                int i = 0;
                int[] s = clustering;
                c2 = clustering.length;
                j = 0;
                while (j < c2) {
                    c = s[j];
                    this.builder.newCluster();
                    int r = 0;
                    while (r < c) {
                        if (handles[i] == 0) {
                            handles[i] = this.builder.newResource();
                        }
                        ++r;
                        ++i;
                    }
                    ++j;
                }
                while (i < handles.length) {
                    if (handles[i] == 0) {
                        handles[i] = this.builder.newResource();
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < handles.length) {
                if (handles[i] == 0) {
                    handles[i] = this.builder.newResource();
                }
                ++i;
            }
        }
        Identity[] j = this.identities;
        c = this.identities.length;
        int i = 0;
        while (i < c) {
            Identity identity = j[i];
            IdentityDefinition definition = identity.definition;
            if (!(definition instanceof External)) {
                if (definition instanceof Internal) {
                    Internal def = (Internal)definition;
                    Resource external = (Resource)this.existingInternalMap.get(identity.resource);
                    handles[identity.resource] = external != null ? this.builder.handle(external) : (handles[identity.resource] != 0 ? this.builder.handle(this.advisor.createChild(graph, this, this.builder.resource(handles[def.parent]), this.builder.resource(handles[identity.resource]), def.name)) : this.builder.handle(this.advisor.createChild(graph, this, this.builder.resource(handles[def.parent]), null, def.name)));
                } else if (definition instanceof Root) {
                    Root root = (Root)definition;
                    handles[identity.resource] = handles[identity.resource] != 0 ? this.builder.handle(this.advisor.createRoot(graph, root, this.builder.resource(handles[identity.resource]))) : this.builder.handle(this.advisor.createRoot(graph, root, null));
                } else if (definition instanceof Optional) {
                    Optional def = (Optional)definition;
                    if (handles[identity.resource] != 0) {
                        Resource child = this.advisor.createChild(graph, this, this.builder.resource(handles[def.parent]), this.builder.resource(handles[identity.resource]), def.name);
                        graph.claim(child, this.InstanceOf, null, this.Library);
                        handles[identity.resource] = this.builder.handle(child);
                    } else {
                        Resource child = this.advisor.createChild(graph, this, this.builder.resource(handles[def.parent]), null, def.name);
                        graph.claim(child, this.InstanceOf, null, this.Library);
                        handles[identity.resource] = this.builder.handle(child);
                    }
                }
            }
            ++i;
        }
        final int[] done = new int[1];
        final int[] percentage = new int[1];
        final int statementCount = this.tg.getStatementCount();
        this.tg.forStatements(null, new TransferableGraphSource.TransferableGraphSourceProcedure<int[]>(){

            @Override
            public void execute(int[] value) throws Exception {
                int sub = value[0];
                int pred = value[1];
                int inv = value[2];
                int obj = value[3];
                int subject = handles[sub];
                int predicate = handles[pred];
                int object = handles[obj];
                StreamingTransferableGraphImportProcess.this.builder.addStatement(graph, subject, predicate, object);
                if (inv >= 0) {
                    int inverse = handles[inv];
                    StreamingTransferableGraphImportProcess.this.builder.addStatement(graph, object, inverse, subject);
                }
                int n = done[0];
                done[0] = n + 1;
                percentage[0] = StreamingTransferableGraphImportProcess.this.updatePercentage(percentage[0], n, statementCount * 2);
            }
        });
        int valueCount = this.tg.getValueCount();
        done[0] = 0;
        class ValueProcedure
        extends InputStream
        implements TransferableGraphSource.TransferableGraphSourceValueProcedure {
            private TGResourceUtil util = new TGResourceUtil();
            private DataInput source;
            private final /* synthetic */ int[] val$handles;
            private final /* synthetic */ int[] val$percentage;
            private final /* synthetic */ int val$valueCount;
            private final /* synthetic */ int[] val$done;
            private final /* synthetic */ SerialisationSupport val$ss;

            ValueProcedure(int[] nArray, int[] nArray2, int n, int[] nArray3, SerialisationSupport serialisationSupport) {
                this.val$handles = nArray;
                this.val$percentage = nArray2;
                this.val$valueCount = n;
                this.val$done = nArray3;
                this.val$ss = serialisationSupport;
            }

            @Override
            public void execute(int _resource, Datatype type, DataInput stream) throws Exception {
                this.source = stream;
                int resource = _resource & Integer.MAX_VALUE;
                Binding binding = Bindings.getBinding((Datatype)type);
                Serializer s = Bindings.getSerializer((Binding)binding);
                StreamingTransferableGraphImportProcess.this.builder.beginValue(this.val$handles[resource]);
                if (this.util.mayHaveResource(type)) {
                    byte[] bytes;
                    Object value = s.deserialize(stream);
                    this.util.adaptValue(binding, value, new TGResourceUtil.LongAdapter(){

                        public long adapt(long in) {
                            try {
                                return val$ss.getRandomAccessId(val$handles[(int)in]);
                            }
                            catch (DatabaseException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                    });
                    byte[] byArray = bytes = s.serialize(value);
                    int n = bytes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int b = byArray[n2];
                        int val = b;
                        if (val < 0) {
                            val += 256;
                        }
                        StreamingTransferableGraphImportProcess.this.builder.appendValue(val);
                        ++n2;
                    }
                } else {
                    s.skip((InputStream)this);
                }
                StreamingTransferableGraphImportProcess.this.builder.endValue();
                this.work();
            }

            @Override
            public int read() throws IOException {
                int value = this.source.readUnsignedByte();
                try {
                    StreamingTransferableGraphImportProcess.this.builder.appendValue(value);
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to write value into database", (Throwable)e);
                }
                return value;
            }

            @Override
            public void rawCopy(int resource, int length, DataInput input) throws Exception {
                StreamingTransferableGraphImportProcess.this.builder.beginValue(this.val$handles[resource]);
                int i = 0;
                while (i < length) {
                    StreamingTransferableGraphImportProcess.this.builder.appendValue(input.readUnsignedByte());
                    ++i;
                }
                StreamingTransferableGraphImportProcess.this.builder.endValue();
                this.work();
            }

            private void work() {
                int n = this.val$done[0];
                this.val$done[0] = n + 1;
                this.val$percentage[0] = StreamingTransferableGraphImportProcess.this.updatePercentage(this.val$percentage[0], this.val$valueCount + n, this.val$valueCount * 2);
            }
        }
        this.tg.forValues2(null, new ValueProcedure(handles, percentage, valueCount, done, ss));
        for (Resource r : this.existingInternalMap.valueCollection()) {
            graph.deny(r, this.InstanceOf, null, this.ExternalEntity, null);
        }
    }

    @Override
    public long[] getResourceIds(SerialisationSupport serializer) throws DatabaseException {
        int count = this.handles.length;
        long[] resourceIds = new long[count];
        int i = 0;
        while (i < count) {
            resourceIds[i] = serializer.getRandomAccessId(this.handles[i]);
            ++i;
        }
        return resourceIds;
    }
}

