/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal.contributions.search;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.workbench.internal.Activator;

class ActiveModelsListener
extends DisposableListener<Collection<Resource>> {
    private Runnable callback;
    private Set<Resource> previouslyActive;

    public ActiveModelsListener(Runnable callback) {
        if (callback == null) {
            throw new NullPointerException("null callback");
        }
        this.callback = callback;
    }

    public void execute(Collection<Resource> models) {
        HashSet<Resource> set = new HashSet<Resource>(models);
        Set<Resource> previous = this.previouslyActive;
        if (previous != null && !previous.equals(set)) {
            this.callback.run();
        }
        this.previouslyActive = set;
    }

    public void exception(Throwable t) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.workbench", t.getLocalizedMessage(), t));
    }

    public void dispose() {
        super.dispose();
        this.previouslyActive = null;
    }
}

