/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.parsing.exceptions.SCLSyntaxErrorException;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserImpl;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.internal.types.HashConsing;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.internal.types.effects.EffectIdMap;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TForAll;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TUnion;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.KindUnificationException;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.exceptions.Problem;
import org.simantics.scl.compiler.types.exceptions.SCLTypeParseException;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.ITypeEnvironment;
import org.simantics.scl.compiler.types.util.MultiApply;
import org.simantics.scl.compiler.types.util.MultiFunction;
import org.simantics.scl.compiler.types.util.TMultiApply;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;
import org.simantics.scl.compiler.types.util.Typed;

public class Types {
    private static final HashConsing<TCon> conCache = new HashConsing<TCon>(){

        @Override
        protected boolean equals(TCon a, TCon b) {
            return a.name.equals(b.name) && a.module.equals(b.module);
        }

        @Override
        protected int hashCode(TCon obj) {
            return obj.module.hashCode() * 31 + obj.name.hashCode();
        }
    };
    public static final String BUILTIN = "Builtin";
    public static final TCon BOOLEAN = Types.con("Builtin", "Boolean");
    public static final TCon BYTE = Types.con("Builtin", "Byte");
    public static final TCon CHARACTER = Types.con("Builtin", "Character");
    public static final TCon SHORT = Types.con("Builtin", "Short");
    public static final TCon INTEGER = Types.con("Builtin", "Integer");
    public static final TCon LONG = Types.con("Builtin", "Long");
    public static final TCon FLOAT = Types.con("Builtin", "Float");
    public static final TCon DOUBLE = Types.con("Builtin", "Double");
    public static final TCon BOOLEAN_ARRAY = Types.con("Builtin", "BooleanArray");
    public static final TCon BYTE_ARRAY = Types.con("Builtin", "ByteArray");
    public static final TCon CHARACTER_ARRAY = Types.con("Builtin", "CharacterArray");
    public static final TCon SHORT_ARRAY = Types.con("Builtin", "ShortArray");
    public static final TCon INTEGER_ARRAY = Types.con("Builtin", "IntegerArray");
    public static final TCon LONG_ARRAY = Types.con("Builtin", "LongArray");
    public static final TCon FLOAT_ARRAY = Types.con("Builtin", "FloatArray");
    public static final TCon DOUBLE_ARRAY = Types.con("Builtin", "DoubleArray");
    public static final TCon STRING = Types.con("Builtin", "String");
    public static final TCon ARROW = Types.con("Builtin", "->");
    public static final TCon LIST = Types.con("Builtin", "[]");
    public static final TCon VECTOR = Types.con("Builtin", "Vector");
    public static final TCon MVECTOR = Types.con("Builtin", "MVector");
    public static final TCon MAYBE = Types.con("Builtin", "Maybe");
    public static final TCon ARRAY = Types.con("Builtin", "Array");
    public static final TCon UNIT = Types.con("Builtin", "()");
    public static final TCon PUNIT = Types.con("Builtin", "@");
    public static final TCon TYPE_PROXY = Types.con("Builtin", "TypeProxy");
    public static final TCon TYPEABLE = Types.con("Builtin", "Typeable");
    public static final TCon SERIALIZABLE = Types.con("Builtin", "Serializable");
    public static final TCon VEC_COMP = Types.con("Builtin", "VecComp");
    public static final TCon BINDING = Types.con("Builtin", "Binding");
    public static final TCon TYPE = Types.con("Builtin", "Type");
    public static final TCon DYNAMIC = Types.con("Prelude", "Dynamic");
    public static final TCon VARIANT = Types.con("Builtin", "Variant");
    public static final TCon ADDITIVE = Types.con("Prelude", "Additive");
    public static final TCon MONAD = Types.con("Prelude", "Monad");
    public static final TCon MONAD_E = Types.con("Prelude", "MonadE");
    public static final TCon INTEGRAL = Types.con("Prelude", "Integral");
    public static final TCon RING = Types.con("Prelude", "Ring");
    public static final TCon ORDERED_RING = Types.con("Prelude", "OrderedRing");
    public static final TCon REAL = Types.con("Prelude", "Real");
    public static final TCon SHOW = Types.con("Prelude", "Show");
    public static final TCon ORD = Types.con("Prelude", "Ord");
    public static final TCon IO = Types.con("Serialization", "IO");
    public static final Type REF = Types.con("Prelude", "Ref");
    public static final TCon RANDOM = Types.con("Random", "Random");
    public static final TCon READ_GRAPH = Types.con("Simantics/DB", "ReadGraph");
    public static final TCon WRITE_GRAPH = Types.con("Simantics/DB", "WriteGraph");
    public static final Type RESOURCE = Types.con("Simantics/DB", "Resource");
    public static final TUnion NO_EFFECTS = new TUnion(new Type[0]);
    public static final TCon PROC = Types.con("Builtin", "Proc");
    public static final TCon EXCEPTION = Types.con("Builtin", "Exception");
    public static final TCon BRANCH_POINT = Types.con("Builtin", "BranchPoint");
    public static final TCon CHRContext = Types.con("Builtin", "CHRContext");
    private static volatile TCon[] tupleCache;
    private static final ITypeEnvironment DUMMY_TYPE_ENVIRONMENT;

    static {
        TCon[] tConArray = new TCon[2];
        tConArray[0] = UNIT;
        tupleCache = tConArray;
        DUMMY_TYPE_ENVIRONMENT = new ITypeEnvironment(){

            @Override
            public TCon resolve(String namespace, String name) {
                if (namespace == null) {
                    return Types.con(Types.BUILTIN, name);
                }
                return Types.con(namespace, name);
            }
        };
    }

    public static boolean isPrimitive(Type type) {
        return type == BOOLEAN || type == BYTE || type == CHARACTER || type == SHORT || type == INTEGER || type == LONG || type == FLOAT || type == DOUBLE || type == STRING;
    }

    public static boolean isNumeric(Type type) {
        return type == BYTE || type == SHORT || type == INTEGER || type == LONG || type == FLOAT || type == DOUBLE;
    }

    public static TApply apply(Type function, Type parameter) {
        return new TApply(function, parameter);
    }

    public static Type apply(Type function, Type ... parameters) {
        Type[] typeArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            function = Types.apply(function, parameter);
            ++n2;
        }
        return function;
    }

    public static Type canonical(Type type) {
        if (type instanceof TMetaVar) {
            TMetaVar metaVar = (TMetaVar)type;
            type = metaVar.ref;
            if (type == null) {
                return metaVar;
            }
            metaVar.ref = Types.canonical(type);
            return metaVar.ref;
        }
        return type;
    }

    public static Type closure(Type type, ArrayList<TVar> vars) {
        int i = vars.size() - 1;
        while (i >= 0) {
            type = Types.forAll(vars.get(i), type);
            --i;
        }
        return type;
    }

    public static Type closure(Type type, TVar[] vars) {
        int i = vars.length - 1;
        while (i >= 0) {
            type = Types.forAll(vars[i], type);
            --i;
        }
        return type;
    }

    public static Type closure(Type type) {
        return Types.closure(type, Types.freeVars(type));
    }

    public static TCon con(String module, String name) {
        return conCache.canonical(new TCon(module, name));
    }

    public static Type[] concat(Type[] a, Type[] b) {
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        Type[] result = new Type[a.length + b.length];
        int i = 0;
        while (i < a.length) {
            result[i] = a[i];
            ++i;
        }
        i = 0;
        while (i < b.length) {
            result[i + a.length] = b[i];
            ++i;
        }
        return result;
    }

    public static TVar[] concat(TVar[] a, TVar[] b) {
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        TVar[] result = new TVar[a.length + b.length];
        int i = 0;
        while (i < a.length) {
            result[i] = a[i];
            ++i;
        }
        i = 0;
        while (i < b.length) {
            result[i + a.length] = b[i];
            ++i;
        }
        return result;
    }

    public static boolean equals(TApply a, TApply b) {
        return Types.equals(a.parameter, b.parameter) && Types.equals(a.function, b.function);
    }

    public static boolean equals(TFun a, TFun b) {
        return Types.equals(a.domain, b.domain) && Types.equals(a.effect, b.effect) && Types.equals(a.range, b.range);
    }

    public static boolean subsumes(TFun a, TFun b) {
        return Types.subsumes(b.domain, a.domain) && Types.subsumesEffect(a.effect, b.effect) && Types.subsumes(a.range, b.range);
    }

    public static boolean subsumesEffect(Type a, Type b) {
        int idB;
        EffectIdMap idMap = new EffectIdMap();
        ArrayList<TMetaVar> mVars = new ArrayList<TMetaVar>(0);
        int idA = idMap.toId(a, mVars);
        return (idA & (idB = idMap.toId(b, mVars))) == idA;
    }

    public static boolean equalsEffect(Type a, Type b) {
        int idB;
        EffectIdMap idMap = new EffectIdMap();
        ArrayList<TMetaVar> mVars = new ArrayList<TMetaVar>(0);
        int idA = idMap.toId(a, mVars);
        return idA == (idB = idMap.toId(b, mVars));
    }

    public static boolean equals(TForAll a, TForAll b) {
        Kind aKind = a.var.getKind();
        if (!Kinds.equalsCanonical(aKind, b.var.getKind())) {
            return false;
        }
        TVar newVar = Types.var(aKind);
        return Types.equals(a.type.replace(a.var, newVar), b.type.replace(b.var, newVar));
    }

    public static boolean equals(TPred a, TPred b) {
        if (a.typeClass != b.typeClass || a.parameters.length != b.parameters.length) {
            return false;
        }
        Type[] aParameters = a.parameters;
        Type[] bParameters = b.parameters;
        int i = 0;
        while (i < aParameters.length) {
            if (!Types.equals(aParameters[i], bParameters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(TUnion a, TUnion b) {
        if (a.effects.length != b.effects.length) {
            return false;
        }
        int i = 0;
        while (i < a.effects.length) {
            if (!Types.equals(a.effects[i], b.effects[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(Type a, Type b) {
        Class<?> cb;
        if ((a = Types.canonical(a)) == (b = Types.canonical(b))) {
            return true;
        }
        Class<?> ca = a.getClass();
        if (ca != (cb = b.getClass())) {
            return false;
        }
        if (ca == TApply.class) {
            return Types.equals((TApply)a, (TApply)b);
        }
        if (ca == TFun.class) {
            return Types.equals((TFun)a, (TFun)b);
        }
        if (ca == TForAll.class) {
            return Types.equals((TForAll)a, (TForAll)b);
        }
        if (ca == TPred.class) {
            return Types.equals((TPred)a, (TPred)b);
        }
        if (ca == TUnion.class) {
            return Types.equals((TUnion)a, (TUnion)b);
        }
        return false;
    }

    public static boolean subsumes(Type a, Type b) {
        Class<?> cb;
        if ((a = Types.canonical(a)) == (b = Types.canonical(b))) {
            return true;
        }
        Class<?> ca = a.getClass();
        if (ca != (cb = b.getClass())) {
            return false;
        }
        if (ca == TApply.class) {
            return Types.equals((TApply)a, (TApply)b);
        }
        if (ca == TFun.class) {
            return Types.subsumes((TFun)a, (TFun)b);
        }
        if (ca == TForAll.class) {
            TForAll aForAll = (TForAll)a;
            TForAll bForAll = (TForAll)b;
            TVar newVar = Types.var(aForAll.var.getKind());
            return Types.subsumes(aForAll.type.replace(aForAll.var, newVar), bForAll.type.replace(bForAll.var, newVar));
        }
        if (ca == TPred.class) {
            return Types.equals((TPred)a, (TPred)b);
        }
        if (ca == TUnion.class) {
            return Types.equals((TUnion)a, (TUnion)b);
        }
        return false;
    }

    public static TForAll forAll(TVar parameter, Type type) {
        return new TForAll(parameter, type);
    }

    public static Type forAll(TVar[] parameters, Type type) {
        int i = parameters.length - 1;
        while (i >= 0) {
            type = Types.forAll(parameters[i], type);
            --i;
        }
        return type;
    }

    public static ArrayList<TVar> freeVars(Type type) {
        ArrayList<TVar> vars = new ArrayList<TVar>(2);
        type.collectFreeVars(vars);
        return vars;
    }

    public static ArrayList<TVar> freeVars(Type[] types) {
        ArrayList<TVar> vars = new ArrayList<TVar>(2);
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            type.collectFreeVars(vars);
            ++n2;
        }
        return vars;
    }

    public static TVar[] freeVarsArray(Type type) {
        ArrayList<TVar> vars = Types.freeVars(type);
        return vars.toArray(new TVar[vars.size()]);
    }

    public static TVar[] freeVarsArray(Type[] types) {
        ArrayList<TVar> vars = Types.freeVars(types);
        return vars.toArray(new TVar[vars.size()]);
    }

    public static TPred pred(TCon typeClass, Type ... parameters) {
        return new TPred(typeClass, parameters);
    }

    public static Type function(Type ... types) {
        Type result = types[types.length - 1];
        int i = types.length - 2;
        while (i >= 0) {
            result = Types.function(types[i], result);
            --i;
        }
        return result;
    }

    public static Type function(Type from, Type to) {
        return new TFun(from, NO_EFFECTS, to);
    }

    public static Type function(Type[] from, Type to) {
        int i = from.length - 1;
        while (i >= 0) {
            to = Types.function(from[i], to);
            --i;
        }
        return to;
    }

    public static TFun functionE(Type from, Type effect, Type to) {
        return new TFun(from, effect, to);
    }

    public static Type functionE(Type[] from, Type effect, Type to) {
        int i = from.length - 1;
        while (i >= 0) {
            to = Types.functionE(from[i], effect, to);
            effect = NO_EFFECTS;
            --i;
        }
        return to;
    }

    public static Type removeForAll(Type type, ArrayList<TVar> vars) {
        block2: {
            while (true) {
                if (type instanceof TForAll) {
                    TForAll forAll = (TForAll)type;
                    type = forAll.type;
                    vars.add(forAll.var);
                    continue;
                }
                if (!(type instanceof TMetaVar)) break block2;
                TMetaVar var = (TMetaVar)type;
                if (var.ref == null) break;
                type = var.ref;
            }
            return type;
        }
        return type;
    }

    public static Type removeForAll(Type type) {
        block2: {
            while (true) {
                if (type instanceof TForAll) {
                    TForAll forAll = (TForAll)type;
                    type = forAll.type;
                    continue;
                }
                if (!(type instanceof TMetaVar)) break block2;
                TMetaVar var = (TMetaVar)type;
                if (var.ref == null) break;
                type = var.ref;
            }
            return type;
        }
        return type;
    }

    public static Type instantiate(TForAll forAll, ArrayList<TMetaVar> vars) {
        TMetaVar metaVar = Types.metaVar(forAll.var.getKind());
        vars.add(metaVar);
        return Types.instantiate(forAll.type.replace(forAll.var, metaVar), vars);
    }

    public static Type instantiate(Type type, ArrayList<TMetaVar> vars) {
        if (type == null) {
            throw new NullPointerException();
        }
        if ((type = Types.canonical(type)) instanceof TForAll) {
            return Types.instantiate((TForAll)type, vars);
        }
        return type;
    }

    public static Type list(Type parameter) {
        return Types.apply((Type)LIST, parameter);
    }

    public static Type vector(Type parameter) {
        return Types.apply((Type)VECTOR, parameter);
    }

    public static Type mvector(Type parameter) {
        return Types.apply((Type)MVECTOR, parameter);
    }

    public static MultiFunction matchFunction(Type type, int arity) throws MatchException {
        if (type instanceof TForAll) {
            return Types.matchFunction(((TForAll)type).type, arity);
        }
        type = Types.canonical(type);
        Type[] parameterTypes = new Type[arity];
        Type effect = NO_EFFECTS;
        int i = 0;
        while (i < arity) {
            if (type instanceof TFun) {
                TFun fun = (TFun)type;
                parameterTypes[i] = fun.domain;
                type = Types.canonical(fun.range);
                if (i == arity - 1) {
                    effect = fun.effect;
                } else if (Types.canonical(fun.effect) != NO_EFFECTS) {
                    throw new MatchException();
                }
            } else {
                throw new MatchException();
            }
            ++i;
        }
        return new MultiFunction(parameterTypes, effect, type);
    }

    public static boolean isApply(Type func, int arity, Type type) {
        while (arity-- > 0) {
            if (!((type = Types.canonical(type)) instanceof TApply)) {
                return false;
            }
            type = ((TApply)type).function;
        }
        return Types.equals(func, type);
    }

    public static Type matchApply(TCon func, Type type) throws MatchException {
        if ((type = Types.canonical(type)) instanceof TApply) {
            TApply apply = (TApply)type;
            Type f = Types.canonical(apply.function);
            if (f.equals(func)) {
                return Types.canonical(apply.parameter);
            }
        }
        throw new MatchException();
    }

    public static MultiApply matchApply(Type type) {
        Type[] parametersArray;
        ArrayList<Type> parameters = new ArrayList<Type>();
        type = Types.canonical(type);
        while (type instanceof TApply) {
            TApply apply = (TApply)type;
            parameters.add(Types.canonical(apply.parameter));
            type = Types.canonical(apply.function);
        }
        if (parameters.isEmpty()) {
            parametersArray = Type.EMPTY_ARRAY;
        } else {
            parametersArray = new Type[parameters.size()];
            int i = 0;
            int j = parametersArray.length - 1;
            while (i < parametersArray.length) {
                parametersArray[i] = (Type)parameters.get(j);
                ++i;
                --j;
            }
        }
        return new MultiApply(type, parametersArray);
    }

    public static Type unifyApply(TCon func, Type type) throws MatchException {
        if ((type = Types.canonical(type)) instanceof TApply) {
            TApply apply = (TApply)type;
            Type f = Types.canonical(apply.function);
            if (f.equals(func)) {
                return Types.canonical(apply.parameter);
            }
            if (f instanceof TMetaVar) {
                try {
                    ((TMetaVar)f).setRef(func);
                    return Types.canonical(apply.parameter);
                }
                catch (UnificationException unificationException) {
                    throw new MatchException();
                }
            }
        } else if (type instanceof TMetaVar) {
            TMetaVar parameter = Types.metaVar(Kinds.metaVar());
            try {
                ((TMetaVar)type).setRef(Types.apply((Type)func, (Type)parameter));
            }
            catch (UnificationException unificationException) {
                throw new MatchException();
            }
            return parameter;
        }
        throw new MatchException();
    }

    public static MultiFunction matchFunction(Type type) {
        type = Types.canonical(type);
        while (type instanceof TForAll) {
            type = Types.canonical(((TForAll)type).type);
        }
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        Type effect = NO_EFFECTS;
        while (type instanceof TFun) {
            TFun fun = (TFun)type;
            parameterTypes.add(fun.domain);
            type = Types.canonical(fun.range);
            if (Types.canonical(fun.effect) == NO_EFFECTS) continue;
            effect = fun.effect;
            break;
        }
        return new MultiFunction(parameterTypes.toArray(new Type[parameterTypes.size()]), effect, type);
    }

    public static MultiFunction unifyFunction(Type type, int arity) throws UnificationException {
        Type[] parameterTypes = new Type[arity];
        int i = 0;
        while (i < arity) {
            parameterTypes[i] = Types.metaVar(Kinds.STAR);
            ++i;
        }
        Type effect = Types.metaVar(Kinds.EFFECT);
        Type requiredType = Types.metaVar(Kinds.STAR);
        MultiFunction result = new MultiFunction(parameterTypes, effect, requiredType);
        int i2 = arity - 1;
        while (i2 >= 0) {
            requiredType = Types.functionE(parameterTypes[i2], effect, requiredType);
            effect = NO_EFFECTS;
            --i2;
        }
        Types.unify(type, requiredType);
        return result;
    }

    private static Type getRangeIfFunction(Type type) {
        if ((type = Types.canonical(type)) instanceof TFun) {
            return ((TFun)type).range;
        }
        return null;
    }

    public static int getArity(Type type) {
        int arity = 0;
        while ((type = Types.getRangeIfFunction(type)) != null) {
            ++arity;
        }
        return arity;
    }

    public static TMetaVar metaVar(Kind kind) {
        return new TMetaVar(kind);
    }

    public static Type constrained(TPred constraint, Type type) {
        return new TFun(constraint, NO_EFFECTS, type);
    }

    public static Type constrained(TPred[] constraints, Type type) {
        int i = constraints.length - 1;
        while (i >= 0) {
            type = Types.constrained(constraints[i], type);
            --i;
        }
        return type;
    }

    public static TMultiApply toMultiApply(Type type) {
        ArrayList<Type> parameters = new ArrayList<Type>();
        type = Types.canonical(type);
        while (type instanceof TApply) {
            TApply apply = (TApply)type;
            parameters.add(apply.parameter);
            type = Types.canonical(apply.function);
        }
        Collections.reverse(parameters);
        return new TMultiApply(type, parameters);
    }

    public static Type tuple(Type ... parameters) {
        if (parameters.length == 1) {
            return parameters[0];
        }
        return Types.apply((Type)Types.tupleConstructor(parameters.length), parameters);
    }

    public static TCon tupleConstructor(int arity) {
        if (arity < 0 || arity == 1) {
            throw new IllegalArgumentException("The arity of a tuple cannot be " + arity + ".");
        }
        TCon[] oldTupleCache = tupleCache;
        if (oldTupleCache.length <= arity) {
            int oldLength = oldTupleCache.length;
            int newLength = oldLength * 2;
            while (newLength <= arity) {
                newLength *= 2;
            }
            TCon[] newTupleCache = Arrays.copyOf(oldTupleCache, newLength);
            int i = oldLength;
            while (i < newLength) {
                StringBuilder b = new StringBuilder();
                b.append('(');
                int j = 1;
                while (j < i) {
                    b.append(',');
                    ++j;
                }
                b.append(')');
                newTupleCache[i] = Types.con(BUILTIN, b.toString());
                ++i;
            }
            TCon result = newTupleCache[arity];
            tupleCache = newTupleCache;
            return result;
        }
        return oldTupleCache[arity];
    }

    public static void unify(TFun a, TFun b) throws UnificationException {
        Types.unify(a.domain, b.domain);
        Types.unify(a.effect, b.effect);
        Types.unify(a.range, b.range);
    }

    public static void unify(TApply a, TApply b) throws UnificationException {
        Types.unify(a.function, b.function);
        Types.unify(a.parameter, b.parameter);
    }

    public static void unify(TForAll a, TForAll b) throws UnificationException {
        try {
            Kinds.unify(a.var.getKind(), b.var.getKind());
        }
        catch (KindUnificationException kindUnificationException) {
            throw new UnificationException(a, b);
        }
        TVar newVar = Types.var(a.var.getKind());
        Types.unify(a.type.replace(a.var, newVar), b.type.replace(b.var, newVar));
    }

    public static void unify(TPred a, TPred b) throws UnificationException {
        if (a.typeClass != b.typeClass || a.parameters.length != b.parameters.length) {
            throw new UnificationException(a, b);
        }
        int i = 0;
        while (i < a.parameters.length) {
            Types.unify(a.parameters[i], b.parameters[i]);
            ++i;
        }
    }

    public static void unify(TUnion a, TUnion b) throws UnificationException {
        if (a.effects.length != b.effects.length) {
            throw new UnificationException(a, b);
        }
        int i = 0;
        while (i < a.effects.length) {
            Types.unify(a.effects[i], b.effects[i]);
            ++i;
        }
    }

    public static void unify(Type a, Type b) throws UnificationException {
        Class<?> cb;
        if ((a = Types.canonical(a)) == (b = Types.canonical(b))) {
            return;
        }
        if (a instanceof TMetaVar) {
            ((TMetaVar)a).setRef(b);
            return;
        }
        if (b instanceof TMetaVar) {
            ((TMetaVar)b).setRef(a);
            return;
        }
        b = Types.canonical(b);
        Class<?> ca = a.getClass();
        if (ca != (cb = b.getClass())) {
            throw new UnificationException(a, b);
        }
        if (ca == TApply.class) {
            Types.unify((TApply)a, (TApply)b);
        } else if (ca == TFun.class) {
            Types.unify((TFun)a, (TFun)b);
        } else if (ca == TForAll.class) {
            Types.unify((TForAll)a, (TForAll)b);
        } else if (ca == TPred.class) {
            Types.unify((TPred)a, (TPred)b);
        } else if (ca == TUnion.class) {
            Types.unify((TUnion)a, (TUnion)b);
        } else {
            throw new UnificationException(a, b);
        }
    }

    public static TVar var(Kind kind) {
        return new TVar(kind);
    }

    public static TVar[] vars(TVar[] otherVars) {
        TVar[] vars = new TVar[otherVars.length];
        int i = 0;
        while (i < otherVars.length) {
            vars[i] = Types.var(otherVars[i].getKind());
            ++i;
        }
        return vars;
    }

    public static Type instantiate(Type type, Type ... parameters) {
        int i = 0;
        while (i < parameters.length) {
            if (!((type = Types.canonical(type)) instanceof TForAll)) {
                throw new IllegalArgumentException();
            }
            TForAll forAll = (TForAll)type;
            type = forAll.type.replace(forAll.var, parameters[i]);
            ++i;
        }
        return type;
    }

    public static Type[] getTypes(Typed[] values) {
        Type[] types = new Type[values.length];
        int i = 0;
        while (i < values.length) {
            types[i] = values[i].getType();
            ++i;
        }
        return types;
    }

    public static boolean match(Type a, Type b, THashMap<TVar, Type> substitution) {
        b = Types.canonical(b);
        Class<?> ca = a.getClass();
        if (ca == TVar.class) {
            TVar ta = (TVar)a;
            Type t = (Type)substitution.get((Object)ta);
            if (t == null) {
                substitution.put((Object)ta, (Object)b);
                return true;
            }
            return Types.match(t, b, substitution);
        }
        if (a == b) {
            return true;
        }
        Class<?> cb = b.getClass();
        if (ca != cb || ca == TCon.class) {
            return false;
        }
        if (ca == TApply.class) {
            return Types.match((TApply)a, (TApply)b, substitution);
        }
        if (ca == TFun.class) {
            return Types.match((TFun)a, (TFun)b, substitution);
        }
        if (ca == TPred.class) {
            return Types.match((TPred)a, (TPred)b, substitution);
        }
        throw new UnsupportedOperationException("match(" + a + ", " + b + ") not supported");
    }

    public static boolean match(TApply a, TApply b, THashMap<TVar, Type> substitution) {
        return Types.match(a.function, b.function, substitution) && Types.match(a.parameter, b.parameter, substitution);
    }

    public static boolean match(TPred a, TPred b, THashMap<TVar, Type> substitution) {
        if (a.typeClass != b.typeClass || a.parameters.length != b.parameters.length) {
            return false;
        }
        int i = 0;
        while (i < a.parameters.length) {
            if (!Types.match(a.parameters[i], b.parameters[i], substitution)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean match(TFun a, TFun b, THashMap<TVar, Type> substitution) {
        return Types.match(a.domain, b.domain, substitution) && Types.match(a.effect, b.effect, substitution) && Types.match(a.range, b.range, substitution);
    }

    public static Type removePred(Type type, ArrayList<TPred> preds) {
        while (type instanceof TFun) {
            TFun pred = (TFun)type;
            if (!(pred.domain instanceof TPred)) break;
            preds.add((TPred)pred.domain);
            type = Types.canonical(pred.range);
        }
        return type;
    }

    public static <T extends Typed> Type[] getTypes(List<T> vars) {
        Type[] result = new Type[vars.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = ((Typed)vars.get(i)).getType();
            ++i;
        }
        return result;
    }

    public static boolean isBoxed(Type type) {
        while (true) {
            if (type instanceof TVar) {
                return true;
            }
            if (type instanceof TApply) {
                TApply apply = (TApply)type;
                Type function = Types.canonical(apply.function);
                if (function == MAYBE || function == MVECTOR || function == VECTOR) {
                    type = apply.parameter;
                    continue;
                }
                type = function;
                continue;
            }
            if (type instanceof TMetaVar) {
                type = ((TMetaVar)type).ref;
                if (type != null) continue;
                return true;
            }
            if (!(type instanceof TForAll)) break;
            type = ((TForAll)type).type;
        }
        return false;
    }

    public static boolean isFunction(Type type) {
        type = Types.canonical(type);
        return type instanceof TFun;
    }

    public static boolean equals(Type[] as, Type[] bs) {
        if (as.length != bs.length) {
            return false;
        }
        int i = 0;
        while (i < as.length) {
            if (!Types.equals(as[i], bs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toString(Type[] types) {
        StringBuilder b = new StringBuilder();
        TypeUnparsingContext tuc = new TypeUnparsingContext();
        b.append('[');
        boolean first = true;
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(type.toString(tuc));
            ++n2;
        }
        b.append(']');
        return b.toString();
    }

    public static TCon getConstructor(Type type) throws MatchException {
        while (true) {
            if (type instanceof TCon) {
                return (TCon)type;
            }
            if (type instanceof TApply) {
                type = ((TApply)type).function;
                continue;
            }
            if (!(type instanceof TMetaVar)) break;
            Type ref = ((TMetaVar)type).ref;
            if (ref == null) {
                throw new MatchException();
            }
            type = ref;
        }
        throw new MatchException();
    }

    public static Type[] replace(Type[] types, TVar[] from, Type[] to) {
        if (types.length == 0) {
            return Type.EMPTY_ARRAY;
        }
        Type[] result = new Type[types.length];
        int i = 0;
        while (i < types.length) {
            result[i] = types[i].replace(from, to);
            ++i;
        }
        return result;
    }

    public static TPred[] replace(TPred[] types, TVar[] from, Type[] to) {
        if (types.length == 0) {
            return TPred.EMPTY_ARRAY;
        }
        TPred[] result = new TPred[types.length];
        int i = 0;
        while (i < types.length) {
            result[i] = (TPred)types[i].replace(from, to);
            ++i;
        }
        return result;
    }

    public static <T extends Type> Type[] replace(Type[] types, THashMap<TVar, T> map) {
        if (types.length == 0) {
            return Type.EMPTY_ARRAY;
        }
        Type[] result = new Type[types.length];
        int i = 0;
        while (i < types.length) {
            result[i] = types[i].replace(map);
            ++i;
        }
        return result;
    }

    public static Type union(Type ... effects) {
        if (effects.length == 0) {
            return NO_EFFECTS;
        }
        if (effects.length == 1) {
            return effects[0];
        }
        return new TUnion(effects);
    }

    public static Type union(Type effect1, Type effect2) {
        return new TUnion(effect1, effect2);
    }

    public static Type union(List<Type> effects) {
        if (effects.size() == 0) {
            return NO_EFFECTS;
        }
        if (effects.size() == 1) {
            return effects.get(0);
        }
        return new TUnion(effects.toArray(new Type[effects.size()]));
    }

    public static void canonize(Type[] types) {
        int i = 0;
        while (i < types.length) {
            types[i] = Types.canonical(types[i]);
            ++i;
        }
    }

    public static Type simplifyFinalEffect(Type effect) {
        if ((effect = Types.canonical(effect)) instanceof TMetaVar) {
            try {
                TVar t = Types.var(Kinds.EFFECT);
                ((TMetaVar)effect).setRef(t);
                return t;
            }
            catch (UnificationException e) {
                throw new RuntimeException(e);
            }
        }
        if (effect instanceof TUnion) {
            TUnion union = (TUnion)effect;
            if (union.effects.length == 0) {
                return NO_EFFECTS;
            }
            ArrayList<Type> effects = new ArrayList<Type>(union.effects.length);
            Type[] typeArray = union.effects;
            int n = union.effects.length;
            int n2 = 0;
            while (n2 < n) {
                Type c = typeArray[n2];
                if ((c = Types.simplifyFinalEffect(c)) instanceof TUnion) {
                    Type[] typeArray2 = ((TUnion)c).effects;
                    int n3 = ((TUnion)c).effects.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Type c2 = typeArray2[n4];
                        effects.add(c2);
                        ++n4;
                    }
                } else {
                    effects.add(c);
                }
                ++n2;
            }
            return Types.union(effects);
        }
        return effect;
    }

    public static Type simplifyType(Type effect) {
        if ((effect = Types.canonical(effect)) instanceof TUnion) {
            TUnion union = (TUnion)effect;
            if (union.effects.length == 0) {
                return NO_EFFECTS;
            }
            THashSet effects = new THashSet(union.effects.length);
            Type[] typeArray = union.effects;
            int n = union.effects.length;
            int n2 = 0;
            while (n2 < n) {
                Type c = typeArray[n2];
                if ((c = Types.simplifyFinalEffect(c)) instanceof TUnion) {
                    Type[] typeArray2 = ((TUnion)c).effects;
                    int n3 = ((TUnion)c).effects.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Type c2 = typeArray2[n4];
                        effects.add((Object)c2);
                        ++n4;
                    }
                } else {
                    effects.add((Object)c);
                }
                ++n2;
            }
            return Types.union((Type[])effects.toArray((Object[])new Type[effects.size()]));
        }
        return effect;
    }

    public static Type parseType(ITypeEnvironment environment, String text) throws SCLTypeParseException {
        return Types.parseType(new TypeElaborationContext(environment), text);
    }

    public static Type parseType(ITypeEnvironment environment, THashMap<String, TVar> localTypeVars, String text) throws SCLTypeParseException {
        return Types.parseType(new TypeElaborationContext(localTypeVars, environment), text);
    }

    public static Type parseType(String text) throws SCLTypeParseException {
        return Types.parseType(new TypeElaborationContext(DUMMY_TYPE_ENVIRONMENT), text);
    }

    public static Type parseType(THashMap<String, TVar> localTypeVars, String text) throws SCLTypeParseException {
        return Types.parseType(new TypeElaborationContext(localTypeVars, DUMMY_TYPE_ENVIRONMENT), text);
    }

    private static Type parseType(TypeElaborationContext context, String text) throws SCLTypeParseException {
        SCLParserImpl parser = new SCLParserImpl(new StringReader(text));
        try {
            TypeAst ast = (TypeAst)parser.parseType();
            return ast.toType(context);
        }
        catch (SCLSyntaxErrorException e) {
            throw new SCLTypeParseException(new Problem(Locations.beginOf(e.location), Locations.endOf(e.location), e.getMessage()));
        }
    }

    public static Type instantiateAndStrip(Type type) {
        while (true) {
            if (type instanceof TForAll) {
                TForAll forAll = (TForAll)type;
                type = forAll.type.replace(forAll.var, Types.metaVar(forAll.var.getKind()));
                continue;
            }
            if (type instanceof TFun) {
                TFun fun = (TFun)type;
                if (fun.domain instanceof TPred || fun.domain == PUNIT) {
                    type = fun.range;
                    continue;
                }
                return type;
            }
            if (!(type instanceof TMetaVar)) break;
            TMetaVar metaVar = (TMetaVar)type;
            if (metaVar.ref == null) {
                return type;
            }
            type = metaVar.ref;
        }
        return type;
    }
}

