/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.types;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.modules.TypeAlias;
import org.simantics.scl.compiler.elaboration.modules.TypeConstructor;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TForAll;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.util.Typed;

public class JavaTypeTranslator {
    Environment environment;
    Type[] parameters = new Type[32];

    public JavaTypeTranslator(Environment environment) {
        this.environment = environment;
    }

    private void reverseParameters(int len) {
        len >>= 1;
        int i = 0;
        while (i < len) {
            Type temp = this.parameters[i];
            this.parameters[i] = this.parameters[len - i - 1];
            this.parameters[len - i - 1] = temp;
            ++i;
        }
    }

    private TypeConstructor getTypeConstructor(TCon con) {
        TypeDescriptor typeDescriptor = this.environment.getTypeDescriptor(con);
        if (typeDescriptor == null) {
            throw new InternalCompilerError("Didn't find type constructor " + con.module + "/" + con.name + ".");
        }
        if (typeDescriptor instanceof TypeAlias) {
            throw new InternalCompilerError("Type " + con.module + "/" + con.name + " is a type alias.");
        }
        return (TypeConstructor)typeDescriptor;
    }

    public TypeDesc toTypeDesc(Type type) {
        block8: {
            while (true) {
                if (type instanceof TCon) {
                    return this.getTypeConstructor((TCon)type).construct(this, Type.EMPTY_ARRAY);
                }
                if (type instanceof TApply) {
                    int i = 0;
                    do {
                        TApply apply = (TApply)type;
                        this.parameters[i++] = Types.canonical(apply.parameter);
                        type = Types.canonical(apply.function);
                        if (!(type instanceof TCon)) continue;
                        this.reverseParameters(i);
                        return this.getTypeConstructor((TCon)type).construct(this, this.parameters);
                    } while (type instanceof TApply);
                    if (!(type instanceof TVar)) continue;
                    return TypeDesc.OBJECT;
                }
                if (type instanceof TVar) {
                    return TypeDesc.OBJECT;
                }
                if (type instanceof TFun) {
                    return Constants.FUNCTION;
                }
                if (type instanceof TForAll) {
                    type = ((TForAll)type).type;
                    continue;
                }
                if (type instanceof TPred) {
                    TPred funcApply = (TPred)type;
                    return this.environment.getTypeClass(funcApply.typeClass).construct(this, funcApply.parameters);
                }
                if (!(type instanceof TMetaVar)) break block8;
                TMetaVar metaVar = (TMetaVar)type;
                if ((type = Types.canonical(metaVar)) instanceof TMetaVar) break;
            }
            return TypeDesc.OBJECT;
        }
        throw new IllegalArgumentException("Invalid type " + type + ".");
    }

    public TypeDesc getTypeDesc(Typed typed) {
        return this.toTypeDesc(typed.getType());
    }

    public TypeDesc[] toTypeDescs(Type[] types) {
        TypeDesc[] result = new TypeDesc[types.length];
        int i = 0;
        while (i < types.length) {
            result[i] = this.toTypeDesc(types[i]);
            ++i;
        }
        return result;
    }

    public TypeDesc[] toTypeDescs(Type[] types, Type type) {
        TypeDesc[] result = new TypeDesc[types.length + 1];
        int i = 0;
        while (i < types.length) {
            result[i] = this.toTypeDesc(types[i]);
            ++i;
        }
        result[types.length] = this.toTypeDesc(type);
        return result;
    }

    public TypeDesc[] getTypeDescs(Typed[] typeds) {
        TypeDesc[] result = new TypeDesc[typeds.length];
        int i = 0;
        while (i < typeds.length) {
            result[i] = this.getTypeDesc(typeds[i]);
            ++i;
        }
        return result;
    }

    public static TypeDesc[] filterVoid(TypeDesc[] tds) {
        int length = tds.length;
        TypeDesc[] typeDescArray = tds;
        int n = tds.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDesc td = typeDescArray[n2];
            if (td.equals(TypeDesc.VOID)) {
                --length;
            }
            ++n2;
        }
        if (length == tds.length) {
            return tds;
        }
        TypeDesc[] result = new TypeDesc[length];
        int j = 0;
        TypeDesc[] typeDescArray2 = tds;
        int n3 = tds.length;
        int n4 = 0;
        while (n4 < n3) {
            TypeDesc td = typeDescArray2[n4];
            if (!td.equals(TypeDesc.VOID)) {
                result[j++] = td;
            }
            ++n4;
        }
        return result;
    }

    public static TypeDesc toObjectType(TypeDesc td) {
        if (td.equals(TypeDesc.VOID)) {
            return Constants.TUPLE0;
        }
        return td.toObjectType();
    }
}

