/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions.list;

import java.util.Set;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.list.CompiledQualifier;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifier;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifierTransformer;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifierVisitor;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class ListGenerator
extends ListQualifier {
    public Expression pattern;
    public Expression value;

    public ListGenerator(Expression pattern, Expression value) {
        this.pattern = pattern;
        this.value = value;
    }

    @Override
    public void checkType(TypingContext context) {
        TMetaVar componentType = Types.metaVar(Kinds.STAR);
        this.value.checkType(context, Types.apply((Type)Types.LIST, (Type)componentType));
        this.pattern.checkTypeAsPattern(context, componentType);
    }

    @Override
    public CompiledQualifier compile(SimplificationContext context) {
        if (this.pattern instanceof EVariable) {
            return new CompiledQualifier(this.value, this.pattern);
        }
        Set<Variable> variables = this.pattern.getFreeVariables();
        Variable[] variableArray = variables.toArray(new Variable[variables.size()]);
        Expression[] variableExps = new Expression[variableArray.length];
        int i = 0;
        while (i < variableArray.length) {
            variableExps[i] = new EVariable(variableArray[i]);
            ++i;
        }
        Expression newPattern = context.tuple(variableExps);
        EVariable blank = context.blank();
        blank.getVariable().setType(this.pattern.getType());
        return new CompiledQualifier(context.concatMap(context.lambda(new Case(this.pattern, context.singletonList(newPattern.copy())), new Case(blank, context.emptyList(newPattern.getType()))), this.value), newPattern);
    }

    @Override
    public void resolve(TranslationContext context) {
        this.value = this.value.resolve(context);
        this.pattern = this.pattern.resolveAsPattern(context);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.pattern.setLocationDeep(loc);
            this.value.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ListQualifierVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ListQualifier accept(ListQualifierTransformer transformer) {
        return transformer.transform(this);
    }
}

