/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Types;

public class ByteConstant
extends Constant {
    byte value;

    public ByteConstant(byte value) {
        super(Types.BYTE);
        this.value = value;
    }

    @Override
    public void push(MethodBuilder mb) {
        mb.loadConstant(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public byte getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteConstant other = (ByteConstant)obj;
        return this.value == other.value;
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        mb.push(parameter, Types.BYTE);
        mb.loadConstant(this.value);
        mb.ifComparisonBranch(failure, "!=", TypeDesc.BYTE);
        mb.jump(success);
    }

    @Override
    public int constructorTag() {
        return 0;
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return this.value;
    }
}

