/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.compilation;

import gnu.trove.procedure.TObjectProcedure;
import java.util.Arrays;
import java.util.function.Consumer;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.rules.MappingRelation;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.environment.Namespace;
import org.simantics.scl.compiler.environment.filter.AcceptAllNamespaceFilter;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.types.TCon;

public class NamespaceOfModule
implements Namespace {
    private final Namespace base;
    private final Module module;

    public NamespaceOfModule(Namespace base, Module module) {
        this.base = base;
        this.module = module;
    }

    @Override
    public Namespace getNamespace(String name) {
        return this.base.getNamespace(name);
    }

    @Override
    public SCLValue getValue(String name) throws AmbiguousNameException {
        SCLValue value2;
        SCLValue value = this.module.getValue(name);
        try {
            value2 = this.base.getValue(name);
        }
        catch (AmbiguousNameException e) {
            if (value != null) {
                String[] conflictingModules = Arrays.copyOf(e.conflictingModules, e.conflictingModules.length + 1);
                conflictingModules[e.conflictingModules.length] = this.module.getName();
                throw new AmbiguousNameException(Arrays.asList(conflictingModules), e.name);
            }
            throw e;
        }
        if (value == null) {
            return value2;
        }
        if (value2 == null) {
            return value;
        }
        throw new AmbiguousNameException(Arrays.asList(value.getName().module, value2.getName().module), value.getName().name);
    }

    @Override
    public SCLRelation getRelation(String name) throws AmbiguousNameException {
        SCLRelation relation = this.module.getRelation(name);
        if (relation != null) {
            return relation;
        }
        return this.base.getRelation(name);
    }

    @Override
    public CHRRuleset getRuleset(String name) throws AmbiguousNameException {
        CHRRuleset ruleset = this.module.getRuleset(name);
        if (ruleset != null) {
            return ruleset;
        }
        return this.base.getRuleset(name);
    }

    @Override
    public SCLEntityType getEntityType(String name) throws AmbiguousNameException {
        SCLEntityType entityType = this.module.getEntityType(name);
        if (entityType != null) {
            return entityType;
        }
        return this.base.getEntityType(name);
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String name) throws AmbiguousNameException {
        TypeDescriptor typeDescriptor = this.module.getTypeDescriptor(name);
        if (typeDescriptor != null) {
            return typeDescriptor;
        }
        return this.base.getTypeDescriptor(name);
    }

    @Override
    public EffectConstructor getEffectConstructor(String name) throws AmbiguousNameException {
        EffectConstructor effectConstructor = this.module.getEffectConstructor(name);
        if (effectConstructor != null) {
            return effectConstructor;
        }
        return this.base.getEffectConstructor(name);
    }

    @Override
    public TypeClass getTypeClass(String name) throws AmbiguousNameException {
        TypeClass typeClass = this.module.getTypeClass(name);
        if (typeClass != null) {
            return typeClass;
        }
        return this.base.getTypeClass(name);
    }

    @Override
    public MappingRelation getMappingRelation(String name) throws AmbiguousNameException {
        MappingRelation mappingRelation = this.module.getMappingRelation(name);
        if (mappingRelation != null) {
            return mappingRelation;
        }
        return this.base.getMappingRelation(name);
    }

    @Override
    public TransformationRule getRule(String name) throws AmbiguousNameException {
        TransformationRule rule = this.module.getRule(name);
        if (rule != null) {
            return rule;
        }
        return this.base.getRule(name);
    }

    @Override
    public void findValuesForPrefix(String prefix, NamespaceFilter filter, TObjectProcedure<SCLValue> proc) {
        this.base.findValuesForPrefix(prefix, filter, proc);
        this.module.findValuesForPrefix(prefix, (NamespaceFilter)AcceptAllNamespaceFilter.INSTANCE, proc);
    }

    @Override
    public void findTypesForPrefix(String prefix, NamespaceFilter filter, Consumer<TCon> consumer) {
        this.base.findTypesForPrefix(prefix, filter, consumer);
        this.module.findTypesForPrefix(prefix, AcceptAllNamespaceFilter.INSTANCE, consumer);
    }
}

