/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.BackdoorAuthenticator;
import fi.vtt.simantics.procore.ProCoreServerReference;
import fi.vtt.simantics.procore.ProCoreSessionReference;
import fi.vtt.simantics.procore.internal.ClusterStream;
import fi.vtt.simantics.procore.internal.ClusterTranslatorImpl;
import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.GraphSessionVirtual;
import fi.vtt.simantics.procore.internal.GraphSessionVirtualInit;
import fi.vtt.simantics.procore.internal.QuerySupportImpl;
import fi.vtt.simantics.procore.internal.ResourceSupportImpl;
import fi.vtt.simantics.procore.internal.SerialisationSupportImpl;
import fi.vtt.simantics.procore.internal.ServerInformationImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.SessionRequestManager;
import fi.vtt.simantics.procore.internal.VirtualServer;
import fi.vtt.simantics.procore.internal.WriteSupportImpl;
import java.io.IOException;
import java.util.Set;
import org.simantics.db.RequestProcessor;
import org.simantics.db.ServerI;
import org.simantics.db.SessionReference;
import org.simantics.db.VirtualGraph;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InvalidAuthenticationException;
import org.simantics.db.exception.InvalidUserException;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.VirtualGraphImpl;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.service.ServerInformation;

public class SessionImplVirtual
extends SessionImplSocket {
    protected VirtualGraphImpl virtualGraphImpl;

    public SessionImplVirtual(UserAuthenticationAgent authAgent) throws DatabaseException {
        super(null, authAgent);
        this.init(authAgent, false);
    }

    public SessionImplVirtual(UserAuthenticationAgent authAgent, boolean init) throws DatabaseException {
        super(null, authAgent);
        this.init(authAgent, init);
    }

    private void init(UserAuthenticationAgent authAgent, boolean init) throws DatabaseException {
        ProCoreServerReference serverReference = new ProCoreServerReference();
        ProCoreSessionReference sessionReference = new ProCoreSessionReference(serverReference, -1L);
        this.graphSession = init ? new GraphSessionVirtualInit((SessionImplSocket)this, (SessionReference)sessionReference, this.virtualGraphServerSupport) : new GraphSessionVirtual((SessionImplSocket)this, (SessionReference)sessionReference, this.virtualGraphServerSupport);
        String databaseId = GraphSessionVirtual.serverInfo.databaseId;
        String serverId = GraphSessionVirtual.serverInfo.serverId;
        try {
            this.virtualGraphServerSupport.connect(String.valueOf(databaseId) + "." + serverId);
            this.virtualGraphImpl = (VirtualGraphImpl)this.virtualGraphServerSupport.getWorkspacePersistent("virtualGraph." + serverId);
            this.requestManager = new SessionRequestManager(this, this.state);
            this.clusterStream = new ClusterStream(this, this.graphSession, true);
            this.clusterTranslator = new ClusterTranslatorImpl(this);
            this.writeSupport = new WriteSupportImpl(this);
            this.resourceSupport = new ResourceSupportImpl(this);
            this.querySupport = new QuerySupportImpl(this, (ClusterSupport)this.clusterTranslator, new SerialisationSupportImpl(this), this.requestManager);
            this.queryProvider2 = new QueryProcessor(this.getAmountOfQueryThreads(), (QuerySupport)this.querySupport, (Set)this.sessionThreads);
            this.state.setGraphSession(this, this.graphSession, this.queryProvider2, this.clusterTable);
            ServerInformationImpl serverInfo = this.graphSession.getServerInformation();
            this.authenticator = authAgent.getAuthenticator((ServerInformation)serverInfo);
            if (this.authenticator == null) {
                throw new InvalidAuthenticationException("Authentication agent did not provide an authenticator");
            }
            if (this.authenticator instanceof BackdoorAuthenticator) {
                this.user = this.authenticator.getUser((RequestProcessor)this);
            }
        }
        catch (InvalidAuthenticationException e) {
            throw e;
        }
        catch (InvalidUserException e) {
            throw e;
        }
        catch (IOException e) {
            Logger.defaultLogError((String)"I/O error. See exception for details.", (Throwable)e);
            this.graphSession = null;
            throw new DatabaseException((Throwable)e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Logger.defaultLogError((String)"Unhandled error. See exception for details.", (Throwable)e);
            this.graphSession = null;
            throw new DatabaseException(e);
        }
        this.clusterStream.setOff(true);
    }

    public static ServerI newVirtualProCoreServer() {
        return new VirtualServer();
    }

    @Override
    protected VirtualGraph getProvider(VirtualGraph vg) {
        return vg != null ? vg : this.virtualGraphImpl;
    }

    @Override
    protected ResourceImpl getNewResource() throws DatabaseException {
        int newId = this.virtualGraphImpl.newResource(false);
        return new ResourceImpl((ResourceSupport)this.resourceSupport, newId);
    }

    @Override
    protected ServerInformation getCachedServerInformation() {
        GraphSession gs = this.graphSession;
        if (gs == null) {
            return null;
        }
        try {
            return gs.getServerInformation();
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((String)"Failed to get server info.", (Throwable)e);
            return null;
        }
    }
}

