/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.DomainProcessor3;
import org.simantics.db.layer0.util.TGConfigurer;
import org.simantics.db.layer0.util.TGValueModifier;
import org.simantics.db.request.ReadInterface;
import org.simantics.scl.runtime.function.Function1;

public class TransferableGraphConfiguration2 {
    public final TreeMap<String, Variant> baseExtensions = new TreeMap();
    public final Resource indexRoot;
    public final Collection<RootSpec> roots;
    public final Map<Resource, SubgraphExtent.ExtentStatus> preStatus;
    public final boolean ignoreVirtualResources;
    public final boolean validate;
    public boolean values = true;
    public Collection<TGValueModifier> valueModifiers;
    public Function1<Statement, DomainProcessor3.ExclusionDecision> exclusionFunction;

    public TransferableGraphConfiguration2(Resource indexRoot, Collection<RootSpec> roots, Map<Resource, SubgraphExtent.ExtentStatus> preStatus, boolean ignoreVirtualResources, boolean validate) {
        this.indexRoot = indexRoot;
        this.roots = roots;
        this.preStatus = preStatus;
        this.ignoreVirtualResources = ignoreVirtualResources;
        this.validate = validate;
        this.valueModifiers = null;
    }

    public TransferableGraphConfiguration2(Resource indexRoot, Collection<RootSpec> roots, Map<Resource, SubgraphExtent.ExtentStatus> preStatus, boolean ignoreVirtualResources) {
        this(indexRoot, roots, preStatus, ignoreVirtualResources, true);
    }

    public TransferableGraphConfiguration2(Resource indexRoot, Collection<RootSpec> roots, Map<Resource, SubgraphExtent.ExtentStatus> preStatus) {
        this(indexRoot, roots, preStatus, true);
    }

    public TransferableGraphConfiguration2(TransferableGraphConfiguration2 conf) throws DatabaseException {
        this(conf.indexRoot, conf.roots, conf.preStatus, conf.ignoreVirtualResources, conf.validate);
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Resource model, boolean ignoreVirtualResources, boolean validate) throws DatabaseException {
        this(new TGConfigurer(graph, ignoreVirtualResources, validate).roots2(Collections.singletonList(model)).create());
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Collection<Resource> roots, boolean ignoreVirtualResources, boolean validate) throws DatabaseException {
        this(new TGConfigurer(graph, ignoreVirtualResources, validate).roots2(roots).create());
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Resource model, boolean ignoreVirtualResources) throws DatabaseException {
        this(graph, model, ignoreVirtualResources, true);
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Resource model) throws DatabaseException {
        this(graph, model, true);
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Collection<RootSpec> roots, Collection<Resource> resourceRoots, Collection<Resource> exclusions) throws DatabaseException {
        this(new TGConfigurer(graph, true).roots(roots).roots2(resourceRoots).exclusions(exclusions).create());
    }

    public TransferableGraphConfiguration2(ReadGraph graph, Collection<RootSpec> roots, Collection<Resource> resourceRoots, Collection<Resource> exclusions, boolean ignoreVirtualResource, boolean validate) throws DatabaseException {
        this(new TGConfigurer(graph, ignoreVirtualResource, validate).roots(roots).roots2(resourceRoots).exclusions(exclusions).create());
    }

    public static TransferableGraphConfiguration2 createWithNames(RequestProcessor processor, final Collection<NamedResource> roots, final Collection<Resource> exclusions, final boolean ignoreVirtualResource, final boolean validate) throws DatabaseException {
        return (TransferableGraphConfiguration2)processor.sync((ReadInterface)new UniqueRead<TransferableGraphConfiguration2>(){

            public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
                return new TransferableGraphConfiguration2(graph, TransferableGraphConfiguration2.translate(roots), Collections.emptyList(), exclusions, ignoreVirtualResource, validate);
            }
        });
    }

    public static TransferableGraphConfiguration2 createWithNames2(RequestProcessor processor, final Collection<RootSpec> roots, final Collection<Resource> exclusions, final boolean ignoreVirtualResource, final boolean validate) throws DatabaseException {
        return (TransferableGraphConfiguration2)processor.sync((ReadInterface)new UniqueRead<TransferableGraphConfiguration2>(){

            public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
                return new TransferableGraphConfiguration2(graph, roots, Collections.emptyList(), exclusions, ignoreVirtualResource, validate);
            }
        });
    }

    public static TransferableGraphConfiguration2 createWithNames(RequestProcessor processor, Collection<NamedResource> roots, Collection<Resource> exclusions) throws DatabaseException {
        return TransferableGraphConfiguration2.createWithNames(processor, roots, exclusions, true, true);
    }

    public static TransferableGraphConfiguration2 createWithResources(RequestProcessor processor, final Collection<Resource> roots, final Collection<Resource> exclusions) throws DatabaseException {
        return (TransferableGraphConfiguration2)processor.sync((ReadInterface)new UniqueRead<TransferableGraphConfiguration2>(){

            public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
                return new TransferableGraphConfiguration2(graph, Collections.emptyList(), roots, exclusions);
            }
        });
    }

    public static TransferableGraphConfiguration2 createForModel(RequestProcessor processor, Resource model) throws DatabaseException {
        return TransferableGraphConfiguration2.createWithResources(processor, Collections.singletonList(model), Collections.emptyList());
    }

    private static Collection<RootSpec> translate(Collection<NamedResource> roots) {
        ArrayList<RootSpec> result = new ArrayList<RootSpec>();
        for (NamedResource nr : roots) {
            result.add(new RootSpec(nr.getResource(), nr.getName(), true));
        }
        return result;
    }

    public static class RootSpec {
        public final Resource resource;
        public final String name;
        public final boolean internal;
        public final String type;

        public RootSpec(Resource resource, String name, boolean internal) {
            this(resource, name, internal, null);
        }

        public RootSpec(Resource resource, String name, boolean internal, String type) {
            if (resource == null) {
                throw new NullPointerException("null resource");
            }
            if (name == null) {
                throw new NullPointerException("null name");
            }
            this.resource = resource;
            this.name = name;
            this.internal = internal;
            this.type = type;
        }

        public String toString() {
            return "RootSpec[" + this.name + ", " + this.resource + ", " + this.internal + ", " + this.type + "]";
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.internal ? 1231 : 1237);
            result = 31 * result + this.resource.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RootSpec other = (RootSpec)obj;
            return this.internal == other.internal && this.resource.equals(other.resource) && this.name.equals(other.name) && this.objectEquals(this.type, other.type);
        }

        private boolean objectEquals(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null && o2 == null) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return o1.equals(o2);
        }
    }
}

