/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.db.service.ClusterControl;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.QueryControl;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.Callback;

public class SessionGarbageCollection {
    private static int DEFAULT_ALLOWED_TIME = 300;
    private static int DEFAULT_CLUSTER_TARGET = -1;

    public static int getDefaultQueryTarget() {
        return DEFAULT_ALLOWED_TIME;
    }

    public static void setDefaultAllowedTime(int a) {
        DEFAULT_ALLOWED_TIME = a;
    }

    public static int getDefaultClusterTarget() {
        return DEFAULT_CLUSTER_TARGET;
    }

    public static void setDefaultClusterTarget(int a) {
        DEFAULT_CLUSTER_TARGET = a;
    }

    public static boolean gc(IProgressMonitor monitor, Session session, boolean sync, Consumer<DatabaseException> errorCallback) {
        long took = SessionGarbageCollection.gc(monitor, session, sync, errorCallback, DEFAULT_ALLOWED_TIME, DEFAULT_CLUSTER_TARGET);
        return 16L * took / (long)DEFAULT_ALLOWED_TIME > 15L;
    }

    public static void gc(ReadGraph graph, int allowedTimeInMs, int clusterTarget) throws DatabaseException {
        SessionGarbageCollection.doIt(null, graph, allowedTimeInMs, clusterTarget);
    }

    private static void doIt(IProgressMonitor _monitor, ReadGraph graph, int allowedTimeInMs, int clusterTarget) {
        if (_monitor == null) {
            _monitor = new NullProgressMonitor();
        }
        QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
        ClusterControl cc = (ClusterControl)graph.getService(ClusterControl.class);
        _monitor.beginTask("Collect clusters", -1);
        cc.gc(graph, clusterTarget);
        _monitor.beginTask("Collect queries", -1);
        qc.gc(graph, allowedTimeInMs);
    }

    public static long gc(IProgressMonitor monitor, Session session, boolean sync, final Consumer<DatabaseException> errorCallback, final int allowedTimeInMs, final int clusterTarget) {
        DataContainer took;
        block8: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            final IProgressMonitor _monitor = monitor;
            if (session == null) {
                throw new NullPointerException("null session");
            }
            took = new DataContainer((Object)0L);
            WriteRequest request = new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    long start = System.nanoTime();
                    SessionGarbageCollection.doIt(_monitor, (ReadGraph)graph, allowedTimeInMs, clusterTarget);
                    long duration = System.nanoTime() - start;
                    took.set((Object)((long)((double)duration * 1.0E-6)));
                }
            };
            LifecycleSupport lfs = (LifecycleSupport)session.peekService(LifecycleSupport.class);
            if (lfs == null || lfs.isClosed() || lfs.isClosing()) {
                return 0L;
            }
            if (sync) {
                try {
                    session.syncRequest((Write)request);
                }
                catch (DatabaseException e) {
                    if (errorCallback != null) {
                        errorCallback.accept(e);
                        break block8;
                    }
                    Logger.defaultLogError((Throwable)e);
                }
            } else {
                session.asyncRequest((Write)request, (Callback)new Callback<DatabaseException>(){

                    public void run(DatabaseException e) {
                        if (e != null) {
                            if (errorCallback != null) {
                                errorCallback.accept(e);
                            } else {
                                Logger.defaultLogError((Throwable)e);
                            }
                        }
                    }
                });
            }
        }
        return (Long)took.get();
    }
}

