/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.internal;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Platform;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.ISessionContextProviderSource;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.utils.threads.ThreadUtils;

public class SimanticsInternal {
    private static ISessionContextProviderSource providerSource = null;
    private static SimanticsClipboard clipboard = SimanticsClipboard.EMPTY;

    public static void async(Runnable runnable) {
        ThreadUtils.getBlockingWorkExecutor().execute(runnable);
    }

    public static void async(Runnable runnable, int delay, TimeUnit unit) {
        ThreadUtils.getTimer().schedule(runnable, (long)delay, unit);
    }

    public static void asyncNonblocking(Runnable runnable) {
        ThreadUtils.getNonBlockingWorkExecutor().execute(runnable);
    }

    public static void asyncNonblocking(Runnable runnable, int initialDelay, int period) {
        ThreadUtils.getNonBlockingWorkExecutor().scheduleAtFixedRate(runnable, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    public static synchronized ISessionContext setSessionContext(ISessionContext ctx) {
        return SimanticsInternal.getSessionContextProvider().setSessionContext(ctx);
    }

    public static void setSessionContextProviderSource(ISessionContextProviderSource source) {
        if (source == null) {
            throw new IllegalArgumentException("null provider source");
        }
        providerSource = source;
    }

    public static ISessionContextProviderSource getProviderSource() {
        if (providerSource == null) {
            throw new IllegalStateException("providerSource must be initialized by the application before using class Simantics");
        }
        return providerSource;
    }

    public static ISessionContextProvider getSessionContextProvider() {
        return SimanticsInternal.getProviderSource().getActive();
    }

    public static ISessionContext getSessionContext() {
        ISessionContextProvider provider = SimanticsInternal.getSessionContextProvider();
        return provider != null ? provider.getSessionContext() : null;
    }

    public static Session getSession() {
        ISessionContext ctx = SimanticsInternal.getSessionContext();
        if (ctx == null) {
            throw new IllegalStateException("Session unavailable, no database session open");
        }
        return ctx.getSession();
    }

    public static Session peekSession() {
        ISessionContext ctx = SimanticsInternal.getSessionContext();
        return ctx == null ? null : ctx.peekSession();
    }

    public static Resource getProject() {
        ISessionContext ctx = SimanticsInternal.getSessionContext();
        if (ctx == null) {
            throw new IllegalStateException("No current database session");
        }
        return (Resource)ctx.getHint(SimanticsKeys.KEY_PROJECT);
    }

    public static Resource peekProject() {
        ISessionContext ctx = SimanticsInternal.getSessionContext();
        return ctx != null ? (Resource)ctx.getHint(SimanticsKeys.KEY_PROJECT) : null;
    }

    public static void setClipboard(SimanticsClipboard content) {
        if (content == null) {
            throw new NullPointerException("null clipboard content");
        }
        clipboard = content;
    }

    public static SimanticsClipboard getClipboard() {
        return clipboard;
    }

    public static Layer0 getLayer0() throws DatabaseException {
        return Layer0.getInstance((RequestProcessor)SimanticsInternal.getSession());
    }

    public static Layer0X getLayer0X() throws DatabaseException {
        return Layer0X.getInstance((RequestProcessor)SimanticsInternal.getSession());
    }

    public static <T> T sync(ReadInterface<T> r) throws DatabaseException {
        return (T)SimanticsInternal.getSession().sync(r);
    }

    public static <T> T sync(WriteInterface<T> r) throws DatabaseException {
        return (T)SimanticsInternal.getSession().sync(r);
    }

    public static File getTemporaryDirectory() {
        File workspace = Platform.getLocation().toFile();
        File temp = new File(workspace, "tempFiles");
        temp.mkdirs();
        return temp;
    }
}

