/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.reflection;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.internal.runtime.PlatformActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class OntologyVersions {
    private static final boolean PRINT = false;
    private static OntologyVersions INSTANCE;
    private final Pattern versionExtractPattern = Pattern.compile("^.*-(\\d+\\.\\d+)");
    private Map<String, String> unversionedToCurrent = new HashMap<String, String>();
    private Map<String, String> currentToUnversioned = new HashMap<String, String>();
    private final Pattern unversionedPattern;
    private final Pattern currentPattern;

    private OntologyVersions() {
        HashMap<String, Version> versions = new HashMap<String, Version>();
        Bundle[] bundleArray = PlatformActivator.getContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            URL url = bundle.getEntry("graph.tg");
            if (url != null) {
                String name = (String)bundle.getHeaders().get("Bundle-Name");
                Version osgiVersion = bundle.getVersion();
                Version previous = (Version)versions.get(name);
                if (previous == null || osgiVersion.compareTo(previous) > 0) {
                    versions.put(name, osgiVersion);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : versions.entrySet()) {
            int minor = ((Version)entry.getValue()).getMinor();
            int major = ((Version)entry.getValue()).getMajor();
            String unversioned = String.valueOf((String)entry.getKey()) + "-0.0";
            String versioned = String.valueOf((String)entry.getKey()) + "-" + major + "." + minor;
            this.unversionedToCurrent.put(unversioned, versioned);
            this.currentToUnversioned.put(versioned, unversioned);
        }
        this.unversionedPattern = Pattern.compile("(" + this.joinKeys(this.unversionedToCurrent) + ")");
        this.currentPattern = Pattern.compile("(" + this.joinKeys(this.currentToUnversioned) + ")");
    }

    public static OntologyVersions getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OntologyVersions();
        }
        return INSTANCE;
    }

    private String joinKeys(Map<String, String> tokens) {
        Set<String> keys = tokens.keySet();
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String key : keys) {
            if (!first) {
                b.append("|");
            }
            first = false;
            b.append(key);
        }
        return b.toString();
    }

    public String currentVersion(String text) {
        Matcher matcher = this.unversionedPattern.matcher(text);
        StringBuffer sb = new StringBuffer(text.length());
        while (matcher.find()) {
            matcher.appendReplacement(sb, this.unversionedToCurrent.get(matcher.group(1)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String unversioned(String text) {
        Matcher matcher = this.currentPattern.matcher(text);
        StringBuffer sb = new StringBuffer(text.length());
        while (matcher.find()) {
            matcher.appendReplacement(sb, this.currentToUnversioned.get(matcher.group(1)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String currentOntologyVersion(String ontologyURI) {
        String versionedURI = this.currentVersion(ontologyURI);
        Matcher m = this.versionExtractPattern.matcher(versionedURI);
        if (!m.matches()) {
            throw new IllegalArgumentException("Cannot extract version from ontology URI '" + ontologyURI + "' with pattern " + this.versionExtractPattern.pattern());
        }
        return m.group(1);
    }
}

