/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.contribution;

import org.eclipse.jface.resource.FontDescriptor;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.issues.ui.contribution.Constants;

public enum IssueLabelDecorationRule implements LabelDecorationRule
{
    INSTANCE;


    public static IssueLabelDecorationRule get() {
        return INSTANCE;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Resource issue = (Resource)content;
        final boolean hidden = graph.hasStatement(issue, IssueResource.getInstance((ReadGraph)graph).Hidden);
        final boolean user = graph.hasStatement(issue, IssueResource.getInstance((ReadGraph)graph).UserIssue);
        final boolean resolved = graph.hasStatement(issue, IssueResource.getInstance((ReadGraph)graph).Resolved);
        if (!(hidden || user || resolved)) {
            return null;
        }
        return new LabelDecorator.Stub(){

            public <F> F decorateFont(F font, String column, int itemIndex) {
                int style = 0;
                return (F)((style |= resolved ? 2 : 0) != 0 ? ((FontDescriptor)font).setStyle(style) : font);
            }

            public <C> C decorateForeground(C color, String column, int itemIndex) {
                if (hidden) {
                    return (C)Constants.HIDDEN_FG;
                }
                return color;
            }

            public <C> C decorateBackground(C color, String column, int itemIndex) {
                if (user) {
                    return (C)Constants.USER_BG;
                }
                return color;
            }
        };
    }
}

