/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor.participant;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.ui.AdaptionUtils;

public class SelectionUpdaterParticipant
extends AbstractDiagramParticipant {
    @DependencyReflection.Dependency
    Selection selection;

    @HintReflection.HintListener(Class=Selection.class, Field="SELECTION0")
    public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        IDiagram diagram = (IDiagram)sender.getHint(DiagramHints.KEY_DIAGRAM);
        Collection elements = AdaptionUtils.adaptToCollection((Object)newValue, IElement.class);
        if (diagram != null) {
            Session session = SimanticsUI.getSession();
            session.asyncRequest((Write)new ModifyDiagramSelection((VirtualGraph)session.getService(VirtualGraph.class), diagram, elements));
        }
    }

    @HintReflection.HintListener(Class=Selection.class, Field="SELECTION0")
    public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
        IDiagram diagram = (IDiagram)sender.getHint(DiagramHints.KEY_DIAGRAM);
        if (diagram != null) {
            Session session = SimanticsUI.getSession();
            session.asyncRequest((Write)new ModifyDiagramSelection((VirtualGraph)session.getService(VirtualGraph.class), diagram, null));
        }
    }

    private class ModifyDiagramSelection
    extends WriteRequest {
        IDiagram diagram;
        Collection<IElement> elements;

        public ModifyDiagramSelection(VirtualGraph provider, IDiagram diagram, Collection<IElement> elements) {
            super(provider);
            this.elements = elements;
            this.diagram = diagram;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            Resource diagramRuntime = (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RUNTIME_RESOURCE);
            if (diagramRuntime == null) {
                return;
            }
            SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
            DiagramResource DR = DiagramResource.getInstance((ReadGraph)graph);
            graph.deny(diagramRuntime, SR.ConfigurationDiagram_selection);
            if (this.elements != null) {
                for (IElement e : this.elements) {
                    Resource object = (Resource)e.getHint(ElementHints.KEY_OBJECT);
                    if (object == null || !graph.isInstanceOf(object, DR.Element)) continue;
                    graph.claim(diagramRuntime, SR.ConfigurationDiagram_selection, object);
                }
            }
        }
    }
}

