/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.actions;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class ActivateResultSetDatasetAction
implements IDoubleClickAction {
    public void doubleClickEvent(DoubleClickEvent e) throws DatabaseException {
        final Resource resultSet = ResourceAdaptionUtils.toSingleResource((Object)e.getResource());
        if (resultSet == null) {
            return;
        }
        ReadGraph graph = e.getGraph();
        if (graph.isInstanceOf(resultSet, SysdynResource.getInstance((ReadGraph)graph).ResultSet)) {
            graph.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    if (graph.isInstanceOf(resultSet, sr.ResultSet)) {
                        boolean resultShown = false;
                        Collection results = graph.getObjects(resultSet, sr.Experiment_result);
                        for (Resource result : results) {
                            if (!graph.hasStatement(result, sr.Result_showResult)) continue;
                            resultShown = true;
                            break;
                        }
                        for (Resource result : results) {
                            if (resultShown) {
                                graph.denyStatement(result, sr.Result_showResult, result);
                                continue;
                            }
                            graph.claim(result, sr.Result_showResult, result);
                        }
                    }
                }
            });
            e.consume();
        }
    }
}

