/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.charts.ui.CSVExportPage;
import org.simantics.charts.ui.CSVExportPlan;
import org.simantics.charts.ui.CSVExportPreferences;
import org.simantics.charts.ui.CSVExporter;
import org.simantics.db.management.ISessionContext;
import org.simantics.modeling.ui.utils.NoProjectPage;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class CSVExportWizard
extends Wizard
implements IExportWizard {
    private static final int MAX_RECENT_EXPORT_PATHS = 10;
    Deque<String> recentExportPaths;
    boolean overwrite;
    CSVExportPlan plan;

    private boolean readPreferences() {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        String recentPathsPref = store.getString("RECENT_CSV_EXPORT_LOCATIONS");
        this.recentExportPaths = CSVExportPreferences.decodePaths(recentPathsPref);
        this.overwrite = store.getBoolean("CSV_EXPORT_OVERWRITE");
        return true;
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        store.putValue("RECENT_CSV_EXPORT_LOCATIONS", CSVExportPreferences.encodePaths(this.recentExportPaths));
        store.setValue("CSV_EXPORT_OVERWRITE", this.plan.overwrite);
        if (store.needsSaving()) {
            store.save();
        }
    }

    public CSVExportWizard() {
        this.setWindowTitle("Export Subscription Data As CSV Text");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.readPreferences();
        ISessionContext ctx = SimanticsUI.getSessionContext();
        if (ctx == null) {
            return;
        }
        IProject project = (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
        if (project == null) {
            return;
        }
        this.plan = new CSVExportPlan(ctx, this.recentExportPaths);
        this.plan.project = project;
        this.plan.selection = selection;
        this.plan.overwrite = this.overwrite;
    }

    public void addPages() {
        super.addPages();
        if (this.plan != null) {
            this.addPage((IWizardPage)new CSVExportPage(this.plan));
        } else {
            this.addPage((IWizardPage)new NoProjectPage("Export Subscription Data As CSV Text"));
        }
    }

    public boolean performFinish() {
        try {
            this.recentExportPaths.addFirst(this.plan.exportLocation.getAbsolutePath());
            CSVExportPreferences.removeDuplicates(this.recentExportPaths);
            if (this.recentExportPaths.size() > 10) {
                this.recentExportPaths.pollLast();
            }
            this.writePreferences();
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((String)"Failed to write preferences", (Throwable)e);
        }
        File output = this.plan.exportLocation;
        if (output.exists()) {
            boolean ok;
            if (!this.plan.overwrite && !(ok = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Overwrite", (String)("A file by the name " + output.getAbsolutePath() + " already exists.\n\nDo you want to overwrite?")))) {
                return false;
            }
            if (!output.delete()) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Delete Problem", (String)("Could not overwrite previously existing file " + output));
                return false;
            }
        }
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new CSVExporter(this.plan));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            if (t instanceof IOException) {
                ErrorLogger.defaultLogError((String)"An I/O problem occurred while exporting subscription data. See exception for details.", (Throwable)t);
                cp.setErrorMessage("An I/O problem occurred while exporting subscription data.\n\nMessage: " + e.getMessage());
            } else {
                ErrorLogger.defaultLogError((String)"Unexpected exception while exporting subscription data. See exception for details.", (Throwable)t);
                cp.setErrorMessage("Unexpected exception while exporting subscription data. See error log for details.\n\nMessage: " + e.getMessage());
            }
            return false;
        }
        catch (InterruptedException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
            return false;
        }
        return true;
    }
}

